/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.msoffice.word;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.sequencer.msoffice.word.WordMetadata;

public class WordMetadataReader {
    private static final Logger log = Logger.getLogger(WordMetadataReader.class);
    private static final String HEADER_PREFIX = "Heading";

    public static WordMetadata instance(InputStream stream) throws IOException {
        WordMetadata metadata = new WordMetadata();
        ArrayList<WordMetadata.WordHeading> headings = new ArrayList<WordMetadata.WordHeading>();
        HWPFDocument document = new HWPFDocument(stream);
        Range range = document.getRange();
        StyleSheet stylesheet = document.getStyleSheet();
        for (int i = 0; i < range.numParagraphs(); ++i) {
            Paragraph paragraph = range.getParagraph(i);
            String styleName = stylesheet.getStyleDescription((int)paragraph.getStyleIndex()).getName();
            if (!styleName.startsWith(HEADER_PREFIX)) continue;
            String rawLevelNum = styleName.substring(HEADER_PREFIX.length() + 1).trim();
            int levelNum = 0;
            try {
                levelNum = Integer.parseInt(rawLevelNum);
            }
            catch (NumberFormatException nfe) {
                log.debug("Could not parse heading level from: " + styleName, new Object[0]);
            }
            String text = Paragraph.stripFields((String)paragraph.text());
            if ('\r' == text.charAt(text.length() - 1)) {
                text = text.substring(0, text.length() - 1);
            }
            headings.add(new WordMetadata.WordHeading(text, levelNum));
        }
        metadata.setHeadings(headings);
        return metadata;
    }
}

