/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.web.jcr.rest.client.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.jboss.dna.common.util.CheckArg;

public final class JsonUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static String decode(String text) throws UnsupportedEncodingException {
        CheckArg.isNotNull((Object)text, (String)"text");
        return URLDecoder.decode(text, DEFAULT_CHARSET);
    }

    public static String encode(String text) throws UnsupportedEncodingException {
        CheckArg.isNotNull((Object)text, (String)"text");
        StringBuilder encoded = new StringBuilder();
        for (char c : text.toCharArray()) {
            encoded.append(c == '/' ? Character.valueOf(c) : URLEncoder.encode(Character.toString(c), DEFAULT_CHARSET));
        }
        return encoded.toString();
    }

    public static String readInputStream(HttpURLConnection connection) throws IOException {
        int bytesRead;
        CheckArg.isNotNull((Object)connection, (String)"connection");
        InputStream stream = connection.getInputStream();
        byte[] bytes = new byte[1024];
        StringBuffer buff = new StringBuffer();
        while (-1 != (bytesRead = stream.read(bytes, 0, 1024))) {
            buff.append(new String(bytes, 0, bytesRead));
        }
        return buff.toString();
    }

    private JsonUtils() {
    }
}

