/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.web.jcr.rest.client.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.web.jcr.rest.client.domain.Repository;
import org.jboss.dna.web.jcr.rest.client.domain.Server;
import org.jboss.dna.web.jcr.rest.client.json.JsonNode;
import org.jboss.dna.web.jcr.rest.client.json.JsonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerNode
extends JsonNode {
    private final Logger logger = Logger.getLogger(ServerNode.class);
    private final Server server;

    public ServerNode(Server server) {
        super(server.getName());
        this.server = server;
    }

    @Override
    public URL getUrl() throws Exception {
        StringBuilder url = new StringBuilder(this.server.getUrl());
        if (url.lastIndexOf("/") == url.length() - 1) {
            url.delete(url.length() - 1, url.length() - 1);
        }
        url.append("/resources");
        return new URL(url.toString());
    }

    public URL getFindRepositoriesUrl() throws Exception {
        return new URL(this.getUrl().toString() + '/');
    }

    public Collection<Repository> getRepositories(String jsonResponse) throws Exception {
        CheckArg.isNotNull((Object)jsonResponse, (String)"jsonResponse");
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        this.logger.trace("getRepositories:jsonResponse={0}", new Object[]{jsonResponse});
        JSONObject jsonObj = new JSONObject(jsonResponse);
        Iterator itr = jsonObj.keys();
        while (itr.hasNext()) {
            String name = JsonUtils.decode((String)itr.next());
            Repository repository = new Repository(name, this.server);
            repositories.add(repository);
            this.logger.trace("getRepositories: adding repository={0}", new Object[]{repository});
        }
        return repositories;
    }
}

