/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.effigy.common;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.TransactionAttributeType;
import org.jboss.ejb3.effigy.ApplicationExceptionEffigy;
import org.jboss.ejb3.effigy.EnterpriseBeanEffigy;
import org.jboss.ejb3.effigy.InterceptorEffigy;
import org.jboss.ejb3.effigy.common.JBossApplicationExceptionEffigy;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossEnterpriseBeanEffigy
implements EnterpriseBeanEffigy {
    private static final ApplicationExceptionEffigy NULL = new JBossApplicationExceptionEffigy();
    private JBossEnterpriseBeanMetaData beanMetaData;
    private Class<?> ejbClass;
    private Collection<ApplicationExceptionEffigy> applicationExceptionEffigies;
    private Map<Class<?>, ApplicationExceptionEffigy> applicationExceptionEffigyMap = new ConcurrentHashMap();
    private Map<Method, TransactionAttributeType> methodApplicableTransactionAttributeTypes = new ConcurrentHashMap<Method, TransactionAttributeType>();

    public JBossEnterpriseBeanEffigy(ClassLoader classLoader, JBossEnterpriseBeanMetaData beanMetaData) throws ClassNotFoundException {
        this.beanMetaData = beanMetaData;
        this.ejbClass = classLoader.loadClass(beanMetaData.getEjbClass());
        this.applicationExceptionEffigies = this.createApplicationExceptionEffigies(classLoader, beanMetaData.getEjbJarMetaData().getAssemblyDescriptor());
        this.initTransactionAttributeTypesForMethods(classLoader, beanMetaData);
    }

    private Collection<ApplicationExceptionEffigy> createApplicationExceptionEffigies(ClassLoader classLoader, JBossAssemblyDescriptorMetaData assemblyDescriptorMetaData) throws ClassNotFoundException {
        if (assemblyDescriptorMetaData == null) {
            return null;
        }
        ApplicationExceptionsMetaData applicationExceptionsMetaData = assemblyDescriptorMetaData.getApplicationExceptions();
        if (applicationExceptionsMetaData == null) {
            return null;
        }
        LinkedList<ApplicationExceptionEffigy> applicationExceptionEffigies = new LinkedList<ApplicationExceptionEffigy>();
        for (ApplicationExceptionMetaData applicationExceptionMetaData : applicationExceptionsMetaData) {
            applicationExceptionEffigies.add(this.createApplicationExceptionEffigy(classLoader, applicationExceptionMetaData));
        }
        return applicationExceptionEffigies;
    }

    protected ApplicationExceptionEffigy createApplicationExceptionEffigy(ClassLoader classLoader, ApplicationExceptionMetaData metaData) throws ClassNotFoundException {
        return new JBossApplicationExceptionEffigy(classLoader, metaData);
    }

    private ApplicationExceptionEffigy findApplicationException(Class<?> exceptionClass) {
        for (ApplicationExceptionEffigy applicationExceptionEffigy : this.applicationExceptionEffigies) {
            if (!applicationExceptionEffigy.getExceptionClass().equals(exceptionClass)) continue;
            return applicationExceptionEffigy;
        }
        Class<?> superclass = exceptionClass.getSuperclass();
        if (superclass == null) {
            return null;
        }
        return this.findApplicationException(exceptionClass.getSuperclass());
    }

    public Iterable<InterceptorEffigy> getAllInterceptors() {
        throw new RuntimeException("NYI: org.jboss.ejb3.effigy.common.JBossEnterpriseBeanEffigy.getAllInterceptors");
    }

    public ApplicationExceptionEffigy getApplicationException(Class<?> exceptionClass) {
        if (this.applicationExceptionEffigies == null) {
            return null;
        }
        ApplicationExceptionEffigy applicationExceptionEffigy = this.applicationExceptionEffigyMap.get(exceptionClass);
        if (applicationExceptionEffigy == NULL) {
            return null;
        }
        if (applicationExceptionEffigy != null) {
            return applicationExceptionEffigy;
        }
        applicationExceptionEffigy = this.findApplicationException(exceptionClass);
        if (applicationExceptionEffigy == null) {
            this.applicationExceptionEffigyMap.put(exceptionClass, NULL);
        } else {
            this.applicationExceptionEffigyMap.put(exceptionClass, applicationExceptionEffigy);
        }
        return applicationExceptionEffigy;
    }

    public Iterable<Method> getAroundInvokes() {
        throw new RuntimeException("NYI: org.jboss.ejb3.effigy.common.JBossEnterpriseBeanEffigy.getAroundInvokes");
    }

    protected JBossEnterpriseBeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public Class<?> getEjbClass() {
        return this.ejbClass;
    }

    public Iterable<InterceptorEffigy> getInterceptors(Method method) {
        throw new RuntimeException("NYI: org.jboss.ejb3.effigy.common.JBossEnterpriseBeanEffigy.getInterceptors");
    }

    public String getName() {
        return this.beanMetaData.getEjbName();
    }

    public Iterable<Method> getPostConstructs() {
        throw new RuntimeException("NYI: org.jboss.ejb3.effigy.common.JBossEnterpriseBeanEffigy.getPostConstructs");
    }

    public Iterable<Method> getPreDestroys() {
        throw new RuntimeException("NYI: org.jboss.ejb3.effigy.common.JBossEnterpriseBeanEffigy.getPreDestroys");
    }

    public TransactionAttributeType getTransactionAttributeType(Method method) {
        return this.methodApplicableTransactionAttributeTypes.get(method);
    }

    private void initTransactionAttributeTypesForMethods(ClassLoader cl, JBossEnterpriseBeanMetaData enterpriseBeanMetaData) {
        String ejbName = enterpriseBeanMetaData.getEjbName();
        JBossAssemblyDescriptorMetaData assemblyDescriptorMetaData = enterpriseBeanMetaData.getJBossMetaData().getAssemblyDescriptor();
        if (assemblyDescriptorMetaData == null) {
            return;
        }
        ContainerTransactionsMetaData containerTransactions = assemblyDescriptorMetaData.getContainerTransactionsByEjbName(ejbName);
        if (containerTransactions == null) {
            return;
        }
        for (ContainerTransactionMetaData transactionMetaData : containerTransactions) {
            TransactionAttributeType txAttributeType = transactionMetaData.getTransAttribute();
            MethodsMetaData methods = transactionMetaData.getMethods();
            if (methods == null || methods.isEmpty()) continue;
            for (MethodMetaData methodMetaData : methods) {
                String methodName = methodMetaData.getMethodName();
                MethodParametersMetaData methodParams = methodMetaData.getMethodParams();
                String[] params = null;
                if (methodParams != null) {
                    params = (String[])methodParams.toArray(params);
                }
                MethodInterfaceType methodIntf = methodMetaData.getMethodIntf();
                try {
                    if (methodIntf != null) {
                        Class<?> declaringClass = this.getMethodInterface(cl, methodIntf);
                        Collection<Method> applicableMethods = this.findMethods(cl, declaringClass, methodName, params);
                        for (Method applicableMethod : applicableMethods) {
                            this.methodApplicableTransactionAttributeTypes.put(applicableMethod, txAttributeType);
                        }
                        continue;
                    }
                    Set<Class<?>> views = this.getAllViews(cl);
                    if (views == null) continue;
                    for (Class<?> view : views) {
                        Collection<Method> applicableMethods = this.findMethods(cl, view, methodName, params);
                        for (Method applicableMethod : applicableMethods) {
                            this.methodApplicableTransactionAttributeTypes.put(applicableMethod, txAttributeType);
                        }
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Could not process container managed transactions for bean: " + ejbName, cnfe);
                }
                catch (NoSuchMethodException nsme) {
                    throw new RuntimeException("Could not find method while processing container managed transactions for bean: " + ejbName, nsme);
                }
            }
        }
    }

    private Collection<Method> findMethods(ClassLoader cl, Class<?> klass, String methodName, String ... methodParams) throws NoSuchMethodException {
        if (methodName.equals("*")) {
            return Arrays.asList(klass.getMethods());
        }
        Class[] methodParamTypes = null;
        if (methodParams != null) {
            methodParamTypes = new Class[methodParams.length];
            int i = 0;
            for (String methodParam : methodParams) {
                try {
                    methodParamTypes[i++] = cl.loadClass(methodParam);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException(cnfe);
                }
            }
        }
        Method method = klass.getMethod(methodName, methodParamTypes);
        return Collections.singleton(method);
    }

    protected Class<?> getMethodInterface(ClassLoader cl, MethodInterfaceType methodIntf) throws ClassNotFoundException {
        return null;
    }

    protected Set<Class<?>> getAllViews(ClassLoader cl) {
        return Collections.emptySet();
    }
}

