/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers;

import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostInsertEventListener;
import org.jboss.envers.VersionsReader;
import org.jboss.envers.event.VersionsEventListener;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reader.VersionsReaderImpl;
import org.jboss.envers.tools.ArraysTools;

public class VersionsReaderFactory {
    private VersionsReaderFactory() {
    }

    public static VersionsReader get(Session session) throws VersionsException {
        SessionImplementor sessionImpl = (SessionImplementor)session;
        EventListeners listeners = sessionImpl.getListeners();
        for (PostInsertEventListener listener : listeners.getPostInsertEventListeners()) {
            if (!(listener instanceof VersionsEventListener) || !ArraysTools.arrayIncludesInstanceOf(listeners.getPostUpdateEventListeners(), VersionsEventListener.class) || !ArraysTools.arrayIncludesInstanceOf(listeners.getPostDeleteEventListeners(), VersionsEventListener.class)) continue;
            return new VersionsReaderImpl(((VersionsEventListener)listener).getVerCfg(), session, sessionImpl);
        }
        throw new VersionsException("You need install the org.jboss.envers.event.VersionsEventListener class as post insert, update and delete event listener.");
    }

    public static VersionsReader get(EntityManager entityManager) throws VersionsException {
        if (entityManager.getDelegate() instanceof Session) {
            return VersionsReaderFactory.get((Session)entityManager.getDelegate());
        }
        if (entityManager.getDelegate() instanceof EntityManager && entityManager.getDelegate() instanceof Session) {
            return VersionsReaderFactory.get((Session)entityManager.getDelegate());
        }
        throw new VersionsException("Hibernate EntityManager not present!");
    }
}

