/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration;

import java.util.HashMap;
import java.util.Map;
import org.jboss.envers.configuration.EntityConfiguration;
import org.jboss.envers.configuration.RelationDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitiesConfigurations {
    private Map<String, EntityConfiguration> entitiesConfigurations;
    private Map<String, String> entityNamesForVersionsEntityNames = new HashMap<String, String>();

    public EntitiesConfigurations(Map<String, EntityConfiguration> entitiesConfigurations) {
        this.entitiesConfigurations = entitiesConfigurations;
        this.generateBidirectionRelationInfo();
        this.generateVersionsEntityToEntityNames();
    }

    private void generateVersionsEntityToEntityNames() {
        this.entityNamesForVersionsEntityNames = new HashMap<String, String>();
        for (String entityName : this.entitiesConfigurations.keySet()) {
            this.entityNamesForVersionsEntityNames.put(this.entitiesConfigurations.get(entityName).getVersionsEntityName(), entityName);
        }
    }

    private void generateBidirectionRelationInfo() {
        for (String entityName : this.entitiesConfigurations.keySet()) {
            EntityConfiguration entCfg = this.entitiesConfigurations.get(entityName);
            for (RelationDescription relDesc : entCfg.getRelationsIterator()) {
                if (relDesc.relationType != RelationDescription.RelationType.TO_ONE) continue;
                for (RelationDescription other : this.entitiesConfigurations.get(relDesc.toEntityName).getRelationsIterator()) {
                    if (!relDesc.fromPropertyName.equals(other.mappedByPropertyName) || !entityName.equals(other.toEntityName)) continue;
                    relDesc.bidirectional = true;
                    other.bidirectional = true;
                }
            }
        }
    }

    public EntityConfiguration get(String entityName) {
        return this.entitiesConfigurations.get(entityName);
    }

    public String getEntityNameForVersionsEntityName(String versionsEntityName) {
        return this.entityNamesForVersionsEntityNames.get(versionsEntityName);
    }

    public RelationDescription getRelationDescription(String entityName, String propertyName) {
        EntityConfiguration entCfg = this.entitiesConfigurations.get(entityName);
        RelationDescription relDesc = entCfg.getRelationDescription(propertyName);
        if (relDesc != null) {
            return relDesc;
        }
        if (entCfg.getParentEntityName() != null) {
            return this.getRelationDescription(entCfg.getParentEntityName(), propertyName);
        }
        return null;
    }
}

