/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.jboss.envers.RevisionEntity;
import org.jboss.envers.RevisionNumber;
import org.jboss.envers.RevisionTimestamp;
import org.jboss.envers.configuration.CustomRevisionInfoGenerator;
import org.jboss.envers.configuration.DefaultRevisionInfoGenerator;
import org.jboss.envers.configuration.RevisionInfoGenerator;
import org.jboss.envers.reflection.YClass;
import org.jboss.envers.reflection.YProperty;
import org.jboss.envers.reflection.YReflectionManager;
import org.jboss.envers.tools.MutableBoolean;

public class VersionsEntitiesConfiguration {
    private String versionsTablePrefix;
    private String versionsTableSuffix;
    private String originalIdPropName;
    private String revisionPropName;
    private String revisionPropType;
    private String revisionPropPath;
    private String revisionTypePropName;
    private String revisionTypePropType;
    private String revisionsInfoEntityName;
    private String revisionsInfoIdName;
    private String revisionsInfoTimestampName;
    private String revisionsInfoTimestampType;
    private boolean customRevisionsInfoEntity;
    private RevisionInfoGenerator revisionInfoGenerator;
    private Map<String, String> customVersionsTablesNames;

    public static VersionsEntitiesConfiguration get(Configuration cfg, YReflectionManager reflectionManager) {
        Properties properties = cfg.getProperties();
        VersionsEntitiesConfiguration verEntCfg = new VersionsEntitiesConfiguration();
        verEntCfg.versionsTablePrefix = properties.getProperty("org.jboss.envers.versionsTablePrefix", "");
        verEntCfg.versionsTableSuffix = properties.getProperty("org.jboss.envers.versionsTableSuffix", "_versions");
        verEntCfg.originalIdPropName = "originalId";
        verEntCfg.revisionPropName = properties.getProperty("org.jboss.envers.revisionFieldName", "_revision");
        verEntCfg.revisionPropType = "integer";
        verEntCfg.revisionTypePropName = properties.getProperty("org.jboss.envers.revisionTypeFieldName", "_revision_type");
        verEntCfg.revisionTypePropType = "byte";
        verEntCfg.revisionsInfoEntityName = "_revisions_info";
        verEntCfg.revisionsInfoIdName = "revision_id";
        verEntCfg.revisionsInfoTimestampName = "revision_timestamp";
        verEntCfg.revisionsInfoTimestampType = "long";
        verEntCfg.customVersionsTablesNames = new HashMap<String, String>();
        verEntCfg.revisionPropPath = verEntCfg.originalIdPropName + "." + verEntCfg.revisionPropName;
        verEntCfg.customRevisionsInfoEntity = verEntCfg.configureRevisionsEntity(cfg, reflectionManager);
        return verEntCfg;
    }

    public String getVersionsTablePrefix() {
        return this.versionsTablePrefix;
    }

    public String getVersionsTableSuffix() {
        return this.versionsTableSuffix;
    }

    public String getOriginalIdPropName() {
        return this.originalIdPropName;
    }

    public String getRevisionPropName() {
        return this.revisionPropName;
    }

    public String getRevisionPropPath() {
        return this.revisionPropPath;
    }

    public String getRevisionPropType() {
        return this.revisionPropType;
    }

    public String getRevisionTypePropName() {
        return this.revisionTypePropName;
    }

    public String getRevisionTypePropType() {
        return this.revisionTypePropType;
    }

    public String getRevisionsInfoEntityName() {
        return this.revisionsInfoEntityName;
    }

    public String getRevisionsInfoIdName() {
        return this.revisionsInfoIdName;
    }

    public String getRevisionsInfoTimestampName() {
        return this.revisionsInfoTimestampName;
    }

    public String getRevisionsInfoTimestampType() {
        return this.revisionsInfoTimestampType;
    }

    public RevisionInfoGenerator getRevisionInfoGenerator() {
        return this.revisionInfoGenerator;
    }

    public void addCustomVersionsTableName(String entityName, String tableName) {
        this.customVersionsTablesNames.put(entityName, tableName);
    }

    public String getVersionsEntityName(String entityName) {
        return this.getVersionsTablePrefix() + entityName + this.getVersionsTableSuffix();
    }

    public boolean isVersionsEntityName(String entityName) {
        if (entityName == null) {
            return false;
        }
        return entityName.endsWith(this.getVersionsTableSuffix()) && entityName.startsWith(this.getVersionsTablePrefix());
    }

    public String getVersionsTableName(String entityName, String tableName) {
        String customHistoryTableName = this.customVersionsTablesNames.get(entityName);
        if (customHistoryTableName == null) {
            return this.getVersionsTablePrefix() + tableName + this.getVersionsTableSuffix();
        }
        return customHistoryTableName;
    }

    public boolean isRevisionInfoEntityName(String entityName) {
        return this.revisionsInfoEntityName.equals(entityName);
    }

    public boolean hasCustomRevisionInfoEntity() {
        return this.customRevisionsInfoEntity;
    }

    private void searchForRevisionInfoCfg(YClass clazz, YReflectionManager reflectionManager, MutableBoolean revisionNumberFound, MutableBoolean revisionTimestampFound) {
        YClass superclazz = clazz.getSuperclass();
        if (!"java.lang.Object".equals(superclazz.getName())) {
            this.searchForRevisionInfoCfg(superclazz, reflectionManager, revisionNumberFound, revisionTimestampFound);
        }
        for (YProperty property : clazz.getDeclaredProperties("field")) {
            RevisionNumber revisionNumber = property.getAnnotation(RevisionNumber.class);
            RevisionTimestamp revisionTimestamp = property.getAnnotation(RevisionTimestamp.class);
            if (revisionNumber != null) {
                if (revisionNumberFound.isSet()) {
                    throw new MappingException("Only one property may be annotated with @RevisionNumber!");
                }
                YClass revisionNumberClass = property.getType();
                if (reflectionManager.equals(revisionNumberClass, Integer.class) || reflectionManager.equals(revisionNumberClass, Integer.TYPE)) {
                    this.revisionsInfoIdName = property.getName();
                    revisionNumberFound.set();
                } else if (reflectionManager.equals(revisionNumberClass, Long.class) || reflectionManager.equals(revisionNumberClass, Long.TYPE)) {
                    this.revisionsInfoIdName = property.getName();
                    revisionNumberFound.set();
                    this.revisionPropType = "long";
                } else {
                    throw new MappingException("The field annotated with @RevisionNumber must be of type int, Integer, long or Long");
                }
            }
            if (revisionTimestamp == null) continue;
            if (revisionTimestampFound.isSet()) {
                throw new MappingException("Only one property may be annotated with @RevisionTimestamp!");
            }
            YClass revisionTimestampClass = property.getType();
            if (reflectionManager.equals(revisionTimestampClass, Long.class) || reflectionManager.equals(revisionTimestampClass, Long.TYPE)) {
                this.revisionsInfoTimestampName = property.getName();
                revisionTimestampFound.set();
                continue;
            }
            throw new MappingException("The field annotated with @RevisionTimestamp must be of type long or Long");
        }
    }

    private boolean configureRevisionsEntity(Configuration cfg, YReflectionManager reflectionManager) {
        Iterator classes = cfg.getClassMappings();
        boolean revisionEntityFound = false;
        while (classes.hasNext()) {
            YClass clazz;
            PersistentClass pc = (PersistentClass)classes.next();
            try {
                clazz = reflectionManager.classForName(pc.getClassName(), this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException((Throwable)e);
            }
            RevisionEntity revisionEntity = clazz.getAnnotation(RevisionEntity.class);
            if (revisionEntity == null) continue;
            if (revisionEntityFound) {
                throw new MappingException("Only one entity may be annotated with @RevisionEntity!");
            }
            revisionEntityFound = true;
            MutableBoolean revisionNumberFound = new MutableBoolean();
            MutableBoolean revisionTimestampFound = new MutableBoolean();
            this.searchForRevisionInfoCfg(clazz, reflectionManager, revisionNumberFound, revisionTimestampFound);
            if (!revisionNumberFound.isSet()) {
                throw new MappingException("An entity annotated with @RevisionEntity must have a field annotated with @RevisionNumber!");
            }
            if (!revisionTimestampFound.isSet()) {
                throw new MappingException("An entity annotated with @RevisionEntity must have a field annotated with @RevisionTimestamp!");
            }
            this.revisionsInfoEntityName = pc.getEntityName();
            this.revisionInfoGenerator = new CustomRevisionInfoGenerator(this, pc.getMappedClass(), revisionEntity.value());
        }
        if (this.revisionInfoGenerator == null) {
            this.revisionInfoGenerator = new DefaultRevisionInfoGenerator(this);
        }
        return revisionEntityFound;
    }
}

