/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.event;

import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.envers.configuration.RelationDescription;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.mapper.id.IdMapper;
import org.jboss.envers.synchronization.VersionsSync;
import org.jboss.envers.synchronization.work.AddWorkUnit;
import org.jboss.envers.synchronization.work.CollectionChangeWorkUnit;
import org.jboss.envers.synchronization.work.DelWorkUnit;
import org.jboss.envers.synchronization.work.ModWorkUnit;
import org.jboss.envers.tools.Tools;

public class VersionsEventListener
implements PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
Initializable {
    private VersionsConfiguration verCfg;

    private void generateCollectionChangeWorkUnits(VersionsSync verSync, EntityPersister entityPersister, String entityName, Object[] newState, Object[] oldState) {
        if (!this.verCfg.isGenerateRevisionsForCollections()) {
            return;
        }
        String[] propertyNames = entityPersister.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            Serializable id;
            Object newValue;
            String propertyName = propertyNames[i];
            RelationDescription relDesc = this.verCfg.getRelationDescription(entityName, propertyName);
            if (relDesc == null || !relDesc.bidirectional || relDesc.relationType != RelationDescription.RelationType.TO_ONE) continue;
            Object oldValue = oldState == null ? null : oldState[i];
            Object object = newValue = newState == null ? null : newState[i];
            if (Tools.objectsEqual(oldValue, newValue)) continue;
            IdMapper idMapper = this.verCfg.getIdMapper(relDesc.toEntityName);
            if (newValue != null) {
                id = (Serializable)idMapper.mapToIdFromEntity(newValue);
                verSync.addWorkUnit(new CollectionChangeWorkUnit(relDesc.toEntityName, this.verCfg, id, newValue));
            }
            if (oldValue == null) continue;
            id = (Serializable)idMapper.mapToIdFromEntity(oldValue);
            verSync.addWorkUnit(new CollectionChangeWorkUnit(relDesc.toEntityName, this.verCfg, id, oldValue));
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.verCfg.isVersioned(entityName)) {
            VersionsSync verSync = this.verCfg.getSyncManager().get((Session)event.getSession());
            verSync.addWorkUnit(new AddWorkUnit(event.getPersister().getEntityName(), this.verCfg, event.getId(), event.getPersister(), event.getState()));
            this.generateCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, event.getState(), null);
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.verCfg.isVersioned(entityName)) {
            VersionsSync verSync = this.verCfg.getSyncManager().get((Session)event.getSession());
            verSync.addWorkUnit(new ModWorkUnit(event.getPersister().getEntityName(), this.verCfg, event.getId(), event.getPersister(), event.getState(), event.getOldState()));
            this.generateCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, event.getState(), event.getOldState());
        }
    }

    public void onPostDelete(PostDeleteEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.verCfg.isVersioned(entityName)) {
            VersionsSync verSync = this.verCfg.getSyncManager().get((Session)event.getSession());
            verSync.addWorkUnit(new DelWorkUnit(event.getPersister().getEntityName(), this.verCfg, event.getId()));
            this.generateCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, null, event.getDeletedState());
        }
    }

    public void initialize(Configuration cfg) {
        this.verCfg = VersionsConfiguration.getFor(cfg);
    }

    public VersionsConfiguration getVerCfg() {
        return this.verCfg;
    }
}

