/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.mapper;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.util.ReflectHelper;
import org.jboss.envers.ModificationStore;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.mapper.CompositeMapperBuilder;
import org.jboss.envers.mapper.CompositePropertyMapperBuilder;
import org.jboss.envers.mapper.ExtendedPropertyMapper;
import org.jboss.envers.mapper.MultiPropertyMapper;
import org.jboss.envers.mapper.PropertyMapper;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPropertyMapper
implements CompositePropertyMapperBuilder {
    private String propertyName;
    private ExtendedPropertyMapper delegate;

    public MapPropertyMapper(String propertyName) {
        this.propertyName = propertyName;
        this.delegate = new MultiPropertyMapper();
    }

    @Override
    public void add(String propertyName, ModificationStore modStore) {
        this.delegate.add(propertyName, modStore);
    }

    @Override
    public CompositeMapperBuilder addComposite(String propertyName) {
        return this.delegate.addComposite(propertyName);
    }

    @Override
    public void addComposite(String propertyName, PropertyMapper propertyMapper) {
        this.delegate.addComposite(propertyName, propertyMapper);
    }

    @Override
    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        HashMap<String, Object> newData = new HashMap<String, Object>();
        data.put(this.propertyName, newData);
        return this.delegate.mapToMapFromEntity(newData, newObj, oldObj);
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        if (data == null || obj == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.propertyName);
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyName);
        try {
            Object subObj = ReflectHelper.getDefaultConstructor((Class)getter.getReturnType()).newInstance(new Object[0]);
            setter.set(obj, subObj, null);
            this.delegate.mapToEntityFromMap(subObj, (Map)data.get(this.propertyName), primaryKey, versionsReader, revision);
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
    }
}

