/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.mapper.id;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.util.ReflectHelper;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.mapper.id.AbstractCompositeIdMapper;
import org.jboss.envers.mapper.id.IdMapper;
import org.jboss.envers.mapper.id.QueryParameterData;
import org.jboss.envers.mapper.id.SimpleIdMapperBuilder;
import org.jboss.envers.mapper.id.SingleIdMapper;
import org.jboss.envers.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedIdMapper
extends AbstractCompositeIdMapper
implements SimpleIdMapperBuilder {
    private String idPropertyName;

    public EmbeddedIdMapper(String idPropertyName, String compositeIdClass) {
        super(compositeIdClass);
        this.idPropertyName = idPropertyName;
    }

    @Override
    public void mapToMapFromId(Map<String, Object> data, Object obj) {
        for (SingleIdMapper idMapper : this.ids.values()) {
            idMapper.mapToMapFromEntity(data, obj);
        }
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        if (obj == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.idPropertyName);
        this.mapToMapFromId(data, getter.get(obj));
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data) {
        if (data == null || obj == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.idPropertyName);
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.idPropertyName);
        try {
            Object subObj = ReflectHelper.getDefaultConstructor((Class)getter.getReturnType()).newInstance(new Object[0]);
            setter.set(obj, subObj, null);
            for (SingleIdMapper idMapper : this.ids.values()) {
                idMapper.mapToEntityFromMap(subObj, data);
            }
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
    }

    @Override
    public IdMapper prefixMappedProperties(String prefix) {
        EmbeddedIdMapper ret = new EmbeddedIdMapper(this.idPropertyName, this.compositeIdClass);
        for (String propertyName : this.ids.keySet()) {
            ret.ids.put(propertyName, new SingleIdMapper(propertyName, prefix + propertyName));
        }
        return ret;
    }

    @Override
    public Object mapToIdFromEntity(Object data) {
        if (data == null) {
            return null;
        }
        Getter getter = ReflectionTools.getGetter(data.getClass(), this.idPropertyName);
        return getter.get(data);
    }

    @Override
    public Set<QueryParameterData> mapToQueryParametersFromId(Object obj) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.mapToMapFromId(data, obj);
        HashSet<QueryParameterData> ret = new HashSet<QueryParameterData>();
        for (String propertyName : data.keySet()) {
            ret.add(new QueryParameterData(propertyName, data.get(propertyName)));
        }
        return ret;
    }
}

