/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.mapper.id;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.mapper.id.AbstractCompositeIdMapper;
import org.jboss.envers.mapper.id.IdMapper;
import org.jboss.envers.mapper.id.QueryParameterData;
import org.jboss.envers.mapper.id.SimpleIdMapperBuilder;
import org.jboss.envers.mapper.id.SingleIdMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleIdMapper
extends AbstractCompositeIdMapper
implements SimpleIdMapperBuilder {
    public MultipleIdMapper(String compositeIdClass) {
        super(compositeIdClass);
    }

    @Override
    public void mapToMapFromId(Map<String, Object> data, Object obj) {
        for (SingleIdMapper idMapper : this.ids.values()) {
            idMapper.mapToMapFromEntity(data, obj);
        }
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        this.mapToMapFromId(data, obj);
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data) {
        for (SingleIdMapper idMapper : this.ids.values()) {
            idMapper.mapToEntityFromMap(obj, data);
        }
    }

    @Override
    public IdMapper prefixMappedProperties(String prefix) {
        MultipleIdMapper ret = new MultipleIdMapper(this.compositeIdClass);
        for (String propertyName : this.ids.keySet()) {
            ret.ids.put(propertyName, new SingleIdMapper(propertyName, prefix + propertyName));
        }
        return ret;
    }

    @Override
    public Object mapToIdFromEntity(Object data) {
        Object ret;
        if (data == null) {
            return null;
        }
        try {
            ret = Thread.currentThread().getContextClassLoader().loadClass(this.compositeIdClass).newInstance();
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
        for (SingleIdMapper mapper : this.ids.values()) {
            mapper.mapToEntityFromEntity(ret, data);
        }
        return ret;
    }

    @Override
    public Set<QueryParameterData> mapToQueryParametersFromId(Object obj) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.mapToMapFromId(data, obj);
        HashSet<QueryParameterData> ret = new HashSet<QueryParameterData>();
        for (String propertyName : data.keySet()) {
            ret.add(new QueryParameterData(propertyName, data.get(propertyName)));
        }
        return ret;
    }
}

