/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.metadata;

import org.hibernate.MappingException;
import org.hibernate.mapping.PersistentClass;
import org.jboss.envers.SecondaryVersionsTable;
import org.jboss.envers.SecondaryVersionsTables;
import org.jboss.envers.Versioned;
import org.jboss.envers.VersionsTable;
import org.jboss.envers.metadata.data.PersistentClassVersioningData;
import org.jboss.envers.reflection.YClass;
import org.jboss.envers.reflection.YProperty;
import org.jboss.envers.reflection.YReflectionManager;

public class AnnotationsMetadataReader {
    private void addPropertiesFromClass(YClass clazz, PersistentClassVersioningData versioningData) {
        Versioned ver;
        YClass superclazz = clazz.getSuperclass();
        if (!"java.lang.Object".equals(superclazz.getName())) {
            this.addPropertiesFromClass(superclazz, versioningData);
        }
        for (YProperty property : clazz.getDeclaredProperties("field")) {
            ver = property.getAnnotation(Versioned.class);
            if (ver == null) continue;
            versioningData.propertyStoreInfo.propertyStores.put(property.getName(), ver.modStore());
        }
        for (YProperty property : clazz.getDeclaredProperties("property")) {
            ver = property.getAnnotation(Versioned.class);
            if (ver == null) continue;
            versioningData.propertyStoreInfo.propertyStores.put(property.getName(), ver.modStore());
        }
    }

    public PersistentClassVersioningData getVersioningData(PersistentClass pc, YReflectionManager reflectionManager) {
        if (pc.getClassName() == null) {
            return null;
        }
        PersistentClassVersioningData versioningData = new PersistentClassVersioningData();
        try {
            SecondaryVersionsTables secondaryVersionsTables;
            SecondaryVersionsTable secondaryVersionsTable1;
            YClass clazz = reflectionManager.classForName(pc.getClassName(), this.getClass());
            Versioned defaultVersioned = clazz.getAnnotation(Versioned.class);
            if (defaultVersioned != null) {
                versioningData.propertyStoreInfo.defaultStore = defaultVersioned.modStore();
            }
            this.addPropertiesFromClass(clazz, versioningData);
            VersionsTable versionsTable = clazz.getAnnotation(VersionsTable.class);
            if (versionsTable != null) {
                versioningData.versionsTableName = versionsTable.value();
                versioningData.schema = versionsTable.schema();
                versioningData.catalog = versionsTable.catalog();
            }
            if ((secondaryVersionsTable1 = clazz.getAnnotation(SecondaryVersionsTable.class)) != null) {
                versioningData.secondaryTableDictionary.put(secondaryVersionsTable1.secondaryTableName(), secondaryVersionsTable1.secondaryVersionsTableName());
            }
            if ((secondaryVersionsTables = clazz.getAnnotation(SecondaryVersionsTables.class)) != null) {
                for (SecondaryVersionsTable secondaryVersionsTable2 : secondaryVersionsTables.value()) {
                    versioningData.secondaryTableDictionary.put(secondaryVersionsTable2.secondaryTableName(), secondaryVersionsTable2.secondaryVersionsTableName());
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException((Throwable)e);
        }
        return versioningData;
    }
}

