/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.criteria;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.query.criteria.CriteriaTools;
import org.jboss.envers.query.criteria.ExtendableCriterion;
import org.jboss.envers.query.criteria.VersionsCriterion;
import org.jboss.envers.reader.VersionsReaderImplementor;

public class AggregatedFieldVersionsExpression
implements VersionsCriterion,
ExtendableCriterion {
    private String propertyName;
    private AggregatedMode mode;
    private List<VersionsCriterion> criterions;

    public AggregatedFieldVersionsExpression(String propertyName, AggregatedMode mode) {
        this.propertyName = propertyName;
        this.mode = mode;
        this.criterions = new ArrayList<VersionsCriterion>();
    }

    public AggregatedFieldVersionsExpression add(VersionsCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    public Criterion toVersionsCriterion(String entityName, VersionsReaderImplementor versionsReader) throws VersionsException {
        CriteriaTools.checkPropertyNotARelation(versionsReader, entityName, this.propertyName);
        String versionsEntityName = versionsReader.getEntitiesCfg().getVersionsEntityName(entityName);
        DetachedCriteria aggregatedCriteria = DetachedCriteria.forEntityName((String)versionsEntityName);
        Conjunction conjunction = Restrictions.conjunction();
        for (VersionsCriterion versionsCriteria : this.criterions) {
            Criterion transformedCriterion = versionsCriteria.toVersionsCriterion(entityName, versionsReader);
            conjunction.add(transformedCriterion);
            aggregatedCriteria.add(transformedCriterion);
        }
        switch (this.mode) {
            case MIN: {
                aggregatedCriteria.setProjection((Projection)Property.forName((String)this.propertyName).min());
                break;
            }
            case MAX: {
                aggregatedCriteria.setProjection((Projection)Property.forName((String)this.propertyName).max());
            }
        }
        conjunction.add(Property.forName((String)this.propertyName).eq(aggregatedCriteria));
        return conjunction;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AggregatedMode {
        MAX,
        MIN;

    }
}

