/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.criteria;

import org.jboss.envers.configuration.RelationDescription;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reader.VersionsReaderImplementor;

public class CriteriaTools {
    private CriteriaTools() {
    }

    public static void checkPropertyNotARelation(VersionsReaderImplementor versionsReader, String entityName, String propertyName) throws VersionsException {
        if (versionsReader.getVerCfg().getEntityConfiguration(entityName).isRelation(propertyName)) {
            throw new VersionsException("This criterion cannot be used on a property that is a relation to another property.");
        }
    }

    public static RelationDescription getRelatedEntity(VersionsReaderImplementor versionsReader, String entityName, String propertyName) throws VersionsException {
        RelationDescription relationDesc = versionsReader.getVerCfg().getEntityConfiguration(entityName).getRelationDescription(propertyName);
        if (relationDesc == null) {
            return null;
        }
        if (relationDesc.relationType == RelationDescription.RelationType.TO_ONE) {
            return relationDesc;
        }
        throw new VersionsException("This type of relation (" + entityName + "." + propertyName + ") isn't supported and can't be used in queries.");
    }
}

