/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Order;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.query.criteria.VersionsCriterion;
import org.jboss.envers.query.impl.AbstractVersionsQuery;
import org.jboss.envers.reader.VersionsReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionsOfEntityQuery
extends AbstractVersionsQuery {
    private boolean selectEntitiesOnly;

    public RevisionsOfEntityQuery(VersionsReaderImplementor versionsReader, Class<?> cls, boolean selectEntitiesOnly) {
        super(versionsReader, cls);
        this.selectEntitiesOnly = selectEntitiesOnly;
    }

    @Override
    public List list() throws VersionsException {
        String revisionPropertyPath = this.versionsReader.getEntitiesCfg().getRevisionPropPath();
        for (VersionsCriterion criterion : this.criterions) {
            this.versionsCriteria.add(criterion.toVersionsCriterion(this.entityName, this.versionsReader));
        }
        if (!this.hasProjection && !this.hasOrder) {
            this.versionsCriteria.addOrder(Order.asc((String)revisionPropertyPath));
        }
        List queryResult = this.versionsCriteria.list();
        if (this.hasProjection) {
            return queryResult;
        }
        ArrayList<Object> entities = new ArrayList<Object>();
        String originalId = this.versionsReader.getEntitiesCfg().getOriginalIdPropName();
        String revisionPropertyName = this.versionsReader.getEntitiesCfg().getRevisionPropName();
        for (Map versionsEntity : queryResult) {
            Number revision = (Number)((Map)versionsEntity.get(originalId)).get(revisionPropertyName);
            Object entity = this.entityInstantiator.createInstanceFromVersionsEntity(this.entityName, versionsEntity, revision);
            if (!this.selectEntitiesOnly) {
                entities.add(new Object[]{entity, revision});
                continue;
            }
            entities.add(entity);
        }
        return entities;
    }
}

