/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.reader;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.exception.NotVersionedException;
import org.jboss.envers.exception.RevisionDoesNotExistException;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.query.RevisionProperty;
import org.jboss.envers.query.VersionsQueryCreator;
import org.jboss.envers.query.VersionsRestrictions;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.tools.ArgumentsTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionsReaderImpl
implements VersionsReaderImplementor {
    private VersionsConfiguration verCfg;
    private VersionsEntitiesConfiguration entitiesCfg;
    private SessionImplementor sessionImplementor;
    private Session session;

    public VersionsReaderImpl(VersionsConfiguration verCfg, Session session, SessionImplementor sessionImplementor) {
        this.verCfg = verCfg;
        this.sessionImplementor = sessionImplementor;
        this.session = session;
        this.entitiesCfg = verCfg.getEntitiesCfg();
    }

    private void checkSession() {
        if (!this.session.isOpen()) {
            throw new IllegalStateException("The associated entity manager is closed!");
        }
    }

    @Override
    public SessionImplementor getSessionImplementor() {
        return this.sessionImplementor;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public VersionsConfiguration getVerCfg() {
        return this.verCfg;
    }

    @Override
    public VersionsEntitiesConfiguration getEntitiesCfg() {
        return this.entitiesCfg;
    }

    @Override
    public <T> T find(Class<T> cls, Object primaryKey, Number revision) throws IllegalArgumentException, NotVersionedException, IllegalStateException {
        ArgumentsTools.checkNotNull(cls, "Entity class");
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        String entityName = cls.getName();
        if (!this.verCfg.isVersioned(entityName)) {
            throw new NotVersionedException(entityName + " is not versioned!");
        }
        try {
            return (T)this.createQuery().forEntitiesAtRevision(cls, revision).add(VersionsRestrictions.idEq(primaryKey)).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            throw new VersionsException(e);
        }
    }

    @Override
    public Object findOneReferencing(Class<?> cls, String owningEntityName, String owningReferencePropertyName, Object ownedEntityId, Number revision) {
        try {
            return this.createQuery().forEntitiesAtRevision(cls, revision).add(VersionsRestrictions.relatedIdEq(owningReferencePropertyName, ownedEntityId)).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            throw new VersionsException("Many versions results for one-to-one relationship: (" + owningEntityName + ", " + owningReferencePropertyName + ")");
        }
    }

    @Override
    public Object findManyReferencing(Class<?> cls, String owningReferencePropertyName, Object ownedEntityId, Number revision, Class<? extends Collection> collectionClass) {
        Collection result;
        List queryResult = this.createQuery().forEntitiesAtRevision(cls, revision).add(VersionsRestrictions.relatedIdEq(owningReferencePropertyName, ownedEntityId)).getResultList();
        if (collectionClass.isAssignableFrom(queryResult.getClass())) {
            return queryResult;
        }
        try {
            result = collectionClass.newInstance();
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
        result.addAll(queryResult);
        return result;
    }

    @Override
    public List<Number> getRevisions(Class<?> cls, Object primaryKey) throws IllegalArgumentException, NotVersionedException, IllegalStateException {
        ArgumentsTools.checkNotNull(cls, "Entity class");
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        this.checkSession();
        String entityName = cls.getName();
        if (!this.verCfg.isVersioned(entityName)) {
            throw new NotVersionedException(entityName + " is not versioned!");
        }
        return this.createQuery().forRevisionsOfEntity(cls, false).setProjection(RevisionProperty.revisionNumber()).add(VersionsRestrictions.idEq(primaryKey)).getResultList();
    }

    @Override
    public Date getRevisionDate(Number revision) throws IllegalArgumentException, RevisionDoesNotExistException, IllegalStateException {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select rev.").append(this.entitiesCfg.getRevisionsInfoTimestampName()).append(" from ").append(this.entitiesCfg.getRevisionsInfoEntityName()).append(" rev where ").append(this.entitiesCfg.getRevisionsInfoIdName()).append(" = :_revision_number");
        Query query = this.session.createQuery(queryStr.toString()).setParameter("_revision_number", (Object)revision);
        try {
            Long timestamp = (Long)query.uniqueResult();
            if (timestamp == null) {
                throw new RevisionDoesNotExistException(revision);
            }
            return new Date(timestamp);
        }
        catch (NonUniqueResultException e) {
            throw new VersionsException(e);
        }
    }

    @Override
    public Number getRevisionNumberForDate(Date date) {
        ArgumentsTools.checkNotNull(date, "Date of revision");
        this.checkSession();
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select max(rev.").append(this.entitiesCfg.getRevisionsInfoIdName()).append(") from ").append(this.entitiesCfg.getRevisionsInfoEntityName()).append(" rev where ").append(this.entitiesCfg.getRevisionsInfoTimestampName()).append(" <= :_revision_date");
        Query query = this.session.createQuery(queryStr.toString()).setParameter("_revision_date", (Object)date.getTime());
        try {
            Number res = (Number)query.uniqueResult();
            if (res == null) {
                throw new RevisionDoesNotExistException(date);
            }
            return res;
        }
        catch (NonUniqueResultException e) {
            throw new VersionsException(e);
        }
    }

    @Override
    public <T> T findRevision(Class<T> revisionEntityClass, Number revision) throws IllegalArgumentException, RevisionDoesNotExistException, IllegalStateException {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select rev from ").append(this.entitiesCfg.getRevisionsInfoEntityName()).append(" rev where ").append(this.entitiesCfg.getRevisionsInfoIdName()).append(" = :_revision_number");
        Query query = this.session.createQuery(queryStr.toString()).setParameter("_revision_number", (Object)revision);
        try {
            Object revisionData = query.uniqueResult();
            if (revisionData == null) {
                throw new RevisionDoesNotExistException(revision);
            }
            return (T)revisionData;
        }
        catch (NonUniqueResultException e) {
            throw new VersionsException(e);
        }
    }

    @Override
    public VersionsQueryCreator createQuery() {
        return new VersionsQueryCreator(this);
    }
}

