/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reflection.YMethodsAndClasses;
import org.jboss.envers.reflection.YProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YClass {
    private YMethodsAndClasses ymc;
    private Object delegate;

    public YClass(YMethodsAndClasses ymc, Object delegate) {
        this.ymc = ymc;
        this.delegate = delegate;
    }

    Object getDelegate() {
        return this.delegate;
    }

    public String getName() {
        try {
            return (String)this.ymc.getXClass_getNameMethod().invoke(this.delegate, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new VersionsException(e);
        }
        catch (InvocationTargetException e) {
            throw new VersionsException(e);
        }
    }

    public YClass getSuperclass() {
        try {
            return new YClass(this.ymc, this.ymc.getXClass_getSuperclassMethod().invoke(this.delegate, new Object[0]));
        }
        catch (IllegalAccessException e) {
            throw new VersionsException(e);
        }
        catch (InvocationTargetException e) {
            throw new VersionsException(e);
        }
    }

    public List<YProperty> getDeclaredProperties(String accessMode) {
        List delegates;
        try {
            delegates = (List)this.ymc.getXClass_getDeclaredPropertiesMethod().invoke(this.delegate, accessMode);
        }
        catch (IllegalAccessException e) {
            throw new VersionsException(e);
        }
        catch (InvocationTargetException e) {
            throw new VersionsException(e);
        }
        ArrayList<YProperty> ret = new ArrayList<YProperty>();
        for (Object delegate : delegates) {
            ret.add(new YProperty(this.ymc, delegate));
        }
        return ret;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        try {
            return (T)((Annotation)this.ymc.getXClass_getAnnotationMethod().invoke(this.delegate, annotation));
        }
        catch (IllegalAccessException e) {
            throw new VersionsException(e);
        }
        catch (InvocationTargetException e) {
            throw new VersionsException(e);
        }
    }
}

