/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.synchronization;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.transaction.Synchronization;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jboss.envers.synchronization.VersionsSyncManager;
import org.jboss.envers.synchronization.work.VersionsWorkUnit;
import org.jboss.envers.tools.Pair;

public class VersionsSync
implements Synchronization {
    private VersionsSyncManager manager;
    private org.hibernate.Session session;
    private Number revision;
    private Transaction transaction;
    private LinkedList<VersionsWorkUnit> workUnits;
    private Queue<VersionsWorkUnit> undoQueue;
    private Map<Pair<String, Object>, VersionsWorkUnit> usedIds;

    public VersionsSync(VersionsSyncManager manager, org.hibernate.Session session) {
        this.manager = manager;
        this.session = session;
        this.transaction = session.getTransaction();
        this.workUnits = new LinkedList();
        this.undoQueue = new LinkedList<VersionsWorkUnit>();
        this.usedIds = new HashMap<Pair<String, Object>, VersionsWorkUnit>();
    }

    private void generateRevision(org.hibernate.Session session) {
        this.revision = (Number)session.save(this.manager.getEntitiesCfg().getRevisionsInfoEntityName(), this.manager.getEntitiesCfg().getRevisionInfoGenerator().newRevision());
    }

    private void removeWorkUnit(VersionsWorkUnit vwu) {
        this.workUnits.remove(vwu);
        if (vwu.isPerformed()) {
            this.undoQueue.offer(vwu);
        }
    }

    public void addWorkUnit(VersionsWorkUnit vwu) {
        if (vwu.containsWork()) {
            Object entityId = vwu.getEntityId();
            String entityName = vwu.getEntityName();
            Pair<String, Object> usedIdsKey = Pair.make(entityName, entityId);
            if (this.usedIds.containsKey(usedIdsKey)) {
                VersionsWorkUnit other = this.usedIds.get(usedIdsKey);
                switch (vwu.dispatch(other)) {
                    case FIRST: {
                        break;
                    }
                    case SECOND: {
                        this.removeWorkUnit(other);
                        this.usedIds.put(usedIdsKey, vwu);
                        this.workUnits.offer(vwu);
                        break;
                    }
                    case NONE: {
                        this.removeWorkUnit(other);
                    }
                }
            } else {
                this.usedIds.put(usedIdsKey, vwu);
                this.workUnits.offer(vwu);
            }
        }
    }

    private void executeInSession(org.hibernate.Session session) {
        VersionsWorkUnit vwu;
        if (this.revision == null) {
            this.generateRevision(session);
        }
        while ((vwu = this.undoQueue.poll()) != null) {
            vwu.undo(session);
        }
        while ((vwu = this.workUnits.poll()) != null) {
            vwu.perform(session, this.revision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        if (this.workUnits.size() == 0 && this.undoQueue.size() == 0) {
            return;
        }
        if (FlushMode.isManualFlushMode((FlushMode)this.session.getFlushMode())) {
            Session temporarySession = null;
            try {
                temporarySession = this.session.getSessionFactory().openSession(this.session.connection());
                this.executeInSession((org.hibernate.Session)temporarySession);
                temporarySession.flush();
            }
            finally {
                if (temporarySession != null) {
                    temporarySession.close();
                }
            }
        } else {
            this.executeInSession(this.session);
            this.session.flush();
        }
    }

    public void afterCompletion(int i) {
        this.manager.remove(this.transaction);
    }
}

