/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.synchronization;

import java.util.Map;
import javax.transaction.Synchronization;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.synchronization.VersionsSync;
import org.jboss.envers.tools.ConcurrentReferenceHashMap;

public class VersionsSyncManager {
    private VersionsEntitiesConfiguration verEntCfg;
    private Map<Transaction, VersionsSync> versionsSyncs;

    public VersionsSyncManager(VersionsEntitiesConfiguration verEntCfg) {
        this.verEntCfg = verEntCfg;
        this.versionsSyncs = new ConcurrentReferenceHashMap<Transaction, VersionsSync>(10, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG);
    }

    public VersionsEntitiesConfiguration getEntitiesCfg() {
        return this.verEntCfg;
    }

    public VersionsSync get(Session session) {
        Transaction transaction = session.getTransaction();
        VersionsSync verSync = this.versionsSyncs.get(transaction);
        if (verSync == null) {
            verSync = new VersionsSync(this, session);
            this.versionsSyncs.put(transaction, verSync);
            transaction.registerSynchronization((Synchronization)verSync);
        }
        return verSync;
    }

    public void remove(Transaction transaction) {
        this.versionsSyncs.remove(transaction);
    }
}

