/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.synchronization.work.VersionsWorkUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVersionsWorkUnit
implements VersionsWorkUnit {
    protected VersionsConfiguration verCfg;
    protected Serializable id;
    private Object performedData;
    private String entityName;

    protected AbstractVersionsWorkUnit(String entityName, VersionsConfiguration verCfg, Serializable id) {
        this.verCfg = verCfg;
        this.id = id;
        this.entityName = entityName;
    }

    protected void fillDataWithId(Map<String, Object> data, Number revision, Byte revisionType) {
        VersionsEntitiesConfiguration entitiesCfg = this.verCfg.getEntitiesCfg();
        HashMap<String, Object> originalId = new HashMap<String, Object>();
        originalId.put(entitiesCfg.getRevisionPropName(), revision);
        this.verCfg.getIdMapper(this.getEntityName()).mapToMapFromId(originalId, this.id);
        data.put(entitiesCfg.getRevisionTypePropName(), revisionType);
        data.put(entitiesCfg.getOriginalIdPropName(), originalId);
    }

    @Override
    public Object getEntityId() {
        return this.id;
    }

    @Override
    public boolean isPerformed() {
        return this.performedData != null;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    protected void setPerformed(Object performedData) {
        this.performedData = performedData;
    }

    @Override
    public void undo(Session session) {
        if (this.isPerformed()) {
            session.delete(this.verCfg.getEntitiesCfg().getVersionsEntityName(this.getEntityName()), this.performedData);
            session.flush();
        }
    }
}

