/*
 * Copyright (C) 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.websockets.oio;

import java.io.IOException;
import java.io.OutputStream;

/**
 * This is an abstraction of an http response so that this code can be re-used in different HTTP Engines (i.e. servlet).
 * Instances of this class usually delegate to the underyling container's implementation of an http response.
 *
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Revision: 1 $
 */
public interface HttpResponseBridge {
  String getHeader(String name);

  void setHeader(String name, String val);

  OutputStream getOutputStream();

  /**
   * Start the connection upgrade process. After calling this method,
   * data will be available raw from the connection. Calling this method
   * is optional if no read/write are needed during the upgrade process.
   */
  public void startUpgrade();

  /**
   * Send the switching protocol HTTP status and commit the response by
   * flushing the buffer.
   */
  public void sendUpgrade()
          throws IOException;
}
