/*
 * Copyright (C) 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.websockets.oio;

import org.jboss.as.websockets.Frame;

import java.io.IOException;

/**
 * A WebSocket that blocks when you readFrame or writeFrame.  Underneath, based on java.io.* a.k.a. Old IO (Oio).
 *
 * @author Mike Brock
 * @version $Revision: 1 $
 */
public interface OioWebSocket {
  /**
   * A unique ID associated with the socket, which can be used for session association. This ID is generated by the
   * WebSockets framework as a random hash when the socket is open and has no association with any external API or
   * the websocket handshake process.
   *
   * @return A hex string representing the unique ID of the socket.
   */
  String getSocketID();

  /**
   * Read a single frame from the socket.
   *
   * @return an instance of the received {@link Frame}
   * @throws java.io.IOException
   */
  Frame readFrame() throws IOException;

  /**
   * Write a frame to the socket.
   *
   * @param frame the @{link Frame} instance to write to the socket.
   * @throws java.io.IOException
   */
  void writeFrame(Frame frame) throws IOException;

  /**
   * Terminates the connection with the client and closes the socket.
   */
  void closeSocket() throws IOException;
}
