/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.jboss.errai.codegen.InnerClass;
import org.jboss.errai.codegen.Modifier;
import org.jboss.errai.codegen.Parameter;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.Variable;
import org.jboss.errai.codegen.builder.ClassStructureBuilder;
import org.jboss.errai.codegen.builder.ClassStructureBuilderAbstractMethodOption;
import org.jboss.errai.codegen.builder.MethodBlockBuilder;
import org.jboss.errai.codegen.builder.impl.ClassBuilder;
import org.jboss.errai.codegen.exception.UndefinedMethodException;
import org.jboss.errai.codegen.meta.MetaClass;
import org.jboss.errai.codegen.meta.MetaClassFactory;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.test.model.Baz;
import org.jboss.errai.codegen.test.model.Integer;
import org.jboss.errai.codegen.test.model.tree.Parent;
import org.jboss.errai.codegen.util.Stmt;
import org.junit.Assert;
import org.junit.Test;

public class ClassBuilderTest
extends AbstractCodegenTest {
    @Test
    public void testDefineClassImplementingInterface() {
        String cls = ((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Bar").publicScope().implementsInterface(Serializable.class).body().privateField("name", String.class).finish()).toJavaString();
        System.out.println(cls);
        ClassBuilderTest.assertEquals("failed to generate class definition implementing an interface", "     package org.foo;\n import java.io.Serializable;\n\n public class Bar implements Serializable {\n   private String name;\n }", cls);
    }

    @Test
    public void testDefineClassImplementingMultipleInterfaces() {
        String cls = ((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Bar").publicScope().implementsInterface(Serializable.class).implementsInterface(Cloneable.class).body().privateField("name", String.class).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class definition implementing multiple interfaces", "     package org.foo;\n import java.io.Serializable;\n\n public class Bar implements Serializable, Cloneable {\n   private String name;\n }", cls);
    }

    @Test
    public void testDefineClassWithInnerClass() {
        ClassStructureBuilder innerClass = ClassBuilder.define((String)"Inner").publicScope().body();
        String cls = ClassBuilder.define((String)"foo.bar.Baz").publicScope().body().declaresInnerClass(new InnerClass(innerClass.getClassDefinition())).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with method using inner class", "     package foo.bar;\n public class Baz {\n    public class Inner {\n   } }", cls);
    }

    @Test
    public void testDefineInnerClassInMethod() {
        ClassStructureBuilder innerClass = (ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"Inner").packageScope().implementsInterface(Serializable.class).body().privateField("name", String.class).finish()).publicMethod(Void.TYPE, "setName", new Parameter[]{Parameter.of(String.class, (String)"name", (boolean)true)}).append((Statement)Stmt.loadClassMember((String)"name", (Object[])new Object[0]).assignValue((Object)Variable.get((String)"name"))).finish();
        String cls = ((ClassStructureBuilder)ClassBuilder.define((String)"foo.bar.Baz").publicScope().body().publicMethod(Void.TYPE, "someMethod").append(new InnerClass(innerClass.getClassDefinition())).append((Statement)Stmt.newObject((MetaClass)innerClass.getClassDefinition())).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with method using inner class", "     package foo.bar;\n import java.io.Serializable;\n\n public class Baz {\n   public void someMethod() {\n      class Inner implements Serializable {\n        private String name;        public void setName(final String name) {\n          this.name = name;\n        }\n      }      new Inner();   } }", cls);
    }

    @Test
    public void testDefineClassWithAccessorMethods() {
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().privateField("name", String.class).initializesWith((Statement)Stmt.load((Object)"default")).finish()).publicMethod(String.class, "getName").append(Stmt.loadVariable((String)"name", (Object[])new Object[0]).returnValue()).finish()).publicMethod(Void.TYPE, "setName", new Parameter[]{Parameter.of(String.class, (String)"name")}).append((Statement)Stmt.loadClassMember((String)"name", (Object[])new Object[0]).assignValue((Object)Variable.get((String)"name"))).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class definition with accessor methods", "     package org.foo;\n\n public class Foo {\n   private String name = \"default\";\n   public String getName() {\n     return name;\n   }\n   public void setName(String name) {\n     this.name = name;\n   }\n }", cls);
    }

    @Test
    public void testDefineClassWithAccessorMethodsUsingThisKeyword() {
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().privateField("name", String.class).initializesWith((Statement)Stmt.load((Object)"default")).finish()).publicMethod(String.class, "getName").append(Stmt.loadVariable((String)"name", (Object[])new Object[0]).returnValue()).finish()).publicMethod(Void.TYPE, "setName", new Parameter[]{Parameter.of(String.class, (String)"name")}).append((Statement)Stmt.loadVariable((String)"this.name", (Object[])new Object[0]).assignValue((Object)Variable.get((String)"name"))).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class definition with accessor methods", "     package org.foo;\n\n public class Foo {\n   private String name = \"default\";\n   public String getName() {\n     return name;\n   }\n   public void setName(String name) {\n     this.name = name;\n   }\n }", cls);
    }

    @Test
    public void testDefineClassWithParent() {
        String cls = ((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo", String.class).publicScope().body().publicConstructor(new Parameter[]{Parameter.of(java.lang.Integer.TYPE, (String)"i")}).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with parent", "     package org.foo;\n\n public class Foo extends String {\n   public Foo(int i) {   } }", cls);
    }

    @Test
    public void testDefineClassWithFieldInheritance() {
        String cls = ((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo", Parent.class).publicScope().body().publicConstructor().append((Statement)Stmt.loadVariable((String)"parentProtected", (Object[])new Object[0]).assignValue((Object)0)).append((Statement)Stmt.loadVariable((String)"parentPublic", (Object[])new Object[0]).assignValue((Object)0)).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with parent", "     package org.foo; import org.jboss.errai.codegen.test.model.tree.Parent; public class Foo extends Parent {   public Foo() {     parentProtected = 0;     parentPublic = 0;   } }", cls);
    }

    @Test
    public void testDefineAbstractClass() {
        String cls = ((ClassStructureBuilderAbstractMethodOption)ClassBuilder.define((String)"org.foo.Foo").publicScope().abstractClass().body().publicConstructor().finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate abstract class", "     package org.foo;\n\n public abstract class Foo {\n   public Foo() {   } }", cls);
    }

    @Test
    public void testDefineAbstractClassWithAbstractMethods() {
        String cls = ((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)ClassBuilder.define((String)"org.foo.Foo").publicScope().abstractClass().body().publicConstructor().finish()).publicAbstractMethod(Void.TYPE, "foo").finish()).protectedAbstractMethod(Void.TYPE, "bar").finish()).publicMethod(Void.TYPE, "baz").finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate abstract class with abstract method", "     package org.foo;\n\n public abstract class Foo {\n   public Foo() {   }   public abstract void foo();   protected abstract void bar();   public void baz() {   } }", cls);
    }

    @Test
    public void testDefineAbstractClassWithAbstractMethods2() {
        String cls = ((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)((ClassStructureBuilderAbstractMethodOption)ClassBuilder.define((String)"org.foo.Foo").publicScope().abstractClass().body().publicConstructor().finish()).publicAbstractMethod(MetaClassFactory.get(String.class), "someString").finish()).publicAbstractMethod(java.lang.Integer.class, "someInteger", new Parameter[]{Parameter.finalOf(Long.TYPE, (String)"aLong")}).finish()).publicAbstractMethod(Void.TYPE, "foo", new Class[]{String.class, java.lang.Integer.class}).throws_(new Class[]{Throwable.class})).protectedAbstractMethod(Void.TYPE, "bar", new Class[]{Long.class, Double.class}).throws_(new Class[]{UnsupportedOperationException.class})).protectedAbstractMethod(Long.class, "funTimes", new Parameter[]{Parameter.finalOf(String.class, (String)"str")}).finish()).packageAbstractMethod(Void.TYPE, "foobaz", new Class[]{Map.class}).throws_(new MetaClass[]{MetaClassFactory.get(ClassNotFoundException.class)})).packageAbstractMethod(Float.class, "boringTimes", new Parameter[]{Parameter.of(byte[].class, (String)"byteArr")}).finish()).publicMethod(Void.TYPE, "baz").finish()).toJavaString();
        ClassBuilderTest.assertEquals("package org.foo;\n\nimport java.util.Map;\n\npublic abstract class Foo {\n  public Foo() {\n\n  }\n\n  public abstract String someString();\n  public abstract Integer someInteger(final long aLong);\n  public abstract void foo(String a0, Integer a1) throws Throwable;\n  protected abstract void bar(Long a0, Double a1) throws UnsupportedOperationException;\n  protected abstract Long funTimes(final String str);\n  abstract void foobaz(Map a0) throws ClassNotFoundException;\n  abstract Float boringTimes(byte[] byteArr);\n  public void baz() {\n\n  }\n}", cls);
    }

    @Test
    public void testDefineClassWithConstructorCallingSuper() {
        String cls = ((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().publicConstructor().callSuper().finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with constructor calling super()", "     package org.foo;\n\n public class Foo {\n   public Foo() {     super();   } }", cls);
    }

    @Test
    public void testDefineClassWithConstructorCallingThis() {
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().privateField("b", Boolean.TYPE).finish()).publicConstructor().callThis(new Object[]{false}).finish()).publicConstructor(new Parameter[]{Parameter.of(Boolean.TYPE, (String)"b")}).append((Statement)Stmt.loadClassMember((String)"b", (Object[])new Object[0]).assignValue((Object)Variable.get((String)"b"))).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with constructor calling this()", "     package org.foo;\n\n public class Foo {\n   private boolean b;   public Foo() {     this(false);   }   public Foo(boolean b) {     this.b = b;   } }", cls);
    }

    @Test
    public void testDefineClassWithMethodCallingMethodOnThis() {
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().publicMethod(Void.TYPE, "bar").append((Statement)Stmt.loadVariable((String)"this", (Object[])new Object[0]).invoke("foo", new Object[0])).finish()).publicMethod(String.class, "foo").append(Stmt.load(null).returnValue()).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with method calling method on this", "     package org.foo;\n\n public class Foo {\n   public void bar() {     foo();   }   public String foo() {     return null;   } }", cls);
    }

    @Test
    public void testDefineClassWithMethodCallingInvalidMethodOnThis() {
        try {
            ((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().publicMethod(Void.TYPE, "bar").append((Statement)Stmt.loadVariable((String)"this", (Object[])new Object[0]).invoke("foo", new Object[]{"invalidParam"})).finish()).publicMethod(String.class, "foo").append(Stmt.load(null).returnValue()).finish()).toJavaString();
            Assert.fail((String)"exprected UndefinedMethodException");
        }
        catch (UndefinedMethodException udme) {
            ClassBuilderTest.assertEquals("Wrong exception thrown", udme.getMethodName(), "foo");
        }
    }

    @Test
    public void testDefineClassWithMethodCallingMethodOnSuper() {
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().publicMethod(Void.TYPE, "bar").append((Statement)Stmt.loadVariable((String)"this", (Object[])new Object[0]).invoke("foo", new Object[0])).finish()).publicMethod(String.class, "foo").append(Stmt.loadVariable((String)"super", (Object[])new Object[0]).invoke("toString", new Object[0]).returnValue()).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with method calling method on this", "     package org.foo;\n\n public class Foo {\n   public void bar() {     foo();   }   public String foo() {     return super.toString();   } }", cls);
    }

    @Test
    public void testDefineClassWithMethodCallingInvalidMethodOnSuper() {
        try {
            ((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().publicMethod(Void.TYPE, "bar").append((Statement)Stmt.loadVariable((String)"this", (Object[])new Object[0]).invoke("foo", new Object[0])).finish()).publicMethod(String.class, "foo").append((Statement)Stmt.loadVariable((String)"super", (Object[])new Object[0]).invoke("undefinedMethod", new Object[0])).finish()).toJavaString();
            Assert.fail((String)"exprected UndefinedMethodException");
        }
        catch (UndefinedMethodException udme) {
            ClassBuilderTest.assertEquals("Wrong exception thrown", udme.getMethodName(), "undefinedMethod");
        }
    }

    @Test
    public void testDefineClassWithMethodHavingThrowsDeclaration() {
        String cls = ((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().publicMethod(Void.TYPE, "initialize").throws_(new Class[]{Exception.class, IllegalArgumentException.class}).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with method having throws declaration", "     package org.foo;\n\n public class Foo {\n   public void initialize() throws Exception, IllegalArgumentException {   } }", cls);
    }

    @Test
    public void testDefineClassWithMethodsOfAllScopes() {
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().publicMethod(Void.TYPE, "publicMethod").finish()).protectedMethod(Void.TYPE, "protectedMethod").finish()).packageMethod(Void.TYPE, "packagePrivateMethod").finish()).privateMethod(Void.TYPE, "privateMethod").finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with methods of all scopes", "     package org.foo;\n\n public class Foo {\n   public void publicMethod() {   }   protected void protectedMethod() {   }   void packagePrivateMethod() {   }   private void privateMethod() {   } }", cls);
    }

    @Test
    public void testDefineClassWithFieldsOfAllScopes() {
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().publicField("publicField", java.lang.Integer.TYPE).finish()).protectedField("protectedField", java.lang.Integer.TYPE).finish()).packageField("packagePrivateField", java.lang.Integer.TYPE).finish()).privateField("privateField", java.lang.Integer.TYPE).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with fields of all scopes", "     package org.foo;\n\n public class Foo {\n   public int publicField;\n   protected int protectedField;\n   int packagePrivateField;\n   private int privateField;\n }", cls);
    }

    @Test
    public void testDefineClassWithConstructorsOfAllScopes() {
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"org.foo.Foo").publicScope().body().publicConstructor().finish()).protectedConstructor().finish()).packageConstructor().finish()).privateConstructor().finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with constructors of all scopes", "     package org.foo;\n\n public class Foo {\n   public Foo() {   }   protected Foo() {   }   Foo() {   }   private Foo() {   } }", cls);
    }

    @Test
    public void testDefineClassByImplementingInterface() {
        String cls = ((ClassStructureBuilder)ClassBuilder.implement(Baz.class).publicMethod(Void.TYPE, "someMethod").finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class by implementing an interface", "     package org.jboss.errai.codegen.test.model;\n\n public class BazImpl implements Baz {\n     public void someMethod() {\n     }\n }", cls);
    }

    @Test
    public void testDefineClassWithStaticMethod() {
        String cls = ((ClassStructureBuilder)((MethodBlockBuilder)ClassBuilder.define((String)"my.test.Clazz").publicScope().body().publicMethod(Void.TYPE, "test").modifiers(new Modifier[]{Modifier.Static})).body().append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"Hello, World!"})).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with static method", "     package my.test;\n\n public class Clazz {\n    public static void test() {\n        System.out.println(\"Hello, World!\");\n    }\n }", cls);
    }

    @Test
    public void testDefineClassWithJSNIMethod() {
        String cls = ((ClassStructureBuilder)((MethodBlockBuilder)ClassBuilder.define((String)"my.test.Clazz").publicScope().body().publicMethod(Void.TYPE, "test").modifiers(new Modifier[]{Modifier.JSNI})).body().append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"Hello, World!"})).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with JSNI method", "     package my.test;\n\n public class Clazz {\n    public native void test() /*-{\n        System.out.println(\"Hello, World!\");\n    }-*/;\n }", cls);
    }

    @Test
    public void testCollidingImportsWithInnerClass() {
        String cls = ((ClassStructureBuilder)ClassBuilder.define((String)"my.test.Clazz").publicScope().implementsInterface(org.jboss.errai.codegen.test.model.TestInterface.class).implementsInterface(TestInterface.class).implementsInterface(Serializable.class).body().privateField("name", String.class).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with colliding imports", "     package my.test;\n import java.io.Serializable;\n import org.jboss.errai.codegen.test.model.TestInterface;\n\n public class Clazz implements TestInterface,    org.jboss.errai.codegen.test.ClassBuilderTest.TestInterface, Serializable {\n   private String name;\n }", cls);
    }

    @Test
    public void testCollidingImportsWithInnerClassFirst() {
        String cls = ((ClassStructureBuilder)ClassBuilder.define((String)"my.test.Clazz").publicScope().implementsInterface(TestInterface.class).implementsInterface(org.jboss.errai.codegen.test.model.TestInterface.class).implementsInterface(Serializable.class).body().privateField("name", String.class).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with colliding imports", "     package my.test;\n import java.io.Serializable;\n import org.jboss.errai.codegen.test.ClassBuilderTest.TestInterface;\n\n public class Clazz implements TestInterface,    org.jboss.errai.codegen.test.model.TestInterface, Serializable {\n   private String name;\n }", cls);
    }

    @Test
    public void testCollidingImportsWithJavaLang() {
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"my.test.Clazz").publicScope().body().privateField("i", Integer.class).finish()).privateField("j", java.lang.Integer.class).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with colliding imports", "     package my.test; import org.jboss.errai.codegen.test.model.Integer;\n\n public class Clazz {\n    private Integer i;\n   private java.lang.Integer j;\n }", cls);
    }

    @Test
    public void testCollidingImportsWithJavaLangFirst() {
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)ClassBuilder.define((String)"my.test.Clazz").publicScope().body().privateField("i", java.lang.Integer.class).finish()).privateField("j", Integer.class).finish()).toJavaString();
        ClassBuilderTest.assertEquals("failed to generate class with colliding imports", "     package my.test;\n public class Clazz {\n    private Integer i;\n   private org.jboss.errai.codegen.test.model.Integer j;\n }", cls);
    }

    @Test
    public void testThisReferenceWithStmtLoadVariable() {
        ClassStructureBuilder body = ClassBuilder.define((String)"org.foo.Foo").publicScope().body();
        String cls = ((ClassStructureBuilder)body.publicMethod((MetaClass)body.getClassDefinition(), "getThis").append(Stmt.loadVariable((String)"this", (Object[])new Object[0]).returnValue()).finish()).toJavaString();
        ClassBuilderTest.assertEquals("did not properly render 'this' reference", "package org.foo;\n\n\npublic class Foo {\n  public Foo getThis() {\n    return this;\n  }\n}", cls);
    }

    @Test
    public void testMethodAnnotated() {
        String cls = ((ClassStructureBuilder)ClassBuilder.define((String)"MyRunnable").publicScope().implementsInterface(Runnable.class).body().publicMethod(Void.TYPE, "run").annotatedWith(new Annotation[]{new SuppressWarnings(){

            @Override
            public String[] value() {
                return new String[]{"blah"};
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return SuppressWarnings.class;
            }
        }}).body().append((Statement)Stmt.returnVoid()).finish()).toJavaString();
        ClassBuilderTest.assertEquals("public class MyRunnable implements Runnable {\n  @SuppressWarnings(\"blah\") public void run() {\n    return;\n  }\n}", cls);
    }

    @Test
    public void testClassComment() throws Exception {
        String cls = ClassBuilder.define((String)"org.foo.Bar").classComment("A foo-ish bar").publicScope().body().toJavaString();
        ClassBuilderTest.assertEquals("     package org.foo; // A foo-ish bar public class Bar {}", cls);
    }

    public static interface TestInterface {
    }
}

