/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import java.util.List;
import javax.enterprise.util.TypeLiteral;
import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.Variable;
import org.jboss.errai.codegen.VariableReference;
import org.jboss.errai.codegen.builder.impl.ContextBuilder;
import org.jboss.errai.codegen.builder.impl.ObjectBuilder;
import org.jboss.errai.codegen.exception.InvalidTypeException;
import org.jboss.errai.codegen.literal.LiteralFactory;
import org.jboss.errai.codegen.meta.MetaClassFactory;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.util.Stmt;
import org.junit.Assert;
import org.junit.Test;

public class ContextBuilderTest
extends AbstractCodegenTest {
    @Test
    public void testDeclareVariableWithExactTypeProvided() {
        String declaration = ((ContextBuilder)ContextBuilder.create().declareVariable("n", Integer.class).initializeWith((Object)10)).toJavaString();
        ContextBuilderTest.assertEquals("failed to generate variable declaration using a literal initialization", "Integer n = 10;", declaration);
    }

    @Test
    public void testDeclareVariableWithTypeLiteral() {
        String declaration = ((ContextBuilder)ContextBuilder.create((Context)Context.create().autoImport()).declareVariable("list", (TypeLiteral)new TypeLiteral<List<String>>(){}).finish()).toJavaString();
        ContextBuilderTest.assertEquals("failed to generate variable declaration using a type literal", "List<String> list;", declaration);
    }

    @Test
    public void testDeclareVariableWithIntegerTypeInference() {
        String declaration = ((ContextBuilder)ContextBuilder.create().declareVariable("n").initializeWith((Object)10)).toJavaString();
        ContextBuilderTest.assertEquals("failed to generate variable declaration using a literal initialization and type inference", "Integer n = 10;", declaration);
    }

    @Test
    public void testDeclareVariableWithStringTypeInference() {
        String declaration = ((ContextBuilder)ContextBuilder.create().declareVariable("n").initializeWith((Object)"10")).toJavaString();
        ContextBuilderTest.assertEquals("failed to generate variable declaration using a literal initialization and type inference", "String n = \"10\";", declaration);
    }

    @Test
    public void testDeclareVariableWithImplicitTypeConversion() {
        String declaration = ((ContextBuilder)ContextBuilder.create().declareVariable("n", Integer.class).initializeWith((Object)"10")).toJavaString();
        ContextBuilderTest.assertEquals("failed to generate variable declaration using a literal initialization and type conversion", "Integer n = 10;", declaration);
    }

    @Test
    public void testDeclareVariableWithInvalidInitialization() {
        try {
            ((ContextBuilder)ContextBuilder.create().declareVariable("n", Integer.class).initializeWith((Object)"abc")).toJavaString();
            Assert.fail((String)"Expected InvalidTypeException");
        }
        catch (InvalidTypeException ive) {
            Assert.assertTrue((boolean)(ive.getCause() instanceof NumberFormatException));
        }
    }

    @Test
    public void testDeclareVariableWithObjectInitialization() {
        String declaration = ((ContextBuilder)ContextBuilder.create().declareVariable("str", String.class).initializeWith((Statement)ObjectBuilder.newInstanceOf(String.class))).toJavaString();
        ContextBuilderTest.assertEquals("failed to generate variable declaration using an objectbuilder initialization", "String str = new String();", declaration);
    }

    @Test
    public void testDeclareVariableWithObjectInitializationWithParameters() {
        String declaration = ((ContextBuilder)ContextBuilder.create().declareVariable("str", String.class).initializeWith((Statement)ObjectBuilder.newInstanceOf(String.class).withParameters(new Object[]{"abc"}))).toJavaString();
        ContextBuilderTest.assertEquals("failed to generate variable declaration using an objectbuilder initialization with parameters", "String str = new String(\"abc\");", declaration);
    }

    @Test
    public void testDeclareVariableWithObjectInitializationUsingSuperClassType() {
        String declaration = ((ContextBuilder)ContextBuilder.create().declareVariable("str", Object.class).initializeWith((Statement)ObjectBuilder.newInstanceOf(String.class).withParameters(new Object[]{"abc"}))).toJavaString();
        ContextBuilderTest.assertEquals("failed to generate variable declaration using an objectbuilder initialization with parameters", "Object str = new String(\"abc\");", declaration);
        try {
            Stmt.declareVariable((String)"str", Integer.class, (Object)ObjectBuilder.newInstanceOf(String.class).withParameters(new Object[]{"abc"})).toJavaString();
            Assert.fail((String)"Expected InvalidTypeException");
        }
        catch (InvalidTypeException e) {
            // empty catch block
        }
        try {
            Stmt.declareVariable((String)"str", String.class, (Object)ObjectBuilder.newInstanceOf(Object.class)).toJavaString();
            Assert.fail((String)"Expected InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testAddVariableWithExactTypeProvided() {
        Context ctx = ContextBuilder.create().addVariable("n", Integer.class, (Object)10).getContext();
        VariableReference n = ctx.getVariable("n");
        ContextBuilderTest.assertEquals("Wrong variable name", "n", n.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(Integer.class), (Object)n.getType());
        Assert.assertEquals((String)"Wrong variable value", (Object)LiteralFactory.getLiteral((Object)10), (Object)n.getValue());
    }

    @Test
    public void testAddVariableWithIntegerTypeInference() {
        Context ctx = ContextBuilder.create().addVariable("n", (Object)10).getContext();
        VariableReference n = ctx.getVariable("n");
        ContextBuilderTest.assertEquals("Wrong variable name", "n", n.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(Integer.class), (Object)n.getType());
        Assert.assertEquals((String)"Wrong variable value", (Object)LiteralFactory.getLiteral((Object)10), (Object)n.getValue());
    }

    @Test
    public void testAddVariableWithStringTypeInference() {
        Context ctx = ContextBuilder.create().addVariable("n", (Object)"10").getContext();
        VariableReference n = ctx.getVariable("n");
        ContextBuilderTest.assertEquals("Wrong variable name", "n", n.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(String.class), (Object)n.getType());
        Assert.assertEquals((String)"Wrong variable value", (Object)LiteralFactory.getLiteral((Object)"10"), (Object)n.getValue());
    }

    @Test
    public void testAddVariableWithImplicitTypeConversion() {
        Context ctx = ContextBuilder.create().addVariable("n", Integer.class, (Object)"10").getContext();
        VariableReference n = ctx.getVariable("n");
        ContextBuilderTest.assertEquals("Wrong variable name", "n", n.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(Integer.class), (Object)n.getType());
        Assert.assertEquals((String)"Wrong variable value", (Object)LiteralFactory.getLiteral((Object)10), (Object)n.getValue());
        try {
            Stmt.create((Context)ContextBuilder.create().addVariable("n", Integer.class, (Object)"abc").getContext()).toJavaString();
            Assert.fail((String)"Expected InvalidTypeException");
        }
        catch (InvalidTypeException ive) {
            Assert.assertTrue((boolean)(ive.getCause() instanceof NumberFormatException));
        }
    }

    @Test
    public void testAddVariableWithObjectInitializationWithExactTypeProvided() {
        Context ctx = ContextBuilder.create().addVariable("str", String.class, (Object)ObjectBuilder.newInstanceOf(String.class)).getContext();
        VariableReference str = ctx.getVariable("str");
        ContextBuilderTest.assertEquals("Wrong variable name", "str", str.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(String.class), (Object)str.getType());
        Variable v = (Variable)ctx.getVariables().get("str");
        v.generate(ctx);
        Assert.assertNotNull((String)"Value could not be generated", (Object)v.getValue());
    }

    @Test
    public void testAddVariableWithObjectInitializationWithStringTypeInference() {
        Context ctx = ContextBuilder.create().addVariable("str", (Object)ObjectBuilder.newInstanceOf(String.class)).getContext();
        VariableReference str = ctx.getVariable("str");
        ContextBuilderTest.assertEquals("Wrong variable name", "str", str.getName());
        Variable v = (Variable)ctx.getVariables().get("str");
        v.generate(ctx);
        Assert.assertNotNull((String)"Value could not be generated", (Object)v.getValue());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(String.class), (Object)v.getType());
    }
}

