/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.literal.LiteralFactory;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.test.model.Person;
import org.jboss.errai.codegen.test.model.PersonImpl;
import org.jboss.errai.codegen.util.Stmt;
import org.junit.Assert;
import org.junit.Test;

public class LiteralTest
extends AbstractCodegenTest {
    @Test
    public void testIntegerLiteral() {
        LiteralTest.assertEquals("1234", LiteralFactory.getLiteral((Object)1234).generate(Context.create()));
    }

    @Test
    public void testShortLiteral() {
        LiteralTest.assertEquals("1234", LiteralFactory.getLiteral((Object)1234).generate(Context.create()));
    }

    @Test
    public void testLongLiteral() {
        LiteralTest.assertEquals("1234L", LiteralFactory.getLiteral((Object)1234L).generate(Context.create()));
    }

    @Test
    public void testDoubleLiteral() {
        LiteralTest.assertEquals("1234.567d", LiteralFactory.getLiteral((Object)1234.567).generate(Context.create()));
    }

    @Test
    public void testFloatLiteral() {
        LiteralTest.assertEquals("1234.567f", LiteralFactory.getLiteral((Object)Float.valueOf(1234.567f)).generate(Context.create()));
    }

    @Test
    public void testByteLiteral() {
        LiteralTest.assertEquals("72", LiteralFactory.getLiteral((Object)72).generate(Context.create()));
    }

    @Test
    public void testBooleanLiteral() {
        LiteralTest.assertEquals("false", LiteralFactory.getLiteral((Object)false).generate(Context.create()));
    }

    @Test
    public void testStringLiteral() {
        String expected = "\"The quick brown fox said \\\"how do you do?\\\"\\nNew line.\\rCarriage Return!\\t and a tab\"";
        String input = "The quick brown fox said \"how do you do?\"\nNew line.\rCarriage Return!\t and a tab";
        LiteralTest.assertEquals("\"The quick brown fox said \\\"how do you do?\\\"\\nNew line.\\rCarriage Return!\\t and a tab\"", LiteralFactory.getLiteral((Object)"The quick brown fox said \"how do you do?\"\nNew line.\rCarriage Return!\t and a tab").generate(Context.create()));
    }

    @Test
    public void testStringArrayCreation() {
        String[][] input = new String[][]{{"Hello1", "Hello2"}, {"Hello3", "Hello4"}};
        String expected = "new String[][] { { \"Hello1\", \"Hello2\" }, { \"Hello3\", \"Hello4\" } }";
        LiteralTest.assertEquals("new String[][] { { \"Hello1\", \"Hello2\" }, { \"Hello3\", \"Hello4\" } }", LiteralFactory.getLiteral((Object)input).generate(Context.create()));
    }

    @Test
    public void testGenerateIntArrayThenModifyThenGenerateAgain() {
        int[] a = new int[]{1, 2, 3, 4};
        LiteralTest.assertEquals("new int[] { 1, 2, 3, 4 }", LiteralFactory.getLiteral((Object)a).generate(Context.create()));
        a[0] = 10;
        LiteralTest.assertEquals("new int[] { 10, 2, 3, 4 }", LiteralFactory.getLiteral((Object)a).generate(Context.create()));
    }

    @Test
    public void testGenerateObjectArrayThenModifyThenGenerateAgain() {
        PersonImpl p = new PersonImpl("person", 1, null);
        PersonImpl p2 = new PersonImpl("person", 1, null);
        Assert.assertNotSame((Object)p, (Object)p2);
        Assert.assertFalse((boolean)p.equals(p2));
        Person[] a = new Person[]{p};
        Context ctx = Context.create();
        ctx.addLiteralizableClass(Person.class);
        LiteralTest.assertEquals("new org.jboss.errai.codegen.test.model.Person[] { new org.jboss.errai.codegen.test.model.Person() { public int getAge() { return 1; } public org.jboss.errai.codegen.test.model.Person getMother() { return null; } public String getName() { return \"person\"; } } }", LiteralFactory.getLiteral((Object)a).generate(ctx));
        p.setAge(10);
        LiteralTest.assertEquals("new org.jboss.errai.codegen.test.model.Person[] { new org.jboss.errai.codegen.test.model.Person() { public int getAge() { return 10; } public org.jboss.errai.codegen.test.model.Person getMother() { return null; } public String getName() { return \"person\"; } } }", LiteralFactory.getLiteral((Object)a).generate(ctx));
    }

    @Test
    public void testClassLiteral() {
        LiteralTest.assertEquals("String.class", LiteralFactory.getLiteral(String.class).generate(Context.create()));
    }

    @Test
    public void testSetEncoding() {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        s.add("foo");
        s.add("bar");
        LiteralTest.assertEquals("new java.util.HashSet() {\n  {\n    add(\"foo\");\n    add(\"bar\");\n  }\n}", Stmt.load(s).generate(Context.create()));
    }

    @Test
    public void testListEncoding() {
        ArrayList<String> s = new ArrayList<String>();
        s.add("foo");
        s.add("bar");
        LiteralTest.assertEquals("new java.util.ArrayList() {\n  {\n    add(\"foo\");\n    add(\"bar\");\n  }\n}", Stmt.load(s).generate(Context.create()));
    }

    @Test
    public void testMapEncoding() {
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
        s.put("foo", "fooz");
        s.put("bar", "barz");
        LiteralTest.assertEquals("new java.util.HashMap() {\n  {\n    put(\"foo\", \"fooz\");\n    put(\"bar\", \"barz\");\n  }\n}", Stmt.load(s).generate(Context.create()));
    }
}

