/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.jboss.errai.codegen.AssignmentOperator;
import org.jboss.errai.codegen.BooleanExpression;
import org.jboss.errai.codegen.Cast;
import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.Expression;
import org.jboss.errai.codegen.Parameter;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.Variable;
import org.jboss.errai.codegen.VariableReference;
import org.jboss.errai.codegen.builder.AnonymousClassStructureBuilder;
import org.jboss.errai.codegen.builder.ContextualStatementBuilder;
import org.jboss.errai.codegen.builder.StatementBegin;
import org.jboss.errai.codegen.builder.impl.ObjectBuilder;
import org.jboss.errai.codegen.builder.impl.StatementBuilder;
import org.jboss.errai.codegen.exception.InvalidTypeException;
import org.jboss.errai.codegen.exception.OutOfScopeException;
import org.jboss.errai.codegen.exception.UndefinedFieldException;
import org.jboss.errai.codegen.literal.LiteralFactory;
import org.jboss.errai.codegen.meta.MetaClassFactory;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.test.model.BeanWithTypeParmedMeths;
import org.jboss.errai.codegen.test.model.Foo;
import org.jboss.errai.codegen.test.model.TEnum;
import org.jboss.errai.codegen.util.Bitwise;
import org.jboss.errai.codegen.util.Bool;
import org.jboss.errai.codegen.util.Expr;
import org.jboss.errai.codegen.util.Refs;
import org.jboss.errai.codegen.util.Stmt;
import org.junit.Assert;
import org.junit.Test;

public class StatementBuilderTest
extends AbstractCodegenTest {
    @Test
    public void testDeclareVariableWithExactTypeProvided() {
        Context ctx = Context.create();
        String s = StatementBuilder.create().declareVariable("n", Integer.class, (Object)10).generate(ctx);
        StatementBuilderTest.assertEquals("failed to generate variable declaration with type provided", "Integer n = 10;", s);
        VariableReference n = ctx.getVariable("n");
        StatementBuilderTest.assertEquals("Wrong variable name", "n", n.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(Integer.class), (Object)n.getType());
        Assert.assertEquals((String)"Wrong variable value", (Object)LiteralFactory.getLiteral((Object)10), (Object)n.getValue());
    }

    @Test
    public void testDeclareVariableWithIntegerTypeInference() {
        Context ctx = Context.create();
        String s = StatementBuilder.create().declareVariable("n", (Object)10).generate(ctx);
        StatementBuilderTest.assertEquals("failed to generate variable declaration with Integers type inference", "Integer n = 10;", s);
        VariableReference n = ctx.getVariable("n");
        StatementBuilderTest.assertEquals("Wrong variable name", "n", n.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(Integer.class), (Object)n.getType());
        Assert.assertEquals((String)"Wrong variable value", (Object)LiteralFactory.getLiteral((Object)10), (Object)n.getValue());
    }

    @Test
    public void testDeclareVariableWithStringTypeInference() {
        Context ctx = Context.create();
        String s = StatementBuilder.create().declareVariable("n", (Object)"10").generate(ctx);
        StatementBuilderTest.assertEquals("failed to generate variable declaration with =String type inference", "String n = \"10\";", s);
        VariableReference n = ctx.getVariable("n");
        StatementBuilderTest.assertEquals("Wrong variable name", "n", n.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(String.class), (Object)n.getType());
        Assert.assertEquals((String)"Wrong variable value", (Object)LiteralFactory.getLiteral((Object)"10"), (Object)n.getValue());
    }

    @Test
    public void testDeclareVariableWithImplicitTypeConversion() {
        Context ctx = Context.create();
        String s = StatementBuilder.create().declareVariable("n", Integer.class, (Object)"10").generate(ctx);
        StatementBuilderTest.assertEquals("failed to generate variable declaration with implicit type conversion", "Integer n = 10;", s);
        VariableReference n = ctx.getVariable("n");
        StatementBuilderTest.assertEquals("Wrong variable name", "n", n.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(Integer.class), (Object)n.getType());
        Assert.assertEquals((String)"Wrong variable value", (Object)LiteralFactory.getLiteral((Object)10), (Object)n.getValue());
        try {
            StatementBuilder.create().declareVariable("n", Integer.class, (Object)"abc").toJavaString();
            Assert.fail((String)"Expected InvalidTypeException");
        }
        catch (InvalidTypeException ive) {
            Assert.assertTrue((boolean)(ive.getCause() instanceof NumberFormatException));
        }
    }

    @Test
    public void testDeclareVariableWithObjectInitializationWithExactTypeProvided() {
        Context ctx = Context.create();
        String s = StatementBuilder.create().declareVariable("str", String.class, (Object)ObjectBuilder.newInstanceOf(String.class)).generate(ctx);
        StatementBuilderTest.assertEquals("failed to generate variable declaration with object initialization and type provided", "String str = new String();", s);
        VariableReference str = ctx.getVariable("str");
        StatementBuilderTest.assertEquals("Wrong variable name", "str", str.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(String.class), (Object)str.getType());
    }

    @Test
    public void testDeclareVariableWithObjectInitializationWithStringTypeInference() {
        Context ctx = Context.create();
        String s = StatementBuilder.create((Context)ctx).declareVariable("str", (Object)ObjectBuilder.newInstanceOf(String.class)).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate variable declaration with object initialization and string type inference", "String str = new String();", s);
        VariableReference str = ctx.getVariable("str");
        StatementBuilderTest.assertEquals("Wrong variable name", "str", str.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(String.class), (Object)str.getType());
    }

    @Test
    public void testDeclareVariableWithStatementInitialization() {
        Context ctx = Context.create();
        String s = Stmt.declareVariable((String)"str", String.class, (Object)Stmt.nestedCall((Statement)Stmt.newObject(Integer.class).withParameters(new Object[]{2})).invoke("toString", new Object[0])).generate(ctx);
        StatementBuilderTest.assertEquals("failed to generate variable declaration with statement initialization", "String str = new Integer(2).toString();", s);
        VariableReference str = ctx.getVariable("str");
        StatementBuilderTest.assertEquals("Wrong variable name", "str", str.getName());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(String.class), (Object)str.getType());
    }

    @Test
    public void testDeclareFinalVariable() {
        Context ctx = Context.create();
        String s = ((StatementBegin)StatementBuilder.create((Context)ctx).declareVariable(String.class).asFinal().named("str").initializeWith((Object)"10")).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate final variable declaration", "final String str = \"10\";", s);
        VariableReference str = ctx.getVariable("str");
        StatementBuilderTest.assertEquals("Wrong variable name", "str", str.getName());
        Assert.assertTrue((String)"Variable should be final", (boolean)((Variable)ctx.getVariables().get("str")).isFinal());
        Assert.assertEquals((String)"Wrong variable type", (Object)MetaClassFactory.get(String.class), (Object)str.getType());
    }

    @Test
    public void testLoadUndefinedVariable() {
        try {
            StatementBuilder.create().loadVariable("n", new Object[0]).toJavaString();
            Assert.fail((String)"Expected OutOfScopeException");
        }
        catch (OutOfScopeException outOfScopeException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateAndInitializeArray() {
        String s = StatementBuilder.create().newArray(String.class, new Object[0]).initialize(new Object[]{"1", "2"}).toJavaString();
        StatementBuilderTest.assertEquals("Failed to generate 1-dimensional String array", "new String[] { \"1\", \"2\" }", s);
    }

    @Test
    public void testCreateAndInitializeArrayWithInvalidInitialization() {
        try {
            StatementBuilder.create().newArray(Annotation.class, new Object[0]).initialize(new Object[]{"1", "2"}).toJavaString();
            Assert.fail((String)"Expected InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateAndInitializeArrayWithMissingInitializationAndDimensions() {
        try {
            StatementBuilder.create().newArray(String.class, new Object[0]).toJavaString();
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (Exception e) {
            StatementBuilderTest.assertEquals("Wrong exception details", "Must provide either dimension expressions or an array initializer", e.getMessage());
        }
    }

    @Test
    public void testCreateAndInitializeAnnotationArray() {
        Statement annotation1 = (Statement)((AnonymousClassStructureBuilder)ObjectBuilder.newInstanceOf(Annotation.class).extend().publicOverridesMethod("annotationType", new Parameter[0]).append(StatementBuilder.create().load(Inject.class).returnValue()).finish()).finish();
        Statement annotation2 = (Statement)((AnonymousClassStructureBuilder)ObjectBuilder.newInstanceOf(Annotation.class).extend().publicOverridesMethod("annotationType", new Parameter[0]).append(StatementBuilder.create().load(PostConstruct.class).returnValue()).finish()).finish();
        String s = StatementBuilder.create().newArray(Annotation.class, new Object[0]).initialize(new Object[]{annotation1, annotation2}).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate Annotation array", "new java.lang.annotation.Annotation[] { new java.lang.annotation.Annotation() {\n public Class annotationType() {\n   return javax.inject.Inject.class;\n }\n}, new java.lang.annotation.Annotation() {\n   public Class annotationType() {\n     return javax.annotation.PostConstruct.class;\n   }\n }\n}", s);
    }

    @Test
    public void testCreateAndInitializeTwoDimensionalArray() {
        String s = StatementBuilder.create().newArray(Integer.class, new Object[0]).initialize((Object[])new Integer[][]{{1, 2}, {3, 4}}).toJavaString();
        StatementBuilderTest.assertEquals("Failed to generate two dimensional array", "new Integer[][] { { 1, 2 }, { 3, 4 } }", s);
    }

    @Test
    public void testCreateAndInitializeTwoDimensionalArrayWithSingleValue() {
        String s = StatementBuilder.create().newArray(Integer.class, new Object[0]).initialize((Object[])new Object[][]{{1, 2}}).toJavaString();
        StatementBuilderTest.assertEquals("Failed to generate two dimensional array", "new Integer[][] { { 1, 2 } }", s);
    }

    @Test
    public void testCreateAndInitializeTwoDimensionalObjectArrayWithIntegers() {
        String s = StatementBuilder.create().newArray(Object.class, new Object[0]).initialize((Object[])new Object[][]{{1, 2}}).toJavaString();
        StatementBuilderTest.assertEquals("Failed to generate two dimensional array", "new Object[][] { { 1, 2 } }", s);
    }

    @Test
    public void testCreateAndInitializeTwoDimensionalArrayWithStatements() {
        String s = StatementBuilder.create().newArray(String.class, new Object[0]).initialize((Object[])new Statement[][]{{StatementBuilder.create().invokeStatic(Integer.class, "toString", new Object[]{1}), StatementBuilder.create().invokeStatic(Integer.class, "toString", new Object[]{2})}, {StatementBuilder.create().invokeStatic(Integer.class, "toString", new Object[]{3}), StatementBuilder.create().invokeStatic(Integer.class, "toString", new Object[]{4})}}).toJavaString();
        StatementBuilderTest.assertEquals("Failed to generate two dimensional array using statements", "new String[][] { { Integer.toString(1), Integer.toString(2) }, { Integer.toString(3), Integer.toString(4) } }", s);
    }

    @Test
    public void testCreateAndInitializeTwoDimensionalArrayWithStatementsAndLiterals() {
        String s = StatementBuilder.create().newArray(String.class, new Object[0]).initialize((Object[])new Object[][]{{StatementBuilder.create().invokeStatic(Integer.class, "toString", new Object[]{1}), "2"}, {StatementBuilder.create().invokeStatic(Integer.class, "toString", new Object[]{3}), "4"}}).toJavaString();
        StatementBuilderTest.assertEquals("Failed to generate two dimensional array using statements and objects", "new String[][] { { Integer.toString(1), \"2\" }, { Integer.toString(3), \"4\" } }", s);
    }

    @Test
    public void testCreateAndInitializeThreeDimensionalArray() {
        String s = StatementBuilder.create().newArray(String.class, new Object[0]).initialize((Object[])new String[][][]{{{"1", "2"}, {"a", "b"}}, {{"3", "4"}, {"b", "c"}}}).toJavaString();
        StatementBuilderTest.assertEquals("Failed to generate three dimensional array", "new String[][][] { { { \"1\", \"2\" }, { \"a\", \"b\" } }, { { \"3\", \"4\" }, { \"b\", \"c\" } } }", s);
    }

    @Test
    public void testAssignArrayValue() {
        String s = StatementBuilder.create().declareVariable("twoDimArray", String[][].class).loadVariable("twoDimArray", new Object[]{1, 2}).assignValue((Object)"test").toJavaString();
        StatementBuilderTest.assertEquals("Failed to generate array assignment", "twoDimArray[1][2] = \"test\";", s);
    }

    @Test
    public void testAssignArrayValueWithPreIncrementAssignment() {
        String s = StatementBuilder.create().declareVariable("twoDimArray", String[][].class).loadVariable("twoDimArray", new Object[]{1, 2}).assignValue(AssignmentOperator.PreIncrementAssign, (Object)"test").toJavaString();
        StatementBuilderTest.assertEquals("Failed to generate array assignment", "twoDimArray[1][2] += \"test\";", s);
    }

    @Test
    public void testAssignArrayValueWithVariableIndexes() {
        String s = StatementBuilder.create().declareVariable("twoDimArray", String[][].class).declareVariable("i", Integer.TYPE).declareVariable("j", Integer.TYPE).loadVariable("twoDimArray", new Object[]{Variable.get((String)"i"), Variable.get((String)"j")}).assignValue((Object)"test").toJavaString();
        StatementBuilderTest.assertEquals("Failed to generate array assignment", "twoDimArray[i][j] = \"test\";", s);
    }

    @Test
    public void testAssignArrayValueWithInvalidArray() {
        try {
            StatementBuilder.create().declareVariable("twoDimArray", String.class).loadVariable("twoDimArray", new Object[]{1, 2}).assignValue((Object)"test").toJavaString();
            Assert.fail((String)"Expected InvalidTypeExcpetion");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testAssignArrayValueWithInvalidIndexType() {
        try {
            StatementBuilder.create().declareVariable("twoDimArray", String[][].class).declareVariable("i", Float.TYPE).declareVariable("j", Float.TYPE).loadVariable("twoDimArray", new Object[]{Variable.get((String)"i"), Variable.get((String)"j")}).assignValue((Object)"test").toJavaString();
            Assert.fail((String)"Expected InvalidTypeExcpetion");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testObjectCreationWithLiteralParameter() {
        String s = StatementBuilder.create().newObject(String.class).withParameters(new Object[]{"original"}).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate new object with parameters", "new String(\"original\")", s);
    }

    @Test
    public void testObjectCreationWithVariableParameter() {
        String s = StatementBuilder.create().declareVariable("original", String.class).newObject(String.class).withParameters(new Object[]{Variable.get((String)"original")}).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate new object with parameters", "new String(original)", s);
    }

    @Test
    public void testObjectCreationWithParameterizedType() {
        String s = StatementBuilder.create().newObject((TypeLiteral)new TypeLiteral<ArrayList<String>>(){}).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate new object with parameterized type", "new java.util.ArrayList<String>()", s);
    }

    @Test
    public void testObjectCreationWithAutoImportedParameterizedType() {
        Context c = Context.create().autoImport();
        String s = StatementBuilder.create((Context)c).newObject((TypeLiteral)new TypeLiteral<ArrayList<Date>>(){}).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate new object with parameterized type", "new ArrayList<Date>()", s);
    }

    @Test
    public void testObjectCreationWithParameterizedTypeAndClassImport() {
        Context c = Context.create().addImport(MetaClassFactory.get(ArrayList.class));
        String s = StatementBuilder.create((Context)c).newObject((TypeLiteral)new TypeLiteral<ArrayList<String>>(){}).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate new object with parameterized type", "new ArrayList<String>()", s);
    }

    @Test
    public void testObjectCreationWithFullyQualifiedParameterizedTypeAndClassImport() {
        Context c = Context.create().addImport(MetaClassFactory.get(ArrayList.class));
        String s = StatementBuilder.create((Context)c).newObject((TypeLiteral)new TypeLiteral<ArrayList<Date>>(){}).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate new object with parameterized type", "new ArrayList<java.util.Date>()", s);
    }

    @Test
    public void testObjectCreationWithNestedParameterizedTypeAndClassImports() {
        Context c = Context.create().addImport(MetaClassFactory.get(ArrayList.class)).addImport(MetaClassFactory.get(HashMap.class));
        String s = StatementBuilder.create((Context)c).newObject((TypeLiteral)new TypeLiteral<ArrayList<ArrayList<HashMap<String, Integer>>>>(){}).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate new object with parameterized type", "new ArrayList<ArrayList<HashMap<String, Integer>>>()", s);
    }

    @Test
    public void testObjectCreationOfUninstantiableType() {
        try {
            Stmt.newObject(List.class).toJavaString();
            Assert.fail((String)"Expected InvalidTypeExcpetion");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testThrowExceptionUsingNewInstance() {
        Context c = Context.create().autoImport();
        String s = StatementBuilder.create((Context)c).throw_(InvalidTypeException.class, new Object[0]).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate throw statement using a new instance", "throw new InvalidTypeException()", s);
    }

    @Test
    public void testThrowExceptionUsingNewInstanceWithParameters() {
        Context c = Context.create().autoImport();
        String s = StatementBuilder.create((Context)c).throw_(InvalidTypeException.class, new Object[]{"message"}).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate throw statement using a new instance", "throw new InvalidTypeException(\"message\")", s);
    }

    @Test
    public void testThrowExceptionUsingVariable() {
        String s = StatementBuilder.create().declareVariable("t", Throwable.class).throw_("t").toJavaString();
        StatementBuilderTest.assertEquals("failed to generate throw statement using a variable", "throw t", s);
    }

    @Test
    public void testThrowExceptionUsingInvalidVariable() {
        try {
            StatementBuilder.create().declareVariable("t", Integer.class).throw_("t").toJavaString();
            Assert.fail((String)"expected InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testThrowExceptionUsingUndefinedVariable() {
        try {
            StatementBuilder.create().throw_("t").toJavaString();
            Assert.fail((String)"expected OutOfScopeException");
        }
        catch (OutOfScopeException outOfScopeException) {
            // empty catch block
        }
    }

    @Test
    public void testNestedCall() {
        String s = StatementBuilder.create().nestedCall((Statement)StatementBuilder.create().declareVariable("n", Integer.class).loadVariable("n", new Object[0]).invoke("toString", new Object[0])).invoke("getBytes", new Object[0]).toJavaString();
        StatementBuilderTest.assertEquals("failed to generate nested call", "n.toString().getBytes()", s);
    }

    @Test
    public void testAssignField() {
        String s = Stmt.create((Context)Context.create().autoImport()).nestedCall((Statement)Stmt.newObject(Foo.class)).loadField("bar").loadField("name").assignValue((Object)"test").toJavaString();
        StatementBuilderTest.assertEquals("failed to generate nested field assignment", "new Foo().bar.name = \"test\";", s);
    }

    @Test
    public void testAssignInvalidField() {
        try {
            String s = Stmt.create((Context)Context.create().autoImport()).nestedCall((Statement)Stmt.newObject(Foo.class)).loadField("invalid").assignValue((Object)"test").toJavaString();
            Assert.fail((String)"expected UndefinedFieldException");
        }
        catch (UndefinedFieldException undefinedFieldException) {
            // empty catch block
        }
    }

    @Test
    public void testCastDown() {
        Statement stmt = Cast.to(String.class, (Statement)Stmt.declareVariable((String)"obj", Object.class).loadVariable("obj", new Object[0]));
        StatementBuilderTest.assertEquals("failed to generate cast", "(String) obj", stmt.generate(Context.create()));
    }

    @Test
    public void testCastUp() {
        Statement stmt = Cast.to(Object.class, (Statement)Stmt.declareVariable((String)"str", String.class).loadVariable("str", new Object[0]));
        StatementBuilderTest.assertEquals("created a redundant cast", "str", stmt.generate(Context.create()));
    }

    @Test
    public void testCastWithVariableGetAPI() {
        Context ctx = Context.create();
        ctx.addVariable(Variable.create((String)"str", String.class));
        Statement stmt = Cast.to(Object.class, (Statement)Variable.get((String)"str"));
        StatementBuilderTest.assertEquals("created a redundant cast", "str", stmt.generate(ctx));
    }

    @Test
    public void testInvalidCast() {
        try {
            Statement stmt = Cast.to(Integer.class, (Statement)Stmt.declareVariable((String)"str", String.class).loadVariable("str", new Object[0]));
            stmt.generate(Context.create());
            Assert.fail((String)"expected InvalidTypeException");
        }
        catch (InvalidTypeException e) {
            StatementBuilderTest.assertEquals("Wrong exception message", "java.lang.String cannot be cast to java.lang.Integer", e.getMessage());
        }
    }

    @Test
    public void testReturnVoid() {
        Context ctx = Context.create();
        ctx.addVariable(Variable.create((String)"foo", Object.class));
        Statement stmt = (Statement)Stmt.if_((BooleanExpression)Bool.isNull((Object)Refs.get((String)"foo"))).append((Statement)Stmt.returnVoid()).finish();
        StatementBuilderTest.assertEquals("failed to generate return statement", "if (foo == null) {\n  return;\n}", stmt.generate(ctx));
    }

    @Test
    public void testTypeInferenceWorksPropertyForParameterizedMethodTypes() {
        String s = Stmt.loadStatic(BeanWithTypeParmedMeths.class, (String)"INSTANCE").invoke("setFooBarMap", new Object[]{Stmt.loadStatic(BeanWithTypeParmedMeths.class, (String)"INSTANCE").invoke("getFooBarMap", new Object[0])}).toJavaString();
        StatementBuilderTest.assertEquals("org.jboss.errai.codegen.test.model.BeanWithTypeParmedMeths.INSTANCE.setFooBarMap(org.jboss.errai.codegen.test.model.BeanWithTypeParmedMeths.INSTANCE.getFooBarMap())", s);
    }

    @Test
    public void testBitwiseOrExpression() {
        String generate = Bitwise.or((Object)Stmt.load((Object)1), (Object[])new Object[]{Stmt.load((Object)2), Stmt.load((Object)3)}).generate(Context.create());
        StatementBuilderTest.assertEquals("1 | 2 | 3", generate);
    }

    @Test
    public void testBitwiseAndExpression() {
        String generate = Bitwise.and((Object)Stmt.load((Object)1), (Object[])new Object[]{Stmt.load((Object)2), Stmt.load((Object)3)}).generate(Context.create());
        StatementBuilderTest.assertEquals("1 & 2 & 3", generate);
    }

    @Test
    public void testMixedBitwise() {
        String generate = Bitwise.or((Object)Stmt.load((Object)1), (Object[])new Object[]{Stmt.load((Object)2), Expr.qualify((Statement)Bitwise.and((Object)Stmt.load((Object)10), (Object[])new Object[]{Stmt.load((Object)20)}))}).generate(Context.create());
        StatementBuilderTest.assertEquals("1 | 2 | (10 & 20)", generate);
    }

    @Test
    public void testPassBitwiseToMethodParameter() {
        Expression bitwiseStatement = Bitwise.or((Object)Stmt.load((Object)1), (Object[])new Object[]{Stmt.load((Object)2), Expr.qualify((Statement)Bitwise.and((Object)Stmt.load((Object)10), (Object[])new Object[]{Stmt.load((Object)20)}))});
        String generate = Stmt.newObject(Integer.class).withParameters(new Object[]{bitwiseStatement}).generate(Context.create());
        StatementBuilderTest.assertEquals("new Integer(1 | 2 | (10 & 20))", generate);
    }

    @Test
    public void testEnumReference() {
        ContextualStatementBuilder statementBuilder = Stmt.loadStatic(TEnum.class, (String)"FIRST");
        StatementBuilderTest.assertEquals(TEnum.class.getName() + ".FIRST", statementBuilder.generate(Context.create()));
    }
}

