/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.Variable;
import org.jboss.errai.codegen.builder.CatchBlockBuilder;
import org.jboss.errai.codegen.builder.StatementEnd;
import org.jboss.errai.codegen.builder.impl.StatementBuilder;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.util.Stmt;
import org.junit.Test;

public class TryBlockBuilderTest
extends AbstractCodegenTest {
    @Test
    public void testEmptyTryBlock() {
        String s = ((CatchBlockBuilder)StatementBuilder.create().try_().finish()).toJavaString();
        TryBlockBuilderTest.assertEquals("Failed to generate empty try catch block", "     try {\n }  finally {\n }\n", s);
    }

    @Test
    public void testTryFinallyBlock() {
        String s = ((StatementEnd)((CatchBlockBuilder)StatementBuilder.create().try_().finish()).finally_().finish()).toJavaString();
        TryBlockBuilderTest.assertEquals("Failed to generate empty try finally block", "     try {\n }  finally {\n }\n", s);
    }

    @Test
    public void testTryCatchBlock() {
        String s = ((CatchBlockBuilder)((CatchBlockBuilder)StatementBuilder.create().try_().finish()).catch_(Throwable.class, "t").finish()).toJavaString();
        TryBlockBuilderTest.assertEquals("Failed to generate empty try catch block", "     try {\n }  catch (Throwable t) {\n }\n", s);
    }

    @Test
    public void testTryCatchFinallyBlockEmpty() {
        String s = ((StatementEnd)((CatchBlockBuilder)((CatchBlockBuilder)StatementBuilder.create().try_().finish()).catch_(Throwable.class, "t").finish()).finally_().finish()).toJavaString();
        TryBlockBuilderTest.assertEquals("Failed to generate empty try catch finally block", "     try {\n }  catch (Throwable t) {\n }\n finally {\n }\n", s);
    }

    @Test
    public void testTryMultipleCatchFinallyBlock() {
        String s = ((StatementEnd)((CatchBlockBuilder)((CatchBlockBuilder)((CatchBlockBuilder)StatementBuilder.create().try_().finish()).catch_(Exception.class, "e").finish()).catch_(Throwable.class, "t").finish()).finally_().finish()).toJavaString();
        TryBlockBuilderTest.assertEquals("Failed to generate empty try catch finally block", "     try {\n }  catch (Exception e) {\n }\n catch (Throwable t) {\n }\n finally {\n }\n", s);
    }

    @Test
    public void testTryCatchFinallyBlock() {
        String s = ((StatementEnd)((CatchBlockBuilder)((CatchBlockBuilder)StatementBuilder.create().try_().append((Statement)Stmt.throw_(Exception.class, (Object[])new Object[0])).finish()).catch_(Exception.class, "e").append((Statement)Stmt.throw_(RuntimeException.class, (Object[])new Object[]{Variable.get((String)"e")})).finish()).finally_().append(Stmt.load((Object)0).returnValue()).finish()).toJavaString();
        TryBlockBuilderTest.assertEquals("Failed to generate try catch finally block", "     try {\n   throw new Exception(); }  catch (Exception e) {\n   throw new RuntimeException(e); }\n finally {\n   return 0; }\n", s);
    }
}

