/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test.meta;

import com.google.common.collect.Lists;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.jboss.errai.codegen.meta.MetaClass;
import org.jboss.errai.codegen.meta.MetaField;
import org.jboss.errai.codegen.meta.MetaMethod;
import org.jboss.errai.codegen.meta.MetaParameterizedType;
import org.jboss.errai.codegen.meta.MetaType;
import org.jboss.errai.codegen.meta.MetaTypeVariable;
import org.jboss.errai.codegen.meta.MetaWildcardType;
import org.jboss.errai.codegen.test.model.ClassWithGenericCollections;
import org.jboss.errai.codegen.test.model.ClassWithGenericMethods;
import org.jboss.errai.codegen.test.model.ObjectWithNested;
import org.jboss.errai.codegen.test.model.ParameterizedClass;
import org.jboss.errai.codegen.test.model.TestInterface;
import org.jboss.errai.codegen.test.model.tree.Child;
import org.jboss.errai.codegen.test.model.tree.Grandparent;
import org.jboss.errai.codegen.test.model.tree.GrandparentInterface;
import org.jboss.errai.codegen.test.model.tree.GrandparentSuperInterface;
import org.jboss.errai.codegen.test.model.tree.IsolatedInterface;
import org.jboss.errai.codegen.test.model.tree.Parent;
import org.jboss.errai.codegen.test.model.tree.ParentInterface;
import org.jboss.errai.codegen.test.model.tree.ParentSuperInterface1;
import org.jboss.errai.codegen.test.model.tree.ParentSuperInterface2;
import org.jboss.errai.codegen.util.GenUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mvel2.util.NullType;

public abstract class AbstractMetaClassTest {
    private MetaClass getMetaClass(Class<?> javaClass) {
        MetaClass impl = this.getMetaClassImpl(javaClass);
        Assert.assertEquals(this.getTypeOfMetaClassBeingTested(), impl.getClass());
        return impl;
    }

    protected abstract MetaClass getMetaClassImpl(Class<?> var1);

    protected abstract Class<? extends MetaClass> getTypeOfMetaClassBeingTested();

    @Test
    public void testInternalNameForOneDimensionalPrimitiveArray() {
        String internalName = this.getMetaClass(char[].class).getInternalName();
        Assert.assertEquals((String)"Wrong internal name generated for one-dimensional primitive array", (Object)"[C", (Object)internalName);
    }

    @Test
    public void testInternalNameForOneDimensionalObjectArray() {
        String internalName = this.getMetaClass(String[].class).getInternalName();
        Assert.assertEquals((String)"Wrong internal name generated for one-dimensional object array", (Object)"[Ljava/lang/String;", (Object)internalName);
    }

    @Test
    public void testInternalNameForMultiDimensionalPrimitiveArray() {
        String internalName = this.getMetaClass(char[][].class).getInternalName();
        Assert.assertEquals((String)"Wrong internal name generated for multidimensional primitive array", (Object)"[[C", (Object)internalName);
    }

    @Test
    public void testInternalNameForMultiDimensionalObjectArray() {
        String internalName = this.getMetaClass(String[][].class).getInternalName();
        Assert.assertEquals((String)"Wrong internal name generated for multidimensional object array", (Object)"[[Ljava/lang/String;", (Object)internalName);
    }

    @Test
    public void testObjectIsAssignableFromNull() throws Exception {
        MetaClass metaObject = this.getMetaClass(Object.class);
        MetaClass metaNull = this.getMetaClass(NullType.class);
        Assert.assertTrue((boolean)metaObject.isAssignableFrom(metaNull));
    }

    @Test
    public void testChildIsAssignableFromNull() throws Exception {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaNull = this.getMetaClass(NullType.class);
        Assert.assertTrue((boolean)metaChild.isAssignableFrom(metaNull));
    }

    @Test
    public void testNullIsAssignableToChild() throws Exception {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaNull = this.getMetaClass(NullType.class);
        Assert.assertTrue((boolean)metaNull.isAssignableTo(metaChild));
    }

    @Test
    public void testIsAssignableFromComparisonForNested() {
        MetaClass interfaceClass = this.getMetaClass(TestInterface.class);
        MetaClass metaHolderClass = this.getMetaClass(ObjectWithNested.class);
        MetaClass nestedInterface = metaHolderClass.getDeclaredClasses()[0];
        Assert.assertEquals((Object)"MyNestedInterface", (Object)nestedInterface.getName());
        Assert.assertEquals(this.getTypeOfMetaClassBeingTested(), nestedInterface.getClass());
        Assert.assertTrue((String)"MyNestedInterface should be assignable from TestInterface", (boolean)interfaceClass.isAssignableFrom(nestedInterface));
    }

    @Test
    public void testChildIsAssignableFromChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        Assert.assertTrue((boolean)metaChild.isAssignableFrom(metaChild));
    }

    @Test
    public void testChildIsAssignableToChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        Assert.assertTrue((boolean)metaChild.isAssignableTo(metaChild));
    }

    @Test
    public void testParentIsAssignableFromChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaParent = this.getMetaClass(Parent.class);
        Assert.assertTrue((boolean)metaParent.isAssignableFrom(metaChild));
    }

    @Test
    public void testChildIsNotAssignableFromParent() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaParent = this.getMetaClass(Parent.class);
        Assert.assertFalse((boolean)metaChild.isAssignableFrom(metaParent));
    }

    @Test
    public void testGrandParentIsAssignableFromChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaGrandparent = this.getMetaClass(Grandparent.class);
        Assert.assertTrue((boolean)metaGrandparent.isAssignableFrom(metaChild));
    }

    @Test
    public void testChildIsNotAssignableFromGrandParent() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaGrandparent = this.getMetaClass(Grandparent.class);
        Assert.assertFalse((boolean)metaChild.isAssignableFrom(metaGrandparent));
    }

    @Test
    public void testUncleIsAssignableFromChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaUncle = this.getMetaClass(ParentInterface.class);
        Assert.assertTrue((boolean)metaUncle.isAssignableFrom(metaChild));
    }

    @Test
    public void testChildIsNotAssignableFromUncle() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaUncle = this.getMetaClass(ParentInterface.class);
        Assert.assertFalse((boolean)metaChild.isAssignableFrom(metaUncle));
    }

    @Test
    public void testUncleInLawIsAssignableFromChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaUncleInLaw = this.getMetaClass(ParentSuperInterface1.class);
        Assert.assertTrue((boolean)metaUncleInLaw.isAssignableFrom(metaChild));
    }

    @Test
    public void testChildIsNotAssignableFromUncleInLaw() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaUncleInLaw = this.getMetaClass(ParentSuperInterface1.class);
        Assert.assertFalse((boolean)metaChild.isAssignableFrom(metaUncleInLaw));
    }

    @Test
    public void testUncleInLaw2IsAssignableFromChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaUncleInLaw = this.getMetaClass(ParentSuperInterface2.class);
        Assert.assertTrue((boolean)metaUncleInLaw.isAssignableFrom(metaChild));
    }

    @Test
    public void testChildIsNotAssignableFromUncleInLaw2() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaUncleInLaw = this.getMetaClass(ParentSuperInterface2.class);
        Assert.assertFalse((boolean)metaChild.isAssignableFrom(metaUncleInLaw));
    }

    @Test
    public void testGreatUncleIsAssignableFromChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaGreatUncle = this.getMetaClass(GrandparentInterface.class);
        Assert.assertTrue((boolean)metaGreatUncle.isAssignableFrom(metaChild));
    }

    @Test
    public void testChildIsNotAssignableFromGreatUncle() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaGreatUncle = this.getMetaClass(GrandparentInterface.class);
        Assert.assertFalse((boolean)metaChild.isAssignableFrom(metaGreatUncle));
    }

    @Test
    public void testGreatUncleInLawIsAssignableFromChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaGreatUncleInLaw = this.getMetaClass(GrandparentSuperInterface.class);
        Assert.assertTrue((boolean)metaGreatUncleInLaw.isAssignableFrom(metaChild));
    }

    @Test
    public void testChildIsNotAssignableFromGreatUncleInLaw() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaGreatUncleInLaw = this.getMetaClass(GrandparentSuperInterface.class);
        Assert.assertFalse((boolean)metaChild.isAssignableFrom(metaGreatUncleInLaw));
    }

    @Test
    public void testObjectIsAssignableFromChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaObject = this.getMetaClass(Object.class);
        Assert.assertTrue((boolean)metaObject.isAssignableFrom(metaChild));
    }

    @Test
    public void testChildIsNotAssignableFromObject() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaObject = this.getMetaClass(Object.class);
        Assert.assertFalse((boolean)metaChild.isAssignableFrom(metaObject));
    }

    @Test
    public void testObjectIsAssignableFromIsolatedInterface() {
        MetaClass metaInterface = this.getMetaClass(IsolatedInterface.class);
        MetaClass metaObject = this.getMetaClass(Object.class);
        Assert.assertTrue((boolean)metaObject.isAssignableFrom(metaInterface));
    }

    @Test
    public void testIsolatedInterfaceIsNotAssignableFromObject() {
        MetaClass metaInterface = this.getMetaClass(IsolatedInterface.class);
        MetaClass metaObject = this.getMetaClass(Object.class);
        Assert.assertFalse((boolean)metaInterface.isAssignableFrom(metaObject));
    }

    @Test
    public void testUncleIsAssignableToChild() {
        MetaClass metaChild = this.getMetaClass(Child.class);
        MetaClass metaUncle = this.getMetaClass(ParentInterface.class);
        Assert.assertTrue((boolean)metaChild.isAssignableTo(metaUncle));
    }

    @Test
    public void testNoDuplicateMethodsInClassHierarchy() throws NotFoundException {
        MetaClass child = this.getMetaClass(Child.class);
        ArrayList<MetaMethod> foundMethods = new ArrayList<MetaMethod>();
        for (MetaMethod m : child.getMethods()) {
            if (!m.getName().equals("interfaceMethodOverriddenMultipleTimes")) continue;
            foundMethods.add(m);
        }
        Assert.assertEquals((String)"Only one copy of the method should have been found", (long)1L, (long)foundMethods.size());
    }

    @Test
    public void testSuperClass() throws Exception {
        MetaClass child = this.getMetaClass(Child.class);
        MetaClass parent = child.getSuperClass();
        Assert.assertEquals((Object)this.getMetaClass(Parent.class), (Object)parent);
    }

    @Test
    public void testNamingMethods() throws Exception {
        MetaClass child = this.getMetaClass(Child.class);
        Assert.assertEquals((Object)Child.class.getSimpleName(), (Object)child.getName());
        Assert.assertEquals((Object)Child.class.getName(), (Object)child.getFullyQualifiedName());
        Assert.assertEquals((Object)Child.class.getName(), (Object)child.getCanonicalName());
        Assert.assertEquals((Object)("L" + Child.class.getName().replace('.', '/') + ";"), (Object)child.getInternalName());
    }

    @Test
    public void testAccessModifiersForPublicTopLevelClass() throws Exception {
        MetaClass child = this.getMetaClass(Child.class);
        Assert.assertTrue((boolean)child.isPublic());
        Assert.assertFalse((boolean)child.isProtected());
        Assert.assertFalse((boolean)child.isPrivate());
        Assert.assertTrue((boolean)child.isDefaultInstantiable());
    }

    @Test
    public void testGetInterfaces() throws Exception {
        MetaClass grandparent = this.getMetaClass(Grandparent.class);
        Assert.assertEquals((long)1L, (long)grandparent.getInterfaces().length);
        Assert.assertEquals(Arrays.asList(this.getMetaClass(GrandparentInterface.class)), Arrays.asList(grandparent.getInterfaces()));
    }

    @Test
    public void testFieldWithStringTypeParam() throws Exception {
        MetaClass metaClass = this.getMetaClass(ClassWithGenericCollections.class);
        MetaField field = metaClass.getDeclaredField("hasStringParam");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Collection", (Object)field.getType().getName());
        Assert.assertEquals((Object)"java.util.Collection", (Object)field.getType().getFullyQualifiedName());
        Assert.assertEquals((Object)"<java.lang.String>", (Object)field.getType().getParameterizedType().toString());
        Assert.assertEquals((Object)"java.util.Collection<java.lang.String>", (Object)field.getType().getFullyQualifiedNameWithTypeParms());
        Assert.assertEquals((Object)"java.util.Collection", (Object)field.getType().getErased().getFullyQualifiedNameWithTypeParms());
        Assert.assertEquals(Arrays.asList(this.getMetaClass(String.class)), Arrays.asList(field.getType().getParameterizedType().getTypeParameters()));
    }

    @Test
    public void testFieldWithStringBoundedWildcardTypeParam() throws Exception {
        MetaClass metaClass = this.getMetaClass(ClassWithGenericCollections.class);
        MetaField field = metaClass.getDeclaredField("hasWildcardExtendsStringParam");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Collection", (Object)field.getType().getName());
        Assert.assertEquals((Object)"java.util.Collection", (Object)field.getType().getFullyQualifiedName());
        Assert.assertEquals((Object)"<? extends java.lang.String>", (Object)field.getType().getParameterizedType().toString());
        Assert.assertEquals((Object)"java.util.Collection<? extends java.lang.String>", (Object)field.getType().getFullyQualifiedNameWithTypeParms());
        Assert.assertEquals((Object)"java.util.Collection", (Object)field.getType().getErased().getFullyQualifiedNameWithTypeParms());
        Assert.assertEquals((long)1L, (long)field.getType().getParameterizedType().getTypeParameters().length);
        MetaWildcardType typeParam = (MetaWildcardType)field.getType().getParameterizedType().getTypeParameters()[0];
        Assert.assertEquals((String)"Should have no lower bound", Arrays.asList(new Object[0]), Arrays.asList(typeParam.getLowerBounds()));
        Assert.assertEquals((String)"Upper bound should be java.lang.String", Arrays.asList(this.getMetaClass(String.class)), Arrays.asList(typeParam.getUpperBounds()));
    }

    @Test
    public void testFieldWithUnboundedTypeVarParam() throws Exception {
        MetaClass metaClass = this.getMetaClass(ClassWithGenericCollections.class);
        MetaField field = metaClass.getDeclaredField("hasUnboundedTypeVarFromClass");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Collection", (Object)field.getType().getName());
        Assert.assertEquals((Object)"java.util.Collection", (Object)field.getType().getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util.Collection<T>", (Object)field.getType().getParameterizedType().getName());
        Assert.assertEquals((Object)"java.util.Collection<T>", (Object)field.getType().getFullyQualifiedNameWithTypeParms());
        Assert.assertEquals((Object)"java.util.Collection", (Object)field.getType().getErased().getFullyQualifiedNameWithTypeParms());
        Assert.assertEquals((long)1L, (long)field.getType().getParameterizedType().getTypeParameters().length);
        MetaTypeVariable typeVar = (MetaTypeVariable)field.getType().getParameterizedType().getTypeParameters()[0];
        Assert.assertEquals((Object)"T", (Object)typeVar.getName());
        Assert.assertEquals((String)"Should have no upper bound", Arrays.asList(this.getMetaClass(Object.class)), Arrays.asList(typeVar.getBounds()));
    }

    @Test
    public void testFieldWithSingleUpperBoundedTypeVarParam() throws Exception {
        MetaClass metaClass = this.getMetaClass(ClassWithGenericCollections.class);
        MetaMethod field = metaClass.getDeclaredMethod("hasSingleBoundedTypeVarFromSelf", new Class[0]);
        Assert.assertNotNull((Object)field);
        MetaTypeVariable returnType = (MetaTypeVariable)field.getGenericReturnType();
        Assert.assertEquals((Object)"B", (Object)returnType.getName());
        Assert.assertEquals((String)"Should have a single upper bound", Arrays.asList(this.getMetaClass(Serializable.class)), Arrays.asList(returnType.getBounds()));
    }

    @Test
    public void testFieldWithTwoUpperBoundedTypeVarParam() throws Exception {
        MetaClass metaClass = this.getMetaClass(ClassWithGenericCollections.class);
        MetaMethod field = metaClass.getDeclaredMethod("hasDoubleBoundedTypeVarFromSelf", new Class[0]);
        Assert.assertNotNull((Object)field);
        MetaTypeVariable returnType = (MetaTypeVariable)field.getGenericReturnType();
        Assert.assertEquals((Object)"B", (Object)returnType.getName());
        Assert.assertEquals((String)"Should have two upper bounds", Arrays.asList(this.getMetaClass(Collection.class), this.getMetaClass(Serializable.class)), Arrays.asList(returnType.getBounds()));
    }

    @Test
    public void testEraseNonGenericType() throws Exception {
        MetaClass child = this.getMetaClass(Child.class);
        Assert.assertSame((Object)child, (Object)child.getErased());
    }

    @Test
    public void testEraseParameterizedTopLevelType() throws Exception {
        MetaClass parameterized = this.getMetaClass(ParameterizedClass.class);
        Assert.assertEquals((Object)"ParameterizedClass", (Object)parameterized.getName());
        Assert.assertEquals((Object)"org.jboss.errai.codegen.test.model.ParameterizedClass", (Object)parameterized.getFullyQualifiedName());
        Assert.assertNull((Object)parameterized.getParameterizedType());
        Assert.assertEquals((Object)"org.jboss.errai.codegen.test.model.ParameterizedClass", (Object)parameterized.getErased().getFullyQualifiedNameWithTypeParms());
    }

    @Test
    public void testMethodObjectReturnType() {
        MetaClass c = this.getMetaClass(ClassWithGenericMethods.class);
        MetaMethod method = c.getMethod("methodReturningObject", new Class[0]);
        Assert.assertEquals((Object)"java.lang.Object", (Object)method.getReturnType().getFullyQualifiedNameWithTypeParms());
        Assert.assertEquals(this.getTypeOfMetaClassBeingTested(), method.getReturnType().getClass());
        Assert.assertEquals((Object)this.getMetaClass(Object.class), (Object)method.getGenericReturnType());
    }

    @Test
    public void testMethodReturnTypeWithWildcardParameter() {
        MetaClass c = this.getMetaClass(ClassWithGenericMethods.class);
        MetaMethod method = c.getMethod("methodReturningUnboundedWildcardCollection", new Class[0]);
        Assert.assertTrue((boolean)method.getReturnType().getFullyQualifiedNameWithTypeParms().startsWith("java.util.Collection"));
        MetaType genericReturnType = method.getGenericReturnType();
        Assert.assertNotNull((Object)genericReturnType);
        Assert.assertTrue((String)("Got unexpected return type type " + genericReturnType.getClass()), (boolean)(genericReturnType instanceof MetaParameterizedType));
        MetaParameterizedType mpReturnType = (MetaParameterizedType)genericReturnType;
        Assert.assertEquals((long)1L, (long)mpReturnType.getTypeParameters().length);
        Assert.assertTrue((boolean)(mpReturnType.getTypeParameters()[0] instanceof MetaWildcardType));
        MetaWildcardType typeParam = (MetaWildcardType)mpReturnType.getTypeParameters()[0];
        Assert.assertArrayEquals((Object[])new MetaType[0], (Object[])typeParam.getLowerBounds());
        Assert.assertArrayEquals((Object[])new MetaType[]{this.getMetaClass(Object.class)}, (Object[])typeParam.getUpperBounds());
    }

    @Test
    public void testMethodReturnTypeWithUpperBoundedWildcardParameter() {
        MetaClass c = this.getMetaClass(ClassWithGenericMethods.class);
        MetaMethod method = c.getMethod("methodReturningUpperBoundedWildcardCollection", new Class[0]);
        Assert.assertTrue((boolean)method.getReturnType().getFullyQualifiedNameWithTypeParms().startsWith("java.util.Collection"));
        MetaType genericReturnType = method.getGenericReturnType();
        Assert.assertNotNull((Object)genericReturnType);
        Assert.assertTrue((String)("Got unexpected return type type " + genericReturnType.getClass()), (boolean)(genericReturnType instanceof MetaParameterizedType));
        MetaParameterizedType mpReturnType = (MetaParameterizedType)genericReturnType;
        Assert.assertEquals((long)1L, (long)mpReturnType.getTypeParameters().length);
        Assert.assertTrue((boolean)(mpReturnType.getTypeParameters()[0] instanceof MetaWildcardType));
        MetaWildcardType typeParam = (MetaWildcardType)mpReturnType.getTypeParameters()[0];
        Assert.assertArrayEquals((Object[])new MetaType[0], (Object[])typeParam.getLowerBounds());
        Assert.assertArrayEquals((Object[])new MetaType[]{this.getMetaClass(String.class)}, (Object[])typeParam.getUpperBounds());
    }

    @Test
    public void testMethodReturnTypeWithLowerBoundedWildcardParameter() {
        MetaClass c = this.getMetaClass(ClassWithGenericMethods.class);
        MetaMethod method = c.getMethod("methodReturningLowerBoundedWildcardCollection", new Class[0]);
        Assert.assertTrue((boolean)method.getReturnType().getFullyQualifiedNameWithTypeParms().startsWith("java.util.Collection"));
        MetaType genericReturnType = method.getGenericReturnType();
        Assert.assertNotNull((Object)genericReturnType);
        Assert.assertTrue((String)("Got unexpected return type type " + genericReturnType.getClass()), (boolean)(genericReturnType instanceof MetaParameterizedType));
        MetaParameterizedType mpReturnType = (MetaParameterizedType)genericReturnType;
        Assert.assertEquals((long)1L, (long)mpReturnType.getTypeParameters().length);
        Assert.assertTrue((boolean)(mpReturnType.getTypeParameters()[0] instanceof MetaWildcardType));
        MetaWildcardType typeParam = (MetaWildcardType)mpReturnType.getTypeParameters()[0];
        Assert.assertArrayEquals((Object[])new MetaType[]{this.getMetaClass(String.class)}, (Object[])typeParam.getLowerBounds());
        Assert.assertArrayEquals((Object[])new MetaType[]{this.getMetaClass(Object.class)}, (Object[])typeParam.getUpperBounds());
    }

    @Test
    public void testGetMethods() {
        MetaClass c = this.getMetaClass(Child.class);
        MetaMethod[] methods = c.getMethods();
        Assert.assertNotNull((Object)methods);
        ArrayList<String> methodSignatures = new ArrayList<String>();
        for (MetaMethod m : methods) {
            methodSignatures.add(GenUtil.getMethodString((MetaMethod)m));
        }
        ArrayList<String> expectedMethods = new ArrayList<String>();
        expectedMethods.add("protectedMethod([])");
        expectedMethods.add("interfaceMethodOverriddenMultipleTimes([])");
        expectedMethods.add("packagePrivateMethod([])");
        expectedMethods.add("finalize([])");
        expectedMethods.add("equals([java.lang.Object])");
        expectedMethods.add("toString([])");
        expectedMethods.add("notify([])");
        expectedMethods.add("wait([])");
        expectedMethods.add("clone([])");
        expectedMethods.add("notifyAll([])");
        expectedMethods.add("getClass([])");
        expectedMethods.add("wait([long])");
        expectedMethods.add("hashCode([])");
        expectedMethods.add("wait([long, int])");
        Collections.sort(expectedMethods);
        Collections.sort(methodSignatures);
        Assert.assertEquals((Object)((Object)expectedMethods).toString(), (Object)((Object)methodSignatures).toString());
    }

    @Test
    public void testGetFields() {
        LinkedList expectedFields = Lists.newLinkedList();
        expectedFields.add(Child.class.getCanonicalName() + "." + "childPublic");
        expectedFields.add(Parent.class.getCanonicalName() + "." + "parentPublic");
        ArrayList<String> actualFields = new ArrayList<String>();
        for (MetaField field : this.getMetaClass(Child.class).getFields()) {
            actualFields.add(field.getDeclaringClass().getCanonicalName() + "." + field.getName());
        }
        Collections.sort(expectedFields);
        Collections.sort(actualFields);
        Assert.assertEquals((Object)((Object)expectedFields).toString(), (Object)actualFields.toString());
    }

    @Test
    public void testGetDeclaredFields() {
        LinkedList expectedFields = Lists.newLinkedList();
        expectedFields.add(Child.class.getCanonicalName() + "." + "childPrivate");
        expectedFields.add(Child.class.getCanonicalName() + "." + "childPackage");
        expectedFields.add(Child.class.getCanonicalName() + "." + "childProtected");
        expectedFields.add(Child.class.getCanonicalName() + "." + "childPublic");
        ArrayList<String> actualFields = new ArrayList<String>();
        for (MetaField field : this.getMetaClass(Child.class).getDeclaredFields()) {
            actualFields.add(field.getDeclaringClass().getCanonicalName() + "." + field.getName());
        }
        Collections.sort(expectedFields);
        Collections.sort(actualFields);
        Assert.assertEquals((Object)((Object)expectedFields).toString(), (Object)actualFields.toString());
    }
}

