/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Set;
import org.jboss.errai.codegen.builder.ClassStructureBuilder;
import org.jboss.errai.codegen.builder.impl.ClassBuilder;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.junit.Test;

public class AnnotationTest
extends AbstractCodegenTest {
    @Test
    public void testSingleBoolean() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.BooleanAnnotation;\n@BooleanAnnotation(arrayValue = false, value = false)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructBooleanAnnotation(false));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiBoolean() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.BooleanAnnotation;\n@BooleanAnnotation(arrayValue = {true, false, true}, value = true)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructBooleanAnnotation(true, false, true));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleByte() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.ByteAnnotation;\n@ByteAnnotation(arrayValue = 1, value = 1)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructByteAnnotation(1));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiByte() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.ByteAnnotation;\n@ByteAnnotation(arrayValue = {1, 2, 3}, value = 1)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructByteAnnotation(1, 2, 3));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleChar() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.CharAnnotation;\n@CharAnnotation(arrayValue = 'a', value = 'a')\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructCharAnnotation('a'));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiChar() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.CharAnnotation;\n@CharAnnotation(arrayValue = {'a', 'b', 'c'}, value = 'a')\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructCharAnnotation('a', 'b', 'c'));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleShort() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.ShortAnnotation;\n@ShortAnnotation(arrayValue = 1, value = 1)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructShortAnnotation(1));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiShort() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.ShortAnnotation;\n@ShortAnnotation(arrayValue = {1, 2, 3}, value = 1)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructShortAnnotation(1, 2, 3));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleInt() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.IntAnnotation;\n@IntAnnotation(arrayValue = 1, value = 1)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructIntAnnotation(1));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiInt() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.IntAnnotation;\n@IntAnnotation(arrayValue = {1, 2, 3}, value = 1)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructIntAnnotation(1, 2, 3));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleLong() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.LongAnnotation;\n@LongAnnotation(arrayValue = 1L, value = 1L)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructLongAnnotation(1L));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiLong() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.LongAnnotation;\n@LongAnnotation(arrayValue = {1L, 2L, 3L}, value = 1L)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructLongAnnotation(1L, 2L, 3L));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleFloat() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.FloatAnnotation;\n@FloatAnnotation(arrayValue = 1.1f, value = 1.1f)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructFloatAnnotation(1.1f));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiFloat() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.FloatAnnotation;\n@FloatAnnotation(arrayValue = {1.1f, 2.22f, 3.333f}, value = 1.1f)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructFloatAnnotation(1.1f, 2.22f, 3.333f));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleDouble() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.DoubleAnnotation;\n@DoubleAnnotation(arrayValue = 1.1d, value = 1.1d)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructDoubleAnnotation(1.1));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiDouble() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.DoubleAnnotation;\n@DoubleAnnotation(arrayValue = {1.1d, 2.22d, 3.333d}, value = 1.1d)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructDoubleAnnotation(1.1, 2.22, 3.333));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleString() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.StringAnnotation;\n@StringAnnotation(arrayValue = \"Hello World\", value = \"Hello World\")\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructStringAnnotation("Hello World"));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiString() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.StringAnnotation;\n@StringAnnotation(arrayValue = {\"Hang\", \"to\", \"your\", \"helmet\"}, value = \"Hang\")\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructStringAnnotation("Hang", "to", "your", "helmet"));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleClass() {
        String expected = "import java.util.Set;\nimport org.jboss.errai.codegen.test.AnnotationTest.ClassAnnotation;\n@ClassAnnotation(arrayValue = Set.class, value = Set.class)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructClassAnnotation(Set.class));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiClass() {
        String expected = "import java.util.List;\nimport java.util.Set;\nimport org.jboss.errai.codegen.test.AnnotationTest.ClassAnnotation;\n@ClassAnnotation(arrayValue = {Set.class, List.class}, value = Set.class)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructClassAnnotation(Set.class, List.class));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleEnum() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.EnumAnnotation;\nimport org.jboss.errai.codegen.test.AnnotationTest.SimpleEnum;\n@EnumAnnotation(arrayValue = SimpleEnum.YES, value = SimpleEnum.YES)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructEnumAnnotation(SimpleEnum.YES));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiEnum() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.EnumAnnotation;\nimport org.jboss.errai.codegen.test.AnnotationTest.SimpleEnum;\n@EnumAnnotation(arrayValue = {SimpleEnum.YES, SimpleEnum.NO, SimpleEnum.YES}, value = SimpleEnum.YES)\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructEnumAnnotation(SimpleEnum.YES, SimpleEnum.NO, SimpleEnum.YES));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testSingleAnnotation() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.AnnotationAnnotation;\nimport org.jboss.errai.codegen.test.AnnotationTest.BooleanAnnotation;\n@AnnotationAnnotation(arrayValue = \n               @BooleanAnnotation(arrayValue = {true, false}, value = true),\n       value = @BooleanAnnotation(arrayValue = {true, false}, value = true))\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructAnnotationAnnotation(AnnotationTest.constructBooleanAnnotation(true, false)));
        AnnotationTest.assertEquals(expected, cls);
    }

    @Test
    public void testMultiAnnotation() {
        String expected = "import org.jboss.errai.codegen.test.AnnotationTest.AnnotationAnnotation;\nimport org.jboss.errai.codegen.test.AnnotationTest.BooleanAnnotation;\n@AnnotationAnnotation(arrayValue = {\n               @BooleanAnnotation(arrayValue = { true, false }, value = true),\n               @BooleanAnnotation(arrayValue = { true, true}, value = true)},\n       value = @BooleanAnnotation(arrayValue = {true, false}, value = true))\npublic class FooBar {}";
        String cls = AnnotationTest.constructTypeWithAnnotation(AnnotationTest.constructAnnotationAnnotation(AnnotationTest.constructBooleanAnnotation(true, false), AnnotationTest.constructBooleanAnnotation(true, true)));
        AnnotationTest.assertEquals(expected, cls);
    }

    private static String constructTypeWithAnnotation(Annotation ... annotations) {
        ClassStructureBuilder builder = ClassBuilder.define((String)"FooBar").publicScope().body();
        for (Annotation annotation : annotations) {
            builder.getClassDefinition().addAnnotation(annotation);
        }
        return builder.toJavaString();
    }

    private static BooleanAnnotation constructBooleanAnnotation(final boolean ... values) {
        return new BooleanAnnotation(){

            @Override
            public boolean value() {
                return values[0];
            }

            @Override
            public boolean[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return BooleanAnnotation.class;
            }
        };
    }

    private static ByteAnnotation constructByteAnnotation(final byte ... values) {
        return new ByteAnnotation(){

            @Override
            public byte value() {
                return values[0];
            }

            @Override
            public byte[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return ByteAnnotation.class;
            }
        };
    }

    private static CharAnnotation constructCharAnnotation(final char ... values) {
        return new CharAnnotation(){

            @Override
            public char value() {
                return values[0];
            }

            @Override
            public char[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return CharAnnotation.class;
            }
        };
    }

    private static ShortAnnotation constructShortAnnotation(final short ... values) {
        return new ShortAnnotation(){

            @Override
            public short value() {
                return values[0];
            }

            @Override
            public short[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return ShortAnnotation.class;
            }
        };
    }

    private static IntAnnotation constructIntAnnotation(final int ... values) {
        return new IntAnnotation(){

            @Override
            public int value() {
                return values[0];
            }

            @Override
            public int[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return IntAnnotation.class;
            }
        };
    }

    private static LongAnnotation constructLongAnnotation(final long ... values) {
        return new LongAnnotation(){

            @Override
            public long value() {
                return values[0];
            }

            @Override
            public long[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return LongAnnotation.class;
            }
        };
    }

    private static FloatAnnotation constructFloatAnnotation(final float ... values) {
        return new FloatAnnotation(){

            @Override
            public float value() {
                return values[0];
            }

            @Override
            public float[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return FloatAnnotation.class;
            }
        };
    }

    private static DoubleAnnotation constructDoubleAnnotation(final double ... values) {
        return new DoubleAnnotation(){

            @Override
            public double value() {
                return values[0];
            }

            @Override
            public double[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return DoubleAnnotation.class;
            }
        };
    }

    private static StringAnnotation constructStringAnnotation(final String ... values) {
        return new StringAnnotation(){

            @Override
            public String value() {
                return values[0];
            }

            @Override
            public String[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return StringAnnotation.class;
            }
        };
    }

    private static ClassAnnotation constructClassAnnotation(final Class<?> ... values) {
        return new ClassAnnotation(){

            @Override
            public Class<?> value() {
                return values[0];
            }

            @Override
            public Class<?>[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return ClassAnnotation.class;
            }
        };
    }

    private static EnumAnnotation constructEnumAnnotation(final SimpleEnum ... values) {
        return new EnumAnnotation(){

            @Override
            public SimpleEnum value() {
                return values[0];
            }

            @Override
            public SimpleEnum[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return EnumAnnotation.class;
            }
        };
    }

    private static AnnotationAnnotation constructAnnotationAnnotation(final BooleanAnnotation ... values) {
        return new AnnotationAnnotation(){

            @Override
            public BooleanAnnotation value() {
                return values[0];
            }

            @Override
            public BooleanAnnotation[] arrayValue() {
                return values;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return AnnotationAnnotation.class;
            }
        };
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface AnnotationAnnotation {
        public BooleanAnnotation value();

        public BooleanAnnotation[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface EnumAnnotation {
        public SimpleEnum value();

        public SimpleEnum[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface ClassAnnotation {
        public Class<?> value();

        public Class<?>[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface StringAnnotation {
        public String value();

        public String[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface DoubleAnnotation {
        public double value();

        public double[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface FloatAnnotation {
        public float value();

        public float[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface LongAnnotation {
        public long value();

        public long[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface IntAnnotation {
        public int value();

        public int[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface ShortAnnotation {
        public short value();

        public short[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface CharAnnotation {
        public char value();

        public char[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface ByteAnnotation {
        public byte value();

        public byte[] arrayValue();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface BooleanAnnotation {
        public boolean value();

        public boolean[] arrayValue();
    }

    private static enum SimpleEnum {
        YES,
        NO;

    }
}

