/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.Parameter;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.Variable;
import org.jboss.errai.codegen.builder.AnonymousClassStructureBuilder;
import org.jboss.errai.codegen.builder.ClassStructureBuilder;
import org.jboss.errai.codegen.builder.impl.ClassBuilder;
import org.jboss.errai.codegen.builder.impl.ObjectBuilder;
import org.jboss.errai.codegen.meta.MetaClass;
import org.jboss.errai.codegen.meta.MetaClassFactory;
import org.jboss.errai.codegen.meta.MetaParameterizedType;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.test.model.Bar;
import org.jboss.errai.codegen.test.model.Mrshlr;
import org.jboss.errai.codegen.util.Stmt;
import org.junit.Test;

public class AnonymousClassStructureBuilderTest
extends AbstractCodegenTest {
    @Test
    public void testAnonymousAnnotation() {
        String src = ((ObjectBuilder)((AnonymousClassStructureBuilder)ObjectBuilder.newInstanceOf(Retention.class).extend().publicOverridesMethod("annotationType", new Parameter[0]).append(Stmt.load(Retention.class).returnValue()).finish()).finish()).toJavaString();
        AnonymousClassStructureBuilderTest.assertEquals("failed to generate anonymous annotation with overloaded method", "new java.lang.annotation.Retention() {\npublic Class annotationType() {\nreturn java.lang.annotation.Retention.class;\n}\n}", src);
    }

    @Test
    public void testAnonymousClass() {
        String src = ((ObjectBuilder)((AnonymousClassStructureBuilder)ObjectBuilder.newInstanceOf(Bar.class, (Context)Context.create().autoImport()).extend().publicOverridesMethod("setName", new Parameter[]{Parameter.of(String.class, (String)"name")}).append((Statement)Stmt.loadClassMember((String)"name", (Object[])new Object[0]).assignValue((Object)Variable.get((String)"name"))).finish()).finish()).toJavaString();
        AnonymousClassStructureBuilderTest.assertEquals("failed to generate anonymous class with overloaded construct", "new Bar() {\npublic void setName(String name) {\nthis.name = name;\n}\n}", src);
    }

    @Test
    public void testAnonymousClassWithConstructor() {
        String src = ((ObjectBuilder)((AnonymousClassStructureBuilder)ObjectBuilder.newInstanceOf(Bar.class, (Context)Context.create().autoImport()).extend(new Object[]{"test"}).publicOverridesMethod("setName", new Parameter[]{Parameter.of(String.class, (String)"name")}).append((Statement)Stmt.loadClassMember((String)"name", (Object[])new Object[0]).assignValue((Object)Variable.get((String)"name"))).finish()).finish()).toJavaString();
        AnonymousClassStructureBuilderTest.assertEquals("failed to generate anonymous class with overloaded construct", "new Bar(\"test\") {\npublic void setName(String name) {\nthis.name = name;\n}\n}", src);
    }

    @Test
    public void testAnonymousClassWithInitializationBlock() {
        String src = ((ObjectBuilder)((AnonymousClassStructureBuilder)((AnonymousClassStructureBuilder)ObjectBuilder.newInstanceOf(Bar.class, (Context)Context.create().autoImport()).extend().initialize().append((Statement)Stmt.loadClassMember((String)"name", (Object[])new Object[0]).assignValue((Object)"init")).finish()).publicOverridesMethod("setName", new Parameter[]{Parameter.of(String.class, (String)"name")}).append((Statement)Stmt.loadClassMember((String)"name", (Object[])new Object[0]).assignValue((Object)Variable.get((String)"name"))).finish()).finish()).toJavaString();
        AnonymousClassStructureBuilderTest.assertEquals("failed to generate anonymous class with overloaded construct", "new Bar() {\n{\nname = \"init\";\n}\npublic void setName(String name) {\nthis.name = name;\n}\n}", src);
    }

    @Test
    public void testAnonymousClassReferencingOuterClass() {
        ClassStructureBuilder outer = ClassBuilder.define((String)"org.foo.Outer").publicScope().body();
        Statement anonInner = (Statement)((AnonymousClassStructureBuilder)ObjectBuilder.newInstanceOf(Bar.class, (Context)Context.create().autoImport()).extend().publicOverridesMethod("setName", new Parameter[]{Parameter.of(String.class, (String)"name")}).append((Statement)Stmt.loadStatic((MetaClass)outer.getClassDefinition(), (String)"this").loadField("outerName").assignValue((Object)Variable.get((String)"name"))).append((Statement)Stmt.loadStatic((MetaClass)outer.getClassDefinition(), (String)"this").invoke("setOuterName", new Object[]{Variable.get((String)"name")})).finish()).finish();
        String cls = ((ClassStructureBuilder)((ClassStructureBuilder)((ClassStructureBuilder)outer.publicField("outerName", String.class).finish()).publicMethod(Void.TYPE, "setOuterName", new Parameter[]{Parameter.of(String.class, (String)"outerName")}).append((Statement)Stmt.loadClassMember((String)"outerName", (Object[])new Object[0]).assignValue((Object)Variable.get((String)"outerName"))).finish()).publicMethod(Void.TYPE, "test").append(anonInner).finish()).toJavaString();
        AnonymousClassStructureBuilderTest.assertEquals("failed to generate anonymous class accessing outer class", "package org.foo;\nimport org.jboss.errai.codegen.test.model.Bar;\npublic class Outer {\npublic String outerName;\npublic void setOuterName(String outerName) {\nthis.outerName = outerName;\n}\npublic void test() {\nnew Bar() {\npublic void setName(String name) {\nOuter.this.outerName = name;\nOuter.this.setOuterName(name);\n}\n};\n}\n}\n", cls);
    }

    @Test
    public void testAssignmentOfAnonymousClass() {
        Statement stmt = (Statement)((AnonymousClassStructureBuilder)ObjectBuilder.newInstanceOf(Retention.class).extend().publicOverridesMethod("annotationType", new Parameter[0]).append(Stmt.load(Retention.class).returnValue()).finish()).finish();
        Statement declaration = (Statement)Stmt.declareVariable(Annotation.class).named("foo").initializeWith(stmt);
        String cls = declaration.generate(Context.create());
        AnonymousClassStructureBuilderTest.assertEquals("java.lang.annotation.Annotation foo = new java.lang.annotation.Retention() {\n  public Class annotationType() {\n    return java.lang.annotation.Retention.class;\n  }\n\n\n};", cls);
    }

    @Test
    public void testReferenceToAnonymousClassMember() throws Exception {
        ClassStructureBuilder builder = ClassBuilder.define((String)"com.foo.A").publicScope().body();
        builder.privateMethod(Void.TYPE, "method").append((Statement)((AnonymousClassStructureBuilder)((AnonymousClassStructureBuilder)ObjectBuilder.newInstanceOf(Runnable.class).extend().privateField("memberOfRunnable", Object.class).finish()).publicOverridesMethod("run", new Parameter[0]).append((Statement)Stmt.loadVariable((String)"memberOfRunnable", (Object[])new Object[0]).invoke("hashCode", new Object[0])).finish()).finish()).finish();
        String javaString = builder.toJavaString();
        AnonymousClassStructureBuilderTest.assertEquals("package com.foo; public class A { private void method() { new Runnable() { private Object memberOfRunnable; public void run() { memberOfRunnable.hashCode(); } }; } }", javaString);
    }

    @Test
    public void testParameterizedImplementation() throws Exception {
        MetaClass mrshlrClass = MetaClassFactory.parameterizedAs(Mrshlr.class, (MetaParameterizedType)MetaClassFactory.typeParametersOf((Class[])new Class[]{Bar.class}));
        ObjectBuilder builder = (ObjectBuilder)((AnonymousClassStructureBuilder)Stmt.newObject((MetaClass)mrshlrClass).extend().publicOverridesMethod("get", new Parameter[0]).finish()).finish();
        String javaString = builder.toJavaString();
        AnonymousClassStructureBuilderTest.assertEquals("new org.jboss.errai.codegen.test.model.Mrshlr<org.jboss.errai.codegen.test.model.Bar>() {\n  public Class<org.jboss.errai.codegen.test.model.Bar> get() {\n\n  }\n}", javaString);
    }
}

