/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import org.jboss.errai.codegen.ArithmeticOperator;
import org.jboss.errai.codegen.BooleanOperator;
import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.Variable;
import org.jboss.errai.codegen.builder.ElseBlockBuilder;
import org.jboss.errai.codegen.builder.StatementEnd;
import org.jboss.errai.codegen.builder.impl.ContextBuilder;
import org.jboss.errai.codegen.builder.impl.StatementBuilder;
import org.jboss.errai.codegen.exception.InvalidExpressionException;
import org.jboss.errai.codegen.exception.InvalidTypeException;
import org.jboss.errai.codegen.meta.MetaClassFactory;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.test.IfBlockBuilderTestResult;
import org.jboss.errai.codegen.util.Arith;
import org.jboss.errai.codegen.util.Bool;
import org.jboss.errai.codegen.util.Refs;
import org.jboss.errai.codegen.util.Stmt;
import org.junit.Assert;
import org.junit.Test;

public class IfBlockBuilderTest
extends AbstractCodegenTest
implements IfBlockBuilderTestResult {
    @Test
    public void testEmptyIfBlockUsingNoRhs() {
        String s = ((ElseBlockBuilder)StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).invoke("endsWith", new Object[]{"abc"}).if_().finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate empty if block using no rhs", "if (str.endsWith(\"abc\")) { }\n", s);
    }

    @Test
    public void testEmptyIfBlockUsingNoRhsAndNegation() {
        String s = ((ElseBlockBuilder)StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).invoke("endsWith", new Object[]{"abc"}).ifNot().finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate empty if block using no rhs", "if (!(str.endsWith(\"abc\"))) { }\n", s);
    }

    @Test
    public void testEmptyIfBlockUsingLiteralRhs() {
        String s = ((ElseBlockBuilder)StatementBuilder.create().declareVariable("n", Integer.TYPE).loadVariable("n", new Object[0]).if_(BooleanOperator.Equals, (Object)1).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate empty if block using a literal rhs", "if (n == 1) { }\n", s);
    }

    @Test
    public void testIfElseBlockUsingNoRhs() {
        String s = ((StatementEnd)((ElseBlockBuilder)StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).invoke("endsWith", new Object[]{"abc"}).if_()._((Statement)Stmt.declareVariable(Integer.class).named("n").initializeWith((Object)0)).finish()).else_()._((Statement)Stmt.declareVariable(Integer.class).named("n").initializeWith((Object)1)).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate empty if block using no rhs", "   if (str.endsWith(\"abc\")) {  Integer n = 0;\n} else { \nInteger n = 1;\n}\n", s);
    }

    @Test
    public void testIfElseBlockUsingRhs() {
        String s = ((StatementEnd)((ElseBlockBuilder)StatementBuilder.create().declareVariable("n", Integer.class).declareVariable("m", Integer.class).loadVariable("n", new Object[0]).if_(BooleanOperator.GreaterThan, (Statement)Variable.get((String)"m"))._((Statement)Stmt.declareVariable(Integer.class).named("n").initializeWith((Object)0)).finish()).else_()._((Statement)Stmt.declareVariable(Integer.class).named("n").initializeWith((Object)1)).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate empty if block using a rhs", "   if (n > m) {  Integer n = 0;\n} else { \nInteger n = 1;\n}\n", s);
    }

    @Test
    public void testNestedIfElseIfBlockUsingNoRhs() {
        Context c = ContextBuilder.create().addVariable("s", String.class).addVariable("n", Integer.class).getContext();
        String s = ((StatementEnd)((ElseBlockBuilder)StatementBuilder.create((Context)c).loadVariable("s", new Object[0]).invoke("endsWith", new Object[]{"abc"}).if_()._((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)0)).finish()).else_()._((Statement)StatementBuilder.create((Context)c).loadVariable("s", new Object[0]).invoke("startsWith", new Object[]{"def"}).if_()._((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)1)).finish()).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate if-else-if-block using no rhs", "   if (s.endsWith(\"abc\")) {\n n = 0;\n} else {\n if (s.startsWith(\"def\")) {    n = 1;\n }\n}\n", s);
    }

    @Test
    public void testNestedIfElseIfElseBlockUsingNoRhs() {
        Context c = ContextBuilder.create().addVariable("s", String.class).addVariable("n", Integer.class).getContext();
        String s = ((StatementEnd)((ElseBlockBuilder)StatementBuilder.create((Context)c).loadVariable("s", new Object[0]).invoke("endsWith", new Object[]{"abc"}).if_().append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)0)).finish()).else_().append((Statement)((ElseBlockBuilder)StatementBuilder.create((Context)c).loadVariable("s", new Object[0]).invoke("startsWith", new Object[]{"def"}).if_().append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)1)).finish()).else_().append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)2)).finish()).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate if-else-if-else block using no rhs", "   if (s.endsWith(\"abc\")) {\n n = 0;\n} else {\n if (s.startsWith(\"def\")) {    n = 1;\n } else {    n = 2;\n }\n}\n", s);
    }

    @Test
    public void testNestedIfElseIfBlockUsingRhs() {
        Context c = ContextBuilder.create().addVariable("n", Integer.class).addVariable("m", Integer.class).getContext();
        String s = ((StatementEnd)((ElseBlockBuilder)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).if_(BooleanOperator.GreaterThan, (Statement)Variable.get((String)"m")).append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)0)).finish()).else_().append((Statement)((ElseBlockBuilder)StatementBuilder.create((Context)c).loadVariable("m", new Object[0]).if_(BooleanOperator.GreaterThan, (Statement)Variable.get((String)"n")).append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)1)).finish()).else_().append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)2)).finish()).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate if-else-if-else block using rhs", "   if (n > m) {\n n = 0;\n} else {\n if (m > n) {    n = 1;\n } else {    n = 2;\n }\n}\n", s);
    }

    @Test
    public void testIfElseIfBlockUsingNoRhsAndElseifKeyword() {
        Context c = ContextBuilder.create().addVariable("s", String.class).addVariable("n", Integer.class).getContext();
        String s = ((ElseBlockBuilder)((ElseBlockBuilder)StatementBuilder.create((Context)c).loadVariable("s", new Object[0]).invoke("endsWith", new Object[]{"abc"}).if_().append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)0)).finish()).elseif_((Statement)StatementBuilder.create((Context)c).loadVariable("s", new Object[0]).invoke("startsWith", new Object[]{"def"})).append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)1)).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate if-elseif block using no rhs", "   if (s.endsWith(\"abc\")) {\n n = 0;\n} else if (s.startsWith(\"def\")) {  n = 1;\n}\n", s);
    }

    @Test
    public void testIfElseIfElseBlockUsingNoRhsAndElseifKeyword() {
        Context c = ContextBuilder.create().addVariable("s", String.class).addVariable("n", Integer.class).getContext();
        String s = ((StatementEnd)((ElseBlockBuilder)((ElseBlockBuilder)StatementBuilder.create((Context)c).loadVariable("s", new Object[0]).invoke("endsWith", new Object[]{"abc"}).if_().append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)0)).finish()).elseif_((Statement)StatementBuilder.create((Context)c).loadVariable("s", new Object[0]).invoke("startsWith", new Object[]{"def"})).append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)1)).finish()).else_().append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)2)).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate if - elseif - else block using no rhs", "   if (s.endsWith(\"abc\")) {\n n = 0;\n} else if (s.startsWith(\"def\")) {  n = 1;\n} else {  n = 2;\n}\n", s);
    }

    @Test
    public void testIfElseIfBlockUsingRhsAndElseifKeyword() {
        Context c = ContextBuilder.create().addVariable("n", Integer.class).addVariable("m", Integer.class).getContext();
        String s = ((StatementEnd)((ElseBlockBuilder)((ElseBlockBuilder)((ElseBlockBuilder)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).if_(BooleanOperator.GreaterThan, (Statement)Variable.get((String)"m")).append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)0)).finish()).elseif_((Statement)StatementBuilder.create((Context)c).loadVariable("m", new Object[0]), BooleanOperator.GreaterThan, (Statement)Variable.get((String)"n")).append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)1)).finish()).elseif_((Statement)StatementBuilder.create((Context)c).loadVariable("m", new Object[0]), BooleanOperator.Equals, (Statement)Variable.get((String)"n")).append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)2)).finish()).else_().append((Statement)StatementBuilder.create((Context)c).loadVariable("n", new Object[0]).assignValue((Object)3)).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate if - else if - else block using rhs", "   if (n > m) {\n n = 0;\n} else if (m > n) {  n = 1;\n} else if (m == n) {  n = 2;\n} else {  n = 3;\n}\n", s);
    }

    @Test
    public void testIfBlockWithInvalidNonBooleanExpression() {
        try {
            ((ElseBlockBuilder)StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).invoke("compareTo", new Object[]{"asd"}).if_().finish()).toJavaString();
            Assert.fail((String)"Expected InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
        try {
            ((ElseBlockBuilder)StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).ifNot().finish()).toJavaString();
            Assert.fail((String)"Expected InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testIfBlockWithInvalidExpression() {
        try {
            ((ElseBlockBuilder)StatementBuilder.create().declareVariable("str", String.class).declareVariable("str2", String.class).loadVariable("str", new Object[0]).if_(BooleanOperator.GreaterThan, (Statement)Variable.get((String)"str2")).finish()).toJavaString();
            Assert.fail((String)"Expected InvalidExpressionException");
        }
        catch (InvalidExpressionException e) {
            Assert.assertTrue((String)"Wrong exception thrown", (boolean)e.getMessage().contains(String.class.getName()));
        }
    }

    @Test
    public void testIfBlockWithInstanceOfExpression() {
        String s = ((ElseBlockBuilder)StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).if_(BooleanOperator.InstanceOf, MetaClassFactory.getAsStatement(String.class)).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate empty if block using an instance of expression", "if (str instanceof String) { }\n", s);
    }

    @Test
    public void testIfBlockWithNullCheck() {
        String s = ((ElseBlockBuilder)StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).if_(BooleanOperator.NotEquals, null).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate if block using a null rhs", "if (str != null) { }\n", s);
    }

    @Test
    public void testIfBlockUnchainedWithNestedExpressions() {
        Context ctx = Context.create().addVariable("a", Boolean.TYPE).addVariable("b", Boolean.TYPE);
        String s = ((ElseBlockBuilder)((ElseBlockBuilder)Stmt.create((Context)ctx).if_(Bool.expr((Object)Bool.expr((Object)"foo", (BooleanOperator)BooleanOperator.Equals, (Object)"bar"), (BooleanOperator)BooleanOperator.Or, (Object)Bool.expr((Object)Bool.expr((Object)"cat", (BooleanOperator)BooleanOperator.Equals, (Object)"dog"), (BooleanOperator)BooleanOperator.And, (Object)Bool.expr((Object)"girl", (BooleanOperator)BooleanOperator.NotEquals, (Object)"boy")))).finish()).elseif_((Statement)Bool.expr((Object)Stmt.loadVariable((String)"a", (Object[])new Object[0]), (BooleanOperator)BooleanOperator.And, (Object)Stmt.loadVariable((String)"b", (Object[])new Object[0]))).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{Refs.get((String)"a")})).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate if block using nested boolean expressions", "   if ((\"foo\" == \"bar\") || ((\"cat\" == \"dog\") && (\"girl\" != \"boy\"))) {  } else if (a && b) { System.out.println(a); } ", s);
    }

    @Test
    public void testIfBlockUnchainedWithExpressionUsingNegation() {
        Context ctx = Context.create().addVariable("a", Boolean.TYPE).addVariable("b", Boolean.TYPE);
        String s = ((ElseBlockBuilder)Stmt.create((Context)ctx).if_(Bool.expr((Object)Stmt.loadVariable((String)"a", (Object[])new Object[0]), (BooleanOperator)BooleanOperator.And, (Object)Bool.expr((Statement)Stmt.loadVariable((String)"b", (Object[])new Object[0])).negate())).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{Refs.get((String)"a")})).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate if block using nested boolean expressions", "   if (a && (!(b))) { System.out.println(a); } ", s);
    }

    @Test
    public void testIfBlockUnchainedWithExpressionUsingArithmetics() {
        Context ctx = Context.create().addVariable("a", Integer.class).addVariable("b", Integer.class).addVariable("c", Float.class);
        String s = ((ElseBlockBuilder)Stmt.create((Context)ctx).if_(Bool.expr((Object)Arith.expr((Object)Arith.expr((Object)Stmt.loadVariable((String)"a", (Object[])new Object[0]), (ArithmeticOperator)ArithmeticOperator.Addition, (Object)Stmt.loadVariable((String)"b", (Object[])new Object[0])), (ArithmeticOperator)ArithmeticOperator.Division, (Object)Stmt.loadVariable((String)"c", (Object[])new Object[0])), (BooleanOperator)BooleanOperator.GreaterThan, (Object)1)).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{Refs.get((String)"a")})).finish()).toJavaString();
        IfBlockBuilderTest.assertEquals("Failed to generate if block using arithmetic expressions", "   if (((a + b) / c) > 1) { System.out.println(a); } ", s);
    }
}

