/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.util.TypeLiteral;
import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.Variable;
import org.jboss.errai.codegen.builder.impl.ContextBuilder;
import org.jboss.errai.codegen.builder.impl.StatementBuilder;
import org.jboss.errai.codegen.exception.InvalidTypeException;
import org.jboss.errai.codegen.exception.OutOfScopeException;
import org.jboss.errai.codegen.exception.UndefinedMethodException;
import org.jboss.errai.codegen.meta.MetaClass;
import org.jboss.errai.codegen.meta.MetaClassFactory;
import org.jboss.errai.codegen.meta.MetaMethod;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.test.model.Foo;
import org.jboss.errai.codegen.util.Refs;
import org.junit.Assert;
import org.junit.Test;

public class InvocationBuilderTest
extends AbstractCodegenTest {
    @Test
    public void testSingleInvocation() {
        String s = StatementBuilder.create().declareVariable("obj", Object.class).loadVariable("obj", new Object[0]).invoke("toString", new Object[0]).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate invocation on variable", "obj.toString()", s);
    }

    @Test
    public void testChainedInvocations() {
        String s = StatementBuilder.create().declareVariable("i", Integer.class).declareVariable("regex", String.class).declareVariable("replacement", String.class).loadVariable("i", new Object[0]).invoke("toString", new Object[0]).invoke("replaceAll", new Object[]{Variable.get((String)"regex"), Variable.get((String)"replacement")}).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate chained invocations on variable", "i.toString().replaceAll(regex, replacement)", s);
    }

    @Test
    public void testInvokeWithLiteralParameters() {
        String result = StatementBuilder.create().declareVariable("s", String.class).loadVariable("s", new Object[0]).invoke("replaceAll", new Object[]{"foo", "foo\t\n"}).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate invocation using literal parameters", "s.replaceAll(\"foo\", \"foo\\t\\n\")", result);
    }

    @Test
    public void testInvokeOnLiteral() {
        String result = StatementBuilder.create().loadLiteral((Object)"foo").invoke("toString", new Object[0]).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate invocation using literal parameters", "\"foo\".toString()", result);
    }

    @Test
    public void testInvokeBestMatchingMethod() {
        String s = StatementBuilder.create().declareVariable("n", Integer.class).loadVariable("n", new Object[0]).invoke("equals", new Object[]{1}).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate invocation on matched method", "n.equals(1)", s);
    }

    @Test
    public void testInvokeUndefinedMethodOnVariable() {
        try {
            StatementBuilder.create().declareVariable("obj", Object.class).declareVariable("param", String.class).loadVariable("obj", new Object[0]).invoke("undefinedMethod", new Object[]{Variable.get((String)"param")}).toJavaString();
            Assert.fail((String)"expected UndefinedMethodException");
        }
        catch (UndefinedMethodException udme) {
            InvocationBuilderTest.assertEquals("Wrong exception thrown", udme.getMethodName(), "undefinedMethod");
        }
    }

    @Test
    public void testInvokeChainedUndefinedMethod() {
        try {
            StatementBuilder.create().declareVariable("s", String.class).declareVariable("regex", String.class).declareVariable("replacement", String.class).loadVariable("s", new Object[0]).invoke("replaceAll", new Object[]{Variable.get((String)"regex"), Variable.get((String)"replacement")}).invoke("undefinedMethod", new Object[]{Variable.get((String)"regex"), Variable.get((String)"replacement")}).toJavaString();
            Assert.fail((String)"expected UndefinedMethodException");
        }
        catch (UndefinedMethodException udme) {
            InvocationBuilderTest.assertEquals("Wrong exception thrown", udme.getMethodName(), "undefinedMethod");
        }
    }

    @Test
    public void testInvokeOnUndefinedVariable() {
        try {
            StatementBuilder.create().loadVariable("injector", new Object[0]).invoke("provide", new Object[]{Refs.get((String)"param"), Refs.get((String)"param2")}).toJavaString();
            Assert.fail((String)"expected OutOfScopeException");
        }
        catch (OutOfScopeException oose) {
            Assert.assertTrue((String)"Wrong exception thrown", (boolean)oose.getMessage().contains("injector"));
        }
    }

    @Test
    public void testInvokeWithUndefinedVariable() {
        try {
            StatementBuilder.create().declareVariable("obj", Object.class).declareVariable("param", String.class).loadVariable("obj", new Object[0]).invoke("undefinedMethod", new Object[]{Variable.get((String)"param"), Variable.get((String)"param2")}).toJavaString();
            Assert.fail((String)"expected OutOfScopeException");
        }
        catch (OutOfScopeException oose) {
            Assert.assertTrue((boolean)oose.getMessage().contains("param2"));
        }
    }

    @Test
    public void testInvokeUsingStandardizedLoadVariableReference() {
        Context context = ContextBuilder.create().addVariable("s", String.class).getContext();
        String s = StatementBuilder.create((Context)context).load((Object)Variable.get((String)"s")).invoke("toUpperCase", new Object[0]).toJavaString();
        InvocationBuilderTest.assertEquals("Failed using load() passing a variable reference", "s.toUpperCase()", s);
    }

    @Test
    public void testInvokeUsingStandardizedLoadVariableInstance() {
        Context context = ContextBuilder.create().addVariable("s", String.class).getContext();
        Variable v = Variable.create((String)"s", String.class);
        String s = StatementBuilder.create((Context)context).load((Object)v).invoke("toUpperCase", new Object[0]).toJavaString();
        InvocationBuilderTest.assertEquals("Failed using load() passing a variable instance", "s.toUpperCase()", s);
    }

    @Test
    public void testInvokeUsingStandardizedLoadLiteral() {
        String s = StatementBuilder.create().load((Object)"foo").invoke("toUpperCase", new Object[0]).toJavaString();
        InvocationBuilderTest.assertEquals("Failed injecting literal with load()", "\"foo\".toUpperCase()", s);
    }

    @Test
    public void testInvokeWithParameterTypeConversionOfIntegerToString() {
        String s = StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).invoke("endsWith", new Object[]{123}).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate invocation with parameter type conversion", "str.endsWith(\"123\")", s);
    }

    @Test
    public void testInvokeWithParameterTypeConversionOfStringToInteger() {
        String s = StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).invoke("substring", new Object[]{"1", "3"}).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate invocation with parameter type conversion", "str.substring(1, 3)", s);
    }

    @Test
    public void testInvokeWithParameterTypeConversionOfVariable() {
        Context c = Context.create().addVariable("n", Integer.class, (Object)123);
        String s = StatementBuilder.create((Context)c).declareVariable("str", String.class).loadVariable("str", new Object[0]).invoke("endsWith", new Object[]{c.getVariable("n").getValue()}).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate invocation with parameter type conversion of variable", "str.endsWith(\"123\")", s);
    }

    @Test
    public void testInvokeStaticMethod() {
        String s = StatementBuilder.create().invokeStatic(Integer.class, "getInteger", new Object[]{"123"}).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate static method invocation", "Integer.getInteger(\"123\")", s);
    }

    @Test
    public void testInvokeUndefinedStaticMethod() {
        try {
            StatementBuilder.create().invokeStatic(Integer.class, "intValue", new Object[0]).toJavaString();
            Assert.fail((String)"expected UndefinedMethodException");
        }
        catch (UndefinedMethodException udme) {
            InvocationBuilderTest.assertEquals("Wrong exception details", udme.getMethodName(), "intValue");
        }
    }

    @Test
    public void testInvokeWithVariableReturnType() {
        String s = StatementBuilder.create((Context)Context.create().autoImport()).declareVariable("s", String.class).declareVariable("str", String.class, (Object)StatementBuilder.create().invokeStatic(Foo.class, "foo", new Object[]{Variable.get((String)"s")})).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate method invocation using variable return type", "String str = Foo.foo(s);", s);
    }

    @Test
    public void testInvokeWithInvalidVariableReturnType() {
        try {
            StatementBuilder.create((Context)Context.create().autoImport()).declareVariable("list", (TypeLiteral)new TypeLiteral<List<String>>(){}).declareVariable("n", Integer.class, (Object)StatementBuilder.create().invokeStatic(Foo.class, "bar", new Object[]{Variable.get((String)"list")})).toJavaString();
            Assert.fail((String)"expected InvalidTypeException");
        }
        catch (InvalidTypeException e) {
            InvocationBuilderTest.assertEquals("Wrong exception message", "java.lang.Integer is not assignable from java.lang.String", e.getMessage());
        }
    }

    @Test
    public void testInvokeWithParameterizedListAndVariableReturnType() {
        String s = StatementBuilder.create((Context)Context.create().autoImport()).declareVariable("list", (TypeLiteral)new TypeLiteral<List<String>>(){}).declareVariable("str", String.class, (Object)StatementBuilder.create().invokeStatic(Foo.class, "bar", new Object[]{Variable.get((String)"list")})).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate method invocation with variable return type inferred from List<T>", "String str = Foo.bar(list);", s);
    }

    @Test
    public void testInvokeWithNestedParameterizedListAndVariableReturnType() {
        String s = StatementBuilder.create((Context)Context.create().autoImport()).declareVariable("n", Integer.TYPE).declareVariable("list", (TypeLiteral)new TypeLiteral<List<List<Map<String, Integer>>>>(){}).declareVariable("str", String.class, (Object)StatementBuilder.create().invokeStatic(Foo.class, "bar", new Object[]{Variable.get((String)"n"), Variable.get((String)"list")})).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate method invocation with variable return type inferred from nested List<T>", "String str = Foo.bar(n, list);", s);
    }

    @Test
    public void testInvokeWithParameterizedMapAndVariableReturnType() {
        String s = StatementBuilder.create((Context)Context.create().autoImport()).declareVariable("map", (TypeLiteral)new TypeLiteral<Map<String, Integer>>(){}).declareVariable("val", Integer.class, (Object)StatementBuilder.create().invokeStatic(Foo.class, "bar", new Object[]{Variable.get((String)"map")})).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate method invocation with variable return type inferred from Map<K, V>", "Integer val = Foo.bar(map);", s);
    }

    @Test
    public void testInvokeWithParameterizedClassAndVariableReturnType() {
        String s = StatementBuilder.create((Context)Context.create().autoImport()).declareVariable("set", Set.class, (Object)StatementBuilder.create().invokeStatic(Foo.class, "baz", new Object[]{Set.class})).toJavaString();
        InvocationBuilderTest.assertEquals("Failed to generate method invocation with variable return type inferred from Class<T>", "Set set = Foo.baz(Set.class);", s);
    }

    @Test
    public void testLookupOfMethodWithArrayParameters() {
        MetaClass metaClass = MetaClassFactory.get(Arrays.class);
        MetaMethod equals = metaClass.getBestMatchingMethod("equals", new Class[]{Class[].class, Class[].class});
        InvocationBuilderTest.assertEquals("public boolean equals([[Ljava.lang.Object;, [Ljava.lang.Object;])", equals.toString());
    }
}

