/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import java.util.List;
import java.util.Map;
import javax.enterprise.util.TypeLiteral;
import org.jboss.errai.codegen.AssignmentOperator;
import org.jboss.errai.codegen.BooleanExpression;
import org.jboss.errai.codegen.BooleanOperator;
import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.Variable;
import org.jboss.errai.codegen.builder.Builder;
import org.jboss.errai.codegen.builder.ElseBlockBuilder;
import org.jboss.errai.codegen.builder.StatementEnd;
import org.jboss.errai.codegen.builder.WhileBuilder;
import org.jboss.errai.codegen.builder.impl.ContextBuilder;
import org.jboss.errai.codegen.builder.impl.ObjectBuilder;
import org.jboss.errai.codegen.builder.impl.StatementBuilder;
import org.jboss.errai.codegen.exception.InvalidExpressionException;
import org.jboss.errai.codegen.exception.InvalidTypeException;
import org.jboss.errai.codegen.exception.OutOfScopeException;
import org.jboss.errai.codegen.exception.TypeNotIterableException;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.util.Bool;
import org.jboss.errai.codegen.util.Stmt;
import org.junit.Assert;
import org.junit.Test;

public class LoopBuilderTest
extends AbstractCodegenTest {
    @Test
    public void testForeachLoopWithStringInParameterizedList() {
        String foreachWithListOfStrings = ((StatementEnd)StatementBuilder.create().declareVariable("list", (TypeLiteral)new TypeLiteral<List<String>>(){}).loadVariable("list", new Object[0]).foreach("element").finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate foreach loop using a List<String>", "   for (String element : list) {\n}", foreachWithListOfStrings);
    }

    @Test
    public void testForeachLoopWithStringInArray() {
        ObjectBuilder createObject = StatementBuilder.create().newObject(String.class);
        String foreachWithStringArray = ((StatementEnd)StatementBuilder.create((Context)Context.create().addVariable("list", String[].class)).loadVariable("list", new Object[0]).foreach("element").append((Statement)createObject).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate foreach loop using a String[]", "   for (String element : list) { \nnew String();\n}", foreachWithStringArray);
    }

    @Test
    public void testForeachLoopWithStringInList() {
        ObjectBuilder createObject = StatementBuilder.create().newObject(String.class);
        ObjectBuilder createAnotherObject = StatementBuilder.create().newObject(Object.class);
        String foreachWithList = ((StatementEnd)StatementBuilder.create().declareVariable("list", List.class).loadVariable("list", new Object[0]).foreach("element").append((Statement)createObject).append((Statement)createAnotherObject).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate foreach loop using a List<?>", "   for (Object element : list) { \nnew String(); \nnew Object();\n}", foreachWithList);
    }

    @Test
    public void testForeachLoopWithUndefinedCollection() {
        try {
            ((StatementEnd)StatementBuilder.create().loadVariable("list", new Object[0]).foreach("element", Integer.class).finish()).toJavaString();
            Assert.fail((String)"Expected OutOfScopeException");
        }
        catch (OutOfScopeException outOfScopeException) {
            // empty catch block
        }
    }

    @Test
    public void testForeachLoopWithProvidedLoopVarType() {
        Builder builder = (Builder)StatementBuilder.create().declareVariable("list", (TypeLiteral)new TypeLiteral<List<String>>(){}).loadVariable("list", new Object[0]).foreach("element", Object.class).finish();
        LoopBuilderTest.assertEquals("Failed to generate foreach loop with provided loop var type", "   for (Object element : list) {\n}", builder.toJavaString());
        try {
            ((StatementEnd)StatementBuilder.create().declareVariable("list", (TypeLiteral)new TypeLiteral<List<String>>(){}).loadVariable("list", new Object[0]).foreach("element", Integer.class).finish()).toJavaString();
            Assert.fail((String)"Expected InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testForeachLoopsNested() {
        ObjectBuilder createObject = StatementBuilder.create().newObject(String.class);
        Builder outerLoop = (Builder)StatementBuilder.create().declareVariable("list", (TypeLiteral)new TypeLiteral<List<String>>(){}).loadVariable("list", new Object[0]).foreach("element").append((Statement)StatementBuilder.create((Context)ContextBuilder.create().addVariable(Variable.create((String)"anotherList", (TypeLiteral)new TypeLiteral<List<String>>(){})).getContext()).loadVariable("anotherList", new Object[0]).foreach("anotherElement").append((Statement)createObject).finish()).finish();
        LoopBuilderTest.assertEquals("Failed to generate nested foreach loops", "     for (String element : list) { \nfor (String anotherElement : anotherList) {   \nnew String(); \n}\n}", outerLoop.toJavaString());
    }

    @Test
    public void testForeachLoopWithInvalidCollectionType() {
        try {
            ((StatementEnd)StatementBuilder.create().declareVariable("list", String.class).loadVariable("list", new Object[0]).foreach("element").finish()).toJavaString();
            Assert.fail((String)"Expected TypeNotIterableException");
        }
        catch (TypeNotIterableException typeNotIterableException) {
            // empty catch block
        }
    }

    @Test
    public void testForeachLoopWithInvoke() {
        Builder loop = (Builder)StatementBuilder.create().declareVariable("map", Map.class).loadVariable("map", new Object[0]).invoke("keySet", new Object[0]).foreach("key").append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{Variable.get((String)"key")})).finish();
        LoopBuilderTest.assertEquals("Failed to generate foreach loop using invoke()", "   for (Object key : map.keySet()) { System.out.println(key);\n}", loop.toJavaString());
    }

    @Test
    public void testForeachLoopWithLiterals() {
        String s = ((StatementEnd)StatementBuilder.create().loadLiteral((Object)new String[]{"s1", "s2"}).foreach("s").append((Statement)StatementBuilder.create().loadVariable("s", new Object[0]).invoke("getBytes", new Object[0])).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate foreach loop using a literal String array", "   for (String s : new String[] {\"s1\", \"s2\"}) { \ns.getBytes();\n}", s);
    }

    @Test
    public void testForeachLoopWithProvidedContext() {
        Context c = ContextBuilder.create().addVariable(Variable.create((String)"s", String.class)).getContext();
        String s = ((StatementEnd)StatementBuilder.create((Context)c).loadLiteral((Object)new String[]{"s1", "s2"}).foreach("s").append((Statement)StatementBuilder.create().loadVariable("s", new Object[0]).invoke("getBytes", new Object[0])).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate foreach loop using a literal String array", "   for (String s : new String[] {\"s1\", \"s2\"}) { \ns.getBytes();\n}", s);
    }

    @Test
    public void testForeachLoopWithNullCheck() {
        String foreachWithListOfStrings = ((StatementEnd)StatementBuilder.create().declareVariable("list", (TypeLiteral)new TypeLiteral<List<String>>(){}).loadVariable("list", new Object[0]).foreachIfNotNull("element").finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate foreach loop using a List<String> and null check", "   if (list != null) {\n     for (String element : list) {\n}\n}", foreachWithListOfStrings);
    }

    @Test
    public void testForeachLoopWithNullCheckAndProviderVarType() {
        String foreachWithListOfStrings = ((StatementEnd)StatementBuilder.create().declareVariable("list", (TypeLiteral)new TypeLiteral<List<String>>(){}).loadVariable("list", new Object[0]).foreachIfNotNull("element", Object.class).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate foreach loop using a List<String> and null check", "   if (list != null) {\n     for (Object element : list) {\n}\n}", foreachWithListOfStrings);
    }

    @Test
    public void testWhileLoopWithInvalidExpression() {
        try {
            ((StatementEnd)StatementBuilder.create().declareVariable("n", Integer.class).loadVariable("n", new Object[0]).while_().finish()).toJavaString();
            Assert.fail((String)"Expected InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
        try {
            ((StatementEnd)StatementBuilder.create().declareVariable("str", String.class).declareVariable("str2", String.class).loadVariable("str", new Object[0]).while_(BooleanOperator.GreaterThan, (Statement)Variable.get((String)"str2")).finish()).toJavaString();
            Assert.fail((String)"Expected InvalidExpressionException");
        }
        catch (InvalidExpressionException iee) {
            Assert.assertTrue((String)"Wrong exception thrown", (boolean)iee.getMessage().contains(String.class.getName()));
        }
    }

    @Test
    public void testWhileLoopChainedWithEmptyExpressionWithoutBody() {
        String s = ((StatementEnd)StatementBuilder.create().declareVariable("b", Boolean.class).loadVariable("b", new Object[0]).while_().finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate empty while loop with chained lhs", "   while (b) { }", s);
    }

    @Test
    public void testWhileLoopChainedWithEmptyExpressionWithBody() {
        String s = ((StatementEnd)StatementBuilder.create().declareVariable("b", Boolean.class).loadVariable("b", new Object[0]).while_().append((Statement)StatementBuilder.create().loadVariable("b", new Object[0]).assignValue((Object)false)).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate while loop with chained lhs and body", "   while (b) {\nb = false;\n}", s);
    }

    @Test
    public void testWhileLoopChainedWithNullCheck() {
        String s = ((StatementEnd)StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).while_(BooleanOperator.NotEquals, null).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate while loop with chained lhs, rhs (null check) and no body", "   while (str != null) { }", s);
    }

    @Test
    public void testWhileLoopChainedWithExpression() {
        String s = ((StatementEnd)StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).invoke("length", new Object[0]).while_(BooleanOperator.GreaterThanOrEqual, (Object)2).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate while loop with chained lhs, rhs and no body", "   while (str.length() >= 2) { }", s);
    }

    @Test
    public void testWhileLoopUnchainedWithExpression() {
        Context ctx = Context.create().addVariable("str", String.class);
        String s = ((StatementEnd)StatementBuilder.create((Context)ctx).while_(Bool.expr((Object)Stmt.loadVariable((String)"str", (Object[])new Object[0]).invoke("length", new Object[0]), (BooleanOperator)BooleanOperator.GreaterThanOrEqual, (Object)2)).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate while loop with rhs and no body", "   while (str.length() >= 2) { }", s);
    }

    @Test
    public void testWhileLoopUnchainedWithNestedExpressions() {
        String s = ((StatementEnd)StatementBuilder.create().declareVariable("str", String.class).while_(Bool.expr((Object)Bool.expr((Object)Variable.get((String)"str"), (BooleanOperator)BooleanOperator.NotEquals, null), (BooleanOperator)BooleanOperator.And, (Object)Bool.expr((Object)Stmt.loadVariable((String)"str", (Object[])new Object[0]).invoke("length", new Object[0]), (BooleanOperator)BooleanOperator.GreaterThan, (Object)0))).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate while loop with nested expressions and no body", "   while ((str != null) && (str.length() > 0)) { }", s);
    }

    @Test
    public void testWhileLoopsNested() {
        Context c = Context.create().addVariable("str", String.class).addVariable("str2", String.class);
        String s = ((StatementEnd)StatementBuilder.create((Context)c).loadVariable("str", new Object[0]).while_(BooleanOperator.NotEquals, null).append((Statement)StatementBuilder.create((Context)c).while_(Bool.expr((Object)Variable.get((String)"str2"), (BooleanOperator)BooleanOperator.NotEquals, null)).finish()).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate nested while loops", "   while (str != null) {  while (str2 != null) { }\n}", s);
    }

    @Test
    public void testForLoopUnchainedWithoutInitializerAndCountingExpression() {
        String s = ((StatementEnd)StatementBuilder.create().declareVariable("i", Integer.class, (Object)0).for_(Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.LessThan, (Object)100)).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate for loop without initializer", "     for (; i < 100; ) { }", s);
    }

    @Test
    public void testForLoopChainedWithoutCountingExpression() {
        String s = ((StatementEnd)StatementBuilder.create().declareVariable("i", Integer.class, (Object)0).loadVariable("i", new Object[0]).for_((Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue((Object)0), Bool.expr((BooleanOperator)BooleanOperator.LessThan, (Object)100)).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate for loop with initializer and chained lhs", "     for (i = 0; i < 100; ) { }", s);
    }

    @Test
    public void testForLoopUnchainedWithInitializer() {
        String s = ((StatementEnd)StatementBuilder.create().declareVariable("i", Integer.class).for_((Statement)StatementBuilder.create().loadVariable("i", new Object[0]).assignValue((Object)0), Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.LessThan, (Object)100)).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate for loop with initializer", "     for (i = 0; i < 100; ) { }", s);
    }

    @Test
    public void testForLoopChainedWithCountingExpression() {
        String s = ((StatementEnd)StatementBuilder.create().declareVariable("i", Integer.class, (Object)0).loadVariable("i", new Object[0]).for_((Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue((Object)0), Bool.expr((BooleanOperator)BooleanOperator.LessThan, (Object)100), (Statement)StatementBuilder.create().loadVariable("i", new Object[0]).assignValue(AssignmentOperator.PreIncrementAssign, (Object)1)).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate for loop with initializer and counting expression and chained lhs", "     for (i = 0; i < 100; i += 1) { }", s);
    }

    @Test
    public void testForLoopUnchainedWithInitializerAndCountingExpression() {
        String s = ((StatementEnd)StatementBuilder.create().declareVariable("i", Integer.class).for_((Statement)StatementBuilder.create().loadVariable("i", new Object[0]).assignValue((Object)0), Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.LessThan, (Object)100), (Statement)StatementBuilder.create().loadVariable("i", new Object[0]).assignValue(AssignmentOperator.PreIncrementAssign, (Object)1)).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate for loop with initializer and counting expression", "     for (i = 0; i < 100; i += 1) { }", s);
    }

    @Test
    public void testForLoopUnchainedWithDeclaringInitializerAndCountingExpression() {
        String s = ((StatementEnd)StatementBuilder.create().for_((Statement)Stmt.declareVariable(Integer.TYPE).named("i").initializeWith((Object)0), Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.LessThan, (Object)100), (Statement)StatementBuilder.create().loadVariable("i", new Object[0]).assignValue(AssignmentOperator.PreIncrementAssign, (Object)1)).append((Statement)StatementBuilder.create().loadStatic(System.class, "out").invoke("println", new Object[]{Variable.get((String)"i")})).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate for loop with declaring initializer and counting expression", "     for (int i = 0; i < 100; i += 1) { System.out.println(i); }", s);
    }

    @Test
    public void testDoWhileLoopUnchainedWithoutRhs() {
        String s = ((WhileBuilder)StatementBuilder.create().declareVariable("b", Boolean.class).do_().append((Statement)StatementBuilder.create().loadVariable("b", new Object[0]).assignValue((Object)false)).finish()).while_(Bool.expr((Statement)Variable.get((String)"b"))).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate do while loop with simple expression (no operator and rhs)", "     do { b = false; } while (b);", s);
    }

    @Test
    public void testDoWhileLoopChainedWithoutRhs() {
        String s = ((WhileBuilder)StatementBuilder.create().declareVariable("b", Boolean.class).loadVariable("b", new Object[0]).do_().append((Statement)StatementBuilder.create().loadVariable("b", new Object[0]).assignValue((Object)false)).finish()).while_().toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate for do while loop with simple expression (no operator and rhs) and chained lhs", "     do { b = false; } while (b);", s);
    }

    @Test
    public void testDoWhileLoopChainedWithRhs() {
        String s = ((WhileBuilder)StatementBuilder.create().declareVariable("n", Integer.class).loadVariable("n", new Object[0]).do_().append((Statement)StatementBuilder.create().loadVariable("n", new Object[0]).assignValue((Object)1)).finish()).while_(BooleanOperator.GreaterThanOrEqual, (Object)1).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate for do while loop with simple expression (no operator and rhs) and chained lhs", "     do { n = 1; } while (n >= 1);", s);
    }

    @Test
    public void testDoWhileLoopUnchainedWithNestedExpressions() {
        String s = ((WhileBuilder)StatementBuilder.create().declareVariable("str", String.class).do_().append((Statement)StatementBuilder.create().loadStatic(System.class, "out").invoke("println", new Object[]{Variable.get((String)"str")})).finish()).while_(Bool.expr((Object)Bool.expr((Object)Variable.get((String)"str"), (BooleanOperator)BooleanOperator.NotEquals, null), (BooleanOperator)BooleanOperator.And, (Object)Bool.expr((Object)Stmt.loadVariable((String)"str", (Object[])new Object[0]).invoke("length", new Object[0]), (BooleanOperator)BooleanOperator.GreaterThan, (Object)0))).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate do while loop with nested expression", "     do { System.out.println(str); } while ((str != null) && (str.length() > 0));", s);
    }

    @Test
    public void testLoopWithContinue() {
        String s = ((ElseBlockBuilder)StatementBuilder.create().declareVariable("i", Integer.class, (Object)0).loadVariable("i", new Object[0]).if_(BooleanOperator.GreaterThan, (Object)100).append((Statement)Stmt.for_((Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue((Object)0), (BooleanExpression)Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.LessThan, (Object)100), (Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue(AssignmentOperator.PreIncrementAssign, (Object)1)).append((Statement)Stmt.if_((BooleanExpression)Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.Equals, (Object)50)).append((Statement)Stmt.continue_()).finish()).finish()).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate loop with continue", "     if (i > 100) {   for (i = 0; i < 100; i += 1) {      if (i == 50) {       continue;     }   }\n\n}", s);
    }

    @Test
    public void testLoopWithContinueAndLabel() {
        String s = ((ElseBlockBuilder)StatementBuilder.create().declareVariable("i", Integer.class, (Object)0).loadVariable("i", new Object[0]).if_(BooleanOperator.GreaterThan, (Object)100).append((Statement)Stmt.label((String)"label")).append((Statement)Stmt.for_((Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue((Object)0), (BooleanExpression)Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.LessThan, (Object)100), (Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue(AssignmentOperator.PreIncrementAssign, (Object)1)).append((Statement)Stmt.if_((BooleanExpression)Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.Equals, (Object)50)).append((Statement)Stmt.continue_((String)"label")).finish()).finish()).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate loop with continue and label", "     if (i > 100) { label:   for (i = 0; i < 100; i += 1) {      if (i == 50) {       continue label;     }   }\n\n}", s);
    }

    @Test
    public void testLoopWithBreak() {
        String s = ((ElseBlockBuilder)StatementBuilder.create().declareVariable("i", Integer.class, (Object)0).loadVariable("i", new Object[0]).if_(BooleanOperator.GreaterThan, (Object)100).append((Statement)Stmt.for_((Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue((Object)0), (BooleanExpression)Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.LessThan, (Object)100), (Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue(AssignmentOperator.PreIncrementAssign, (Object)1)).append((Statement)Stmt.if_((BooleanExpression)Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.Equals, (Object)50)).append((Statement)Stmt.break_()).finish()).finish()).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate loop with continue", "     if (i > 100) {   for (i = 0; i < 100; i += 1) {      if (i == 50) {       break;     }   }\n\n}", s);
    }

    @Test
    public void testLoopWithBreakAndLabel() {
        String s = ((ElseBlockBuilder)StatementBuilder.create().declareVariable("i", Integer.class, (Object)0).loadVariable("i", new Object[0]).if_(BooleanOperator.GreaterThan, (Object)100).append((Statement)Stmt.label((String)"label")).append((Statement)Stmt.for_((Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue((Object)0), (BooleanExpression)Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.LessThan, (Object)100), (Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue(AssignmentOperator.PreIncrementAssign, (Object)1)).append((Statement)Stmt.if_((BooleanExpression)Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.Equals, (Object)50)).append((Statement)Stmt.break_((String)"label")).finish()).finish()).finish()).toJavaString();
        LoopBuilderTest.assertEquals("Failed to generate loop with continue and label", "     if (i > 100) { label:   for (i = 0; i < 100; i += 1) {      if (i == 50) {       break label;     }   }\n\n}", s);
    }

    @Test
    public void testLoopWithInvalidLabel() {
        try {
            ((ElseBlockBuilder)StatementBuilder.create().declareVariable("i", Integer.class, (Object)0).loadVariable("i", new Object[0]).if_(BooleanOperator.GreaterThan, (Object)100).append((Statement)Stmt.label((String)"label")).append((Statement)Stmt.for_((Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue((Object)0), (BooleanExpression)Bool.expr((Object)Variable.get((String)"i"), (BooleanOperator)BooleanOperator.LessThan, (Object)100), (Statement)Stmt.loadVariable((String)"i", (Object[])new Object[0]).assignValue(AssignmentOperator.PreIncrementAssign, (Object)1)).append((Statement)Stmt.continue_((String)"undefinedlabel")).finish()).finish()).toJavaString();
            Assert.fail((String)"expected OutOfScopeException");
        }
        catch (OutOfScopeException outOfScopeException) {
            // empty catch block
        }
    }
}

