/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import com.google.common.io.CharStreams;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.errai.codegen.test.model.BeanWithTypeParmedMeths;
import org.jboss.errai.codegen.test.model.FakeBean;
import org.jboss.errai.codegen.util.QuickDeps;
import org.junit.Assert;
import org.junit.Test;

public class ReachabilityTest {
    private static String getSource(Class clazz) throws Exception {
        String pathSeparator = File.separator;
        String name = clazz.getName().replace('.', pathSeparator.charAt(0)) + ".java";
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(name);
        if (inputStream == null) {
            throw new RuntimeException("not found: " + name);
        }
        return CharStreams.toString((Readable)new InputStreamReader(inputStream));
    }

    @Test
    public void testBasicReachability() throws Exception {
        String source = ReachabilityTest.getSource(BeanWithTypeParmedMeths.class);
        Set quickTypeDependencyList = QuickDeps.getQuickTypeDependencyList((String)source, (ClassLoader)BeanWithTypeParmedMeths.class.getClassLoader());
        HashSet<String> expected = new HashSet<String>(Arrays.asList("org.jboss.errai.codegen.test.model.BeanWithTypeParmedMeths", "org.jboss.errai.codegen.test.model.Foo", "org.jboss.errai.codegen.test.model.Bar", "java.util.Map"));
        Assert.assertEquals(expected, (Object)quickTypeDependencyList);
    }

    @Test
    public void testBasicReachability2() throws Exception {
        String source = ReachabilityTest.getSource(FakeBean.class);
        Set quickTypeDependencyList = QuickDeps.getQuickTypeDependencyList((String)source, (ClassLoader)FakeBean.class.getClassLoader());
        System.out.println(quickTypeDependencyList);
        HashSet<String> expected = new HashSet<String>(Arrays.asList("org.jboss.errai.codegen.test.model.FakeBean", "javax.enterprise.inject.Instance", "javax.inject.Inject", "org.jboss.errai.codegen.test.model.Bar", "org.jboss.errai.codegen.test.model.Bwah", BigDecimal.class.getName(), BigInteger.class.getName(), String.class.getName(), Class.class.getName()));
        Assert.assertEquals(expected, (Object)quickTypeDependencyList);
    }
}

