/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import java.util.Arrays;
import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.SnapshotMaker;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.builder.BlockBuilder;
import org.jboss.errai.codegen.builder.ClassStructureBuilder;
import org.jboss.errai.codegen.builder.impl.ClassBuilder;
import org.jboss.errai.codegen.exception.CyclicalObjectGraphException;
import org.jboss.errai.codegen.meta.MetaMethod;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.test.model.Person;
import org.jboss.errai.codegen.test.model.PersonImpl;
import org.jboss.errai.codegen.test.model.SnapshotInterfaceWithCollections;
import org.jboss.errai.codegen.test.model.SnapshotInterfaceWithCollectionsImpl;
import org.jboss.errai.codegen.util.Stmt;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotMakerTest
extends AbstractCodegenTest {
    @Test
    public void testGenerateSnapshotOfMethod() throws Exception {
        PersonImpl mother = new PersonImpl("mom", 30, null);
        PersonImpl child = new PersonImpl("kid", 5, mother);
        Statement snapshotStmt = SnapshotMaker.makeSnapshotAsSubclass((Object)child, Person.class, Person.class, null, (Class[])new Class[]{Person.class});
        String generated = snapshotStmt.generate(Context.create());
        String expectedValue = "new org.jboss.errai.codegen.test.model.Person() {\n  public int getAge() {\n    return 5;\n  }\n  public org.jboss.errai.codegen.test.model.Person getMother() {\n    return new org.jboss.errai.codegen.test.model.Person() {\n      public int getAge() {\n        return 30;\n      }\n      public org.jboss.errai.codegen.test.model.Person getMother() {\n        return null;\n      }\n      public String getName() {\n        return \"mom\";\n      }\n    };\n  }\n  public String getName() {\n    return \"kid\";\n  }\n}";
        SnapshotMakerTest.assertEquals("new org.jboss.errai.codegen.test.model.Person() {\n  public int getAge() {\n    return 5;\n  }\n  public org.jboss.errai.codegen.test.model.Person getMother() {\n    return new org.jboss.errai.codegen.test.model.Person() {\n      public int getAge() {\n        return 30;\n      }\n      public org.jboss.errai.codegen.test.model.Person getMother() {\n        return null;\n      }\n      public String getName() {\n        return \"mom\";\n      }\n    };\n  }\n  public String getName() {\n    return \"kid\";\n  }\n}", generated);
    }

    @Test
    public void testNoStackOverflowOnObjectCycle() {
        PersonImpl cycle1 = new PersonImpl("cycle1", 30, null);
        PersonImpl cycle2 = new PersonImpl("cycle2", 5, cycle1);
        cycle1.setMother(cycle2);
        try {
            Statement snapshotStmt = SnapshotMaker.makeSnapshotAsSubclass((Object)cycle2, Person.class, Person.class, null, (Class[])new Class[]{Person.class});
            snapshotStmt.generate(Context.create());
            Assert.fail((String)"Instance cycle was not detected");
        }
        catch (CyclicalObjectGraphException e) {
            Assert.assertTrue((boolean)e.getObjectsInvolvedInCycle().contains(cycle1));
            Assert.assertTrue((boolean)e.getObjectsInvolvedInCycle().contains(cycle2));
        }
    }

    @Test
    public void testCollectionsLiteralizableInSnapshots() throws Exception {
        PersonImpl jonathan = new PersonImpl("Jonathan F.", 20, new PersonImpl("Jonathans's Parent", 50, null));
        PersonImpl christian = new PersonImpl("Christian S.", 20, new PersonImpl("Christians's Parent", 50, null));
        PersonImpl mike = new PersonImpl("Mike B.", 0, new PersonImpl("Mike's Parent", 50, null));
        SnapshotInterfaceWithCollectionsImpl personCollection = new SnapshotInterfaceWithCollectionsImpl(Arrays.asList(jonathan, christian, mike));
        Context ctx = Context.create();
        ctx.addLiteralizableClass(SnapshotInterfaceWithCollections.class);
        ctx.addLiteralizableClass(Person.class);
        String generated = Stmt.create((Context)ctx).load((Object)personCollection).toJavaString();
        String expectedValue = "new org.jboss.errai.codegen.test.model.SnapshotInterfaceWithCollections() {\n  public java.util.List getPersons() {\n    return new java.util.ArrayList() {\n      {\n        add(new org.jboss.errai.codegen.test.model.Person() {\n          public int getAge() {\n            return 20;\n          }\n          public org.jboss.errai.codegen.test.model.Person getMother() {\n            return new org.jboss.errai.codegen.test.model.Person() {\n              public int getAge() {\n                return 50;\n              }\n              public org.jboss.errai.codegen.test.model.Person getMother() {\n                return null;\n              }\n              public String getName() {\n                return \"Jonathans's Parent\";\n              }\n            };\n          }\n          public String getName() {\n            return \"Jonathan F.\";\n          }\n        });\n        add(new org.jboss.errai.codegen.test.model.Person() {\n          public int getAge() {\n            return 20;\n          }\n          public org.jboss.errai.codegen.test.model.Person getMother() {\n            return new org.jboss.errai.codegen.test.model.Person() {\n              public int getAge() {\n                return 50;\n              }\n              public org.jboss.errai.codegen.test.model.Person getMother() {\n                return null;\n              }\n              public String getName() {\n                return \"Christians's Parent\";\n              }\n            };\n          }\n          public String getName() {\n            return \"Christian S.\";\n          }\n        });\n        add(new org.jboss.errai.codegen.test.model.Person() {\n          public int getAge() {\n            return 0;\n          }\n          public org.jboss.errai.codegen.test.model.Person getMother() {\n            return new org.jboss.errai.codegen.test.model.Person() {\n              public int getAge() {\n                return 50;\n              }\n              public org.jboss.errai.codegen.test.model.Person getMother() {\n                return null;\n              }\n              public String getName() {\n                return \"Mike's Parent\";\n              }\n            };\n          }\n          public String getName() {\n            return \"Mike B.\";\n          }\n        });\n      }\n    };\n  }\n}\n";
        SnapshotMakerTest.assertEquals("new org.jboss.errai.codegen.test.model.SnapshotInterfaceWithCollections() {\n  public java.util.List getPersons() {\n    return new java.util.ArrayList() {\n      {\n        add(new org.jboss.errai.codegen.test.model.Person() {\n          public int getAge() {\n            return 20;\n          }\n          public org.jboss.errai.codegen.test.model.Person getMother() {\n            return new org.jboss.errai.codegen.test.model.Person() {\n              public int getAge() {\n                return 50;\n              }\n              public org.jboss.errai.codegen.test.model.Person getMother() {\n                return null;\n              }\n              public String getName() {\n                return \"Jonathans's Parent\";\n              }\n            };\n          }\n          public String getName() {\n            return \"Jonathan F.\";\n          }\n        });\n        add(new org.jboss.errai.codegen.test.model.Person() {\n          public int getAge() {\n            return 20;\n          }\n          public org.jboss.errai.codegen.test.model.Person getMother() {\n            return new org.jboss.errai.codegen.test.model.Person() {\n              public int getAge() {\n                return 50;\n              }\n              public org.jboss.errai.codegen.test.model.Person getMother() {\n                return null;\n              }\n              public String getName() {\n                return \"Christians's Parent\";\n              }\n            };\n          }\n          public String getName() {\n            return \"Christian S.\";\n          }\n        });\n        add(new org.jboss.errai.codegen.test.model.Person() {\n          public int getAge() {\n            return 0;\n          }\n          public org.jboss.errai.codegen.test.model.Person getMother() {\n            return new org.jboss.errai.codegen.test.model.Person() {\n              public int getAge() {\n                return 50;\n              }\n              public org.jboss.errai.codegen.test.model.Person getMother() {\n                return null;\n              }\n              public String getName() {\n                return \"Mike's Parent\";\n              }\n            };\n          }\n          public String getName() {\n            return \"Mike B.\";\n          }\n        });\n      }\n    };\n  }\n}\n", generated);
    }

    @Test
    public void testMethodBodyCallback() {
        PersonImpl mom = new PersonImpl("mom", 30, null);
        PersonImpl kid1 = new PersonImpl("Kid 1", 3, mom);
        PersonImpl kid2 = new PersonImpl("Kid 2", 4, mom);
        PersonImpl kid3 = new PersonImpl("Kid 3", 5, mom);
        ClassStructureBuilder peopleClassBuilder = ClassBuilder.define((String)"com.foo.People").publicScope().body();
        BlockBuilder method = peopleClassBuilder.publicMethod(Void.TYPE, "makePeople").body();
        Statement momVar = (Statement)Stmt.declareVariable(Person.class).asFinal().named("mom").initializeWith(SnapshotMaker.makeSnapshotAsSubclass((Object)mom, Person.class, Person.class, null, (Class[])new Class[]{Person.class}));
        method.append(momVar);
        SnapshotMaker.MethodBodyCallback mbcb = new SnapshotMaker.MethodBodyCallback(){

            public Statement generateMethodBody(MetaMethod method, Object o, ClassStructureBuilder<?> containingClass) {
                if (method.getName().equals("getMother")) {
                    return Stmt.loadVariable((String)"mom", (Object[])new Object[0]).returnValue();
                }
                return null;
            }
        };
        method.append((Statement)Stmt.declareVariable((String)"kid1", (Object)SnapshotMaker.makeSnapshotAsSubclass((Object)kid1, Person.class, Person.class, (SnapshotMaker.MethodBodyCallback)mbcb, (Class[])new Class[]{Person.class})));
        method.append((Statement)Stmt.declareVariable((String)"kid2", (Object)SnapshotMaker.makeSnapshotAsSubclass((Object)kid2, Person.class, Person.class, (SnapshotMaker.MethodBodyCallback)mbcb, (Class[])new Class[]{Person.class})));
        method.append((Statement)Stmt.declareVariable((String)"kid3", (Object)SnapshotMaker.makeSnapshotAsSubclass((Object)kid3, Person.class, Person.class, (SnapshotMaker.MethodBodyCallback)mbcb, (Class[])new Class[]{Person.class})));
        method.finish();
        String generated = peopleClassBuilder.toJavaString();
        String expected = "package com.foo;\n\nimport org.jboss.errai.codegen.test.model.Person;\n\npublic class People {\n  public void makePeople() {\n    final Person mom = new Person() {\n      public int getAge() {\n        return 30;\n      }\n      public Person getMother() {\n        return null;\n      }\n      public String getName() {\n        return \"mom\";\n      }\n    };\n    Person kid1 = new Person() {\n      public int getAge() {\n        return 3;\n      }\n      public Person getMother() {\n        return mom;\n      }\n      public String getName() {\n        return \"Kid 1\";\n      }\n    };\n    Person kid2 = new Person() {\n      public int getAge() {\n        return 4;\n      }\n      public Person getMother() {\n        return mom;\n      }\n      public String getName() {\n        return \"Kid 2\";\n      }\n    };\n    Person kid3 = new Person() {\n      public int getAge() {\n        return 5;\n      }\n      public Person getMother() {\n        return mom;\n      }\n      public String getName() {\n        return \"Kid 3\";\n      }\n    };\n  }\n}\n";
        SnapshotMakerTest.assertEquals(expected, generated);
    }
}

