/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.codegen.test;

import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.builder.CaseBlockBuilder;
import org.jboss.errai.codegen.builder.StatementEnd;
import org.jboss.errai.codegen.builder.impl.StatementBuilder;
import org.jboss.errai.codegen.exception.InvalidTypeException;
import org.jboss.errai.codegen.test.AbstractCodegenTest;
import org.jboss.errai.codegen.util.Stmt;
import org.junit.Assert;
import org.junit.Test;

public class SwitchBlockBuilderTest
extends AbstractCodegenTest {
    @Test
    public void testSwitchBlockWithInvalidStatement() {
        try {
            StatementBuilder.create().switch_((Statement)Stmt.loadStatic(System.class, (String)"out")).toJavaString();
            Assert.fail((String)"expected InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testSwitchBlockWithInvalidCaseValueUsingEnumForInt() {
        try {
            Context c = Context.create().addVariable("n", Integer.TYPE);
            ((CaseBlockBuilder)StatementBuilder.create((Context)c).switch_((Statement)c.getVariable("n")).case_((Enum)TestEnum.A).finish()).toJavaString();
            Assert.fail((String)"expected InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testSwitchBlockWithInvalidCaseValueUsingIntForEnum() {
        try {
            Context c = Context.create().addVariable("t", TestEnum.class);
            ((CaseBlockBuilder)StatementBuilder.create((Context)c).switch_((Statement)Stmt.loadVariable((String)"t", (Object[])new Object[0])).case_(1).finish()).toJavaString();
            Assert.fail((String)"expected InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testSwitchBlockOnIntEmpty() {
        String s = StatementBuilder.create().declareVariable("n", Integer.TYPE).switch_((Statement)Stmt.loadVariable((String)"n", (Object[])new Object[0])).toJavaString();
        SwitchBlockBuilderTest.assertEquals("Failed to generate empty switch block", "     switch (n) {\n } ", s);
    }

    @Test
    public void testSwitchBlockOnInt() {
        String s = ((StatementEnd)((CaseBlockBuilder)((CaseBlockBuilder)StatementBuilder.create().declareVariable("n", Integer.TYPE).switch_((Statement)Stmt.loadVariable((String)"n", (Object[])new Object[0])).case_(0).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"0"})).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"break"})).append((Statement)Stmt.break_()).finish()).case_(1).append((Statement)Stmt.break_()).finish()).default_().append((Statement)Stmt.break_()).finish()).toJavaString();
        SwitchBlockBuilderTest.assertEquals("Failed to generate int switch block", "     switch (n) {\n   case 0: System.out.println(\"0\"); System.out.println(\"break\"); break;   case 1: break;   default: break; } ", s);
    }

    @Test
    public void testSwitchBlockOnEnum() {
        Context c = Context.create().autoImport();
        String s = ((StatementEnd)((CaseBlockBuilder)((CaseBlockBuilder)StatementBuilder.create((Context)c).declareVariable("t", TestEnum.class).switch_((Statement)Stmt.loadVariable((String)"t", (Object[])new Object[0])).case_((Enum)TestEnum.A).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"A"})).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"break"})).append((Statement)Stmt.break_()).finish()).case_((Enum)TestEnum.B).append((Statement)Stmt.break_()).finish()).default_().append((Statement)Stmt.break_()).finish()).toJavaString();
        SwitchBlockBuilderTest.assertEquals("Failed to generate enum switch block", "     switch (t) {\n   case A: System.out.println(\"A\"); System.out.println(\"break\"); break;   case B: break;   default: break; } ", s);
    }

    @Test
    public void testSwitchBlockWithoutDefaultBlock() {
        String s = ((CaseBlockBuilder)((CaseBlockBuilder)StatementBuilder.create().declareVariable("n", Integer.class).switch_((Statement)Stmt.loadVariable((String)"n", (Object[])new Object[0])).case_(0).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"0"})).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"break"})).append((Statement)Stmt.break_()).finish()).case_(1).append((Statement)Stmt.break_()).finish()).toJavaString();
        SwitchBlockBuilderTest.assertEquals("Failed to generate Integer switch block without default", "     switch (n) {\n   case 0: System.out.println(\"0\"); System.out.println(\"break\"); break;   case 1: break; } ", s);
    }

    @Test
    public void testSwitchBlockWithFallThrough() {
        String s = ((CaseBlockBuilder)((CaseBlockBuilder)StatementBuilder.create().declareVariable("n", Integer.TYPE).switch_((Statement)Stmt.loadVariable((String)"n", (Object[])new Object[0])).case_(0).finish()).case_(1).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"1"})).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"break"})).append((Statement)Stmt.break_()).finish()).toJavaString();
        SwitchBlockBuilderTest.assertEquals("Failed to generate int switch block with fallthrough", "     switch (n) {\n   case 0:   case 1: System.out.println(\"1\"); System.out.println(\"break\"); break; } ", s);
    }

    @Test
    public void testSwitchBlockChained() {
        String s = ((StatementEnd)((CaseBlockBuilder)((CaseBlockBuilder)StatementBuilder.create().declareVariable("n", Integer.TYPE).loadVariable("n", new Object[0]).switch_().case_(0).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"0"})).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"break"})).append((Statement)Stmt.break_()).finish()).case_(1).append((Statement)Stmt.break_()).finish()).default_().append((Statement)Stmt.break_()).finish()).toJavaString();
        SwitchBlockBuilderTest.assertEquals("Failed to generate chained switch block", "     switch (n) {\n   case 0: System.out.println(\"0\"); System.out.println(\"break\"); break;   case 1: break;   default: break; } ", s);
    }

    @Test
    public void testSwitchBlockChainedOnChar() {
        String s = ((StatementEnd)((CaseBlockBuilder)((CaseBlockBuilder)StatementBuilder.create().declareVariable("c", Character.TYPE).loadVariable("c", new Object[0]).switch_().case_('a').append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"a"})).append((Statement)Stmt.break_()).finish()).case_('b').append((Statement)Stmt.break_()).finish()).default_().append((Statement)Stmt.break_()).finish()).toJavaString();
        SwitchBlockBuilderTest.assertEquals("Failed to generate char switch block", "     switch (c) {\n   case 'a': System.out.println(\"a\"); break;   case 'b': break;   default: break; } ", s);
    }

    @Test
    public void testSwitchBlockChainedOnInvocation() {
        String s = ((StatementEnd)((CaseBlockBuilder)((CaseBlockBuilder)StatementBuilder.create().declareVariable("str", String.class).loadVariable("str", new Object[0]).invoke("length", new Object[0]).switch_().case_(0).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"0"})).append((Statement)Stmt.loadStatic(System.class, (String)"out").invoke("println", new Object[]{"break"})).append((Statement)Stmt.break_()).finish()).case_(1).append((Statement)Stmt.break_()).finish()).default_().append((Statement)Stmt.break_()).finish()).toJavaString();
        SwitchBlockBuilderTest.assertEquals("Failed to generate switch block chained on invocation", "     switch (str.length()) {\n   case 0: System.out.println(\"0\"); System.out.println(\"break\"); break;   case 1: break;   default: break; } ", s);
    }

    public static enum TestEnum {
        A,
        B;

    }
}

