/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.maven.BuildAbort;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.event.DefaultEventSpyContext;
import org.apache.maven.cli.event.ExecutionEventLogger;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfigurationFactory;
import org.apache.maven.cli.logging.Slf4jLoggerManager;
import org.apache.maven.cli.logging.Slf4jStdoutLogger;
import org.apache.maven.cli.transfer.ConsoleMavenTransferListener;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.cli.transfer.Slf4jMavenTransferListener;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.exception.DefaultExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.properties.internal.SystemProperties;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.building.SettingsSource;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.transfer.TransferListener;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class MavenCli {
    public static final String LOCAL_REPO_PROPERTY = "maven.repo.local";
    public static final String THREADS_DEPRECATED = "maven.threads.experimental";
    public static final String userHome = System.getProperty("user.home");
    public static final File userMavenConfigurationHome = new File(userHome, ".m2");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(userMavenConfigurationHome, "settings.xml");
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", System.getProperty("user.dir", "")), "conf/settings.xml");
    public static final File DEFAULT_USER_TOOLCHAINS_FILE = new File(userMavenConfigurationHome, "toolchains.xml");
    private static final String EXT_CLASS_PATH = "maven.ext.class.path";
    private ClassWorld classWorld;
    private LoggerManager plexusLoggerManager;
    private ILoggerFactory slf4jLoggerFactory;
    private Logger slf4jLogger;
    private EventSpyDispatcher eventSpyDispatcher;
    private ModelProcessor modelProcessor;
    private Maven maven;
    private MavenExecutionRequestPopulator executionRequestPopulator;
    private SettingsBuilder settingsBuilder;
    private DefaultSecDispatcher dispatcher;

    public MavenCli() {
        this(null);
    }

    public MavenCli(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    public static void main(String[] args) {
        int result = MavenCli.main(args, null);
        System.exit(result);
    }

    public static int main(String[] args, ClassWorld classWorld) {
        MavenCli cli = new MavenCli();
        return cli.doMain(new CliRequest(args, classWorld));
    }

    public static int doMain(String[] args, ClassWorld classWorld) {
        MavenCli cli = new MavenCli();
        return cli.doMain(new CliRequest(args, classWorld));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(String[] args, String workingDirectory, PrintStream stdout, PrintStream stderr) {
        PrintStream oldout = System.out;
        PrintStream olderr = System.err;
        try {
            if (stdout != null) {
                System.setOut(stdout);
            }
            if (stderr != null) {
                System.setErr(stderr);
            }
            CliRequest cliRequest = new CliRequest(args, this.classWorld);
            cliRequest.workingDirectory = workingDirectory;
            int n = this.doMain(cliRequest);
            return n;
        }
        finally {
            System.setOut(oldout);
            System.setErr(olderr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(CliRequest cliRequest) {
        PlexusContainer localContainer = null;
        try {
            this.initialize(cliRequest);
            this.cli(cliRequest);
            this.logging(cliRequest);
            this.version(cliRequest);
            this.properties(cliRequest);
            localContainer = this.container(cliRequest);
            this.commands(cliRequest);
            this.settings(cliRequest);
            this.populateRequest(cliRequest);
            this.encryption(cliRequest);
            this.repository(cliRequest);
            int n = this.execute(cliRequest);
            return n;
        }
        catch (ExitException e) {
            int n = e.exitCode;
            return n;
        }
        catch (UnrecognizedOptionException e) {
            int n = 1;
            return n;
        }
        catch (BuildAbort e) {
            CLIReportingUtils.showError(this.slf4jLogger, "ABORTED", e, cliRequest.showErrors);
            int n = 2;
            return n;
        }
        catch (Exception e) {
            CLIReportingUtils.showError(this.slf4jLogger, "Error executing Maven.", e, cliRequest.showErrors);
            int n = 1;
            return n;
        }
        finally {
            if (localContainer != null) {
                localContainer.dispose();
            }
        }
    }

    private void initialize(CliRequest cliRequest) {
        String mavenHome;
        if (cliRequest.workingDirectory == null) {
            cliRequest.workingDirectory = System.getProperty("user.dir");
        }
        if ((mavenHome = System.getProperty("maven.home")) != null) {
            System.setProperty("maven.home", new File(mavenHome).getAbsolutePath());
        }
    }

    private void cli(CliRequest cliRequest) throws Exception {
        this.slf4jLogger = new Slf4jStdoutLogger();
        CLIManager cliManager = new CLIManager();
        try {
            cliRequest.commandLine = cliManager.parse(cliRequest.args);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp(System.out);
            throw e;
        }
        if (cliRequest.commandLine.hasOption('h')) {
            cliManager.displayHelp(System.out);
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption('v')) {
            System.out.println(CLIReportingUtils.showVersion());
            throw new ExitException(0);
        }
    }

    private void logging(CliRequest cliRequest) {
        cliRequest.debug = cliRequest.commandLine.hasOption('X');
        cliRequest.quiet = !cliRequest.debug && cliRequest.commandLine.hasOption('q');
        cliRequest.showErrors = cliRequest.debug || cliRequest.commandLine.hasOption('e');
        this.slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        Slf4jConfiguration slf4jConfiguration = Slf4jConfigurationFactory.getConfiguration(this.slf4jLoggerFactory);
        if (cliRequest.debug) {
            cliRequest.request.setLoggingLevel(0);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.DEBUG);
        } else if (cliRequest.quiet) {
            cliRequest.request.setLoggingLevel(3);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.ERROR);
        }
        if (cliRequest.commandLine.hasOption("l")) {
            File logFile = new File(cliRequest.commandLine.getOptionValue("l"));
            logFile = MavenCli.resolveFile(logFile, cliRequest.workingDirectory);
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(logFile));
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        slf4jConfiguration.activate();
        this.plexusLoggerManager = new Slf4jLoggerManager();
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
    }

    private void version(CliRequest cliRequest) {
        if (cliRequest.debug || cliRequest.commandLine.hasOption('V')) {
            System.out.println(CLIReportingUtils.showVersion());
        }
    }

    private void commands(CliRequest cliRequest) {
        if (cliRequest.showErrors) {
            this.slf4jLogger.info("Error stacktraces are turned on.");
        }
        if ("warn".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if ("fail".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Enabling strict checksum verification on all artifact downloads.");
        }
    }

    private void properties(CliRequest cliRequest) {
        MavenCli.populateProperties(cliRequest.commandLine, cliRequest.systemProperties, cliRequest.userProperties);
    }

    private PlexusContainer container(CliRequest cliRequest) throws Exception {
        if (cliRequest.classWorld == null) {
            cliRequest.classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        }
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(cliRequest.classWorld).setRealm(this.setupContainerRealm(cliRequest)).setClassPathScanning("index").setAutoWiring(true).setName("maven");
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)MavenCli.this.slf4jLoggerFactory);
            }
        }});
        container.setLookupRealm(null);
        container.setLoggerManager(this.plexusLoggerManager);
        this.customizeContainer((PlexusContainer)container);
        container.getLoggerManager().setThresholds(cliRequest.request.getLoggingLevel());
        Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
        this.eventSpyDispatcher = (EventSpyDispatcher)container.lookup(EventSpyDispatcher.class);
        DefaultEventSpyContext eventSpyContext = new DefaultEventSpyContext();
        Map<String, Object> data = eventSpyContext.getData();
        data.put("plexus", container);
        data.put("workingDirectory", cliRequest.workingDirectory);
        data.put("systemProperties", cliRequest.systemProperties);
        data.put("userProperties", cliRequest.userProperties);
        data.put("versionProperties", CLIReportingUtils.getBuildProperties());
        this.eventSpyDispatcher.init((EventSpy.Context)eventSpyContext);
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
        this.maven = (Maven)container.lookup(Maven.class);
        this.executionRequestPopulator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
        this.modelProcessor = this.createModelProcessor((PlexusContainer)container);
        this.settingsBuilder = (SettingsBuilder)container.lookup(SettingsBuilder.class);
        this.dispatcher = (DefaultSecDispatcher)container.lookup(SecDispatcher.class, "maven");
        return container;
    }

    private ClassRealm setupContainerRealm(CliRequest cliRequest) throws Exception {
        String[] jars;
        ClassRealm containerRealm = null;
        String extClassPath = cliRequest.userProperties.getProperty(EXT_CLASS_PATH);
        if (extClassPath == null) {
            extClassPath = cliRequest.systemProperties.getProperty(EXT_CLASS_PATH);
        }
        if (StringUtils.isNotEmpty((String)extClassPath) && (jars = StringUtils.split((String)extClassPath, (String)File.pathSeparator)).length > 0) {
            ClassRealm coreRealm = cliRequest.classWorld.getClassRealm("plexus.core");
            if (coreRealm == null) {
                coreRealm = (ClassRealm)cliRequest.classWorld.getRealms().iterator().next();
            }
            ClassRealm extRealm = cliRequest.classWorld.newRealm("maven.ext", null);
            this.slf4jLogger.debug("Populating class realm " + extRealm.getId());
            for (String jar : jars) {
                File file = MavenCli.resolveFile(new File(jar), cliRequest.workingDirectory);
                this.slf4jLogger.debug("  Included " + file);
                extRealm.addURL(file.toURI().toURL());
            }
            extRealm.setParentRealm(coreRealm);
            containerRealm = extRealm;
        }
        return containerRealm;
    }

    private void encryption(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("emp")) {
            String passwd = cliRequest.commandLine.getOptionValue("emp");
            if (passwd == null) {
                char[] password;
                Console cons = System.console();
                char[] cArray = password = cons == null ? null : cons.readPassword("Master password: ", new Object[0]);
                if (password != null) {
                    passwd = String.copyValueOf(password);
                    Arrays.fill(password, ' ');
                }
            }
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            System.out.println(cipher.encryptAndDecorate(passwd, "settings.security"));
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption("ep")) {
            String configurationFile;
            String passwd = cliRequest.commandLine.getOptionValue("ep");
            if (passwd == null) {
                char[] password;
                Console cons = System.console();
                char[] cArray = password = cons == null ? null : cons.readPassword("Password: ", new Object[0]);
                if (password != null) {
                    passwd = String.copyValueOf(password);
                    Arrays.fill(password, ' ');
                }
            }
            if ((configurationFile = this.dispatcher.getConfigurationFile()).startsWith("~")) {
                configurationFile = System.getProperty("user.home") + configurationFile.substring(1);
            }
            String file = System.getProperty("settings.security", configurationFile);
            String master = null;
            SettingsSecurity sec = SecUtil.read((String)file, (boolean)true);
            if (sec != null) {
                master = sec.getMaster();
            }
            if (master == null) {
                throw new IllegalStateException("Master password is not set in the setting security file: " + file);
            }
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            String masterPasswd = cipher.decryptDecorated(master, "settings.security");
            System.out.println(cipher.encryptAndDecorate(passwd, masterPasswd));
            throw new ExitException(0);
        }
    }

    private void repository(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("llr") || Boolean.getBoolean("maven.legacyLocalRepo")) {
            cliRequest.request.setUseLegacyLocalRepository(true);
        }
    }

    private int execute(CliRequest cliRequest) {
        this.eventSpyDispatcher.onEvent((Object)cliRequest.request);
        MavenExecutionResult result = this.maven.execute(cliRequest.request);
        this.eventSpyDispatcher.onEvent((Object)result);
        this.eventSpyDispatcher.close();
        if (result.hasExceptions()) {
            DefaultExceptionHandler handler = new DefaultExceptionHandler();
            LinkedHashMap<String, String> references = new LinkedHashMap<String, String>();
            MavenProject project = null;
            for (Throwable throwable : result.getExceptions()) {
                ExceptionSummary summary = handler.handleException(throwable);
                this.logSummary(summary, references, "", cliRequest.showErrors);
                if (project != null || !(throwable instanceof LifecycleExecutionException)) continue;
                project = ((LifecycleExecutionException)throwable).getProject();
            }
            this.slf4jLogger.error("");
            if (!cliRequest.showErrors) {
                this.slf4jLogger.error("To see the full stack trace of the errors, re-run Maven with the -e switch.");
            }
            if (!this.slf4jLogger.isDebugEnabled()) {
                this.slf4jLogger.error("Re-run Maven using the -X switch to enable full debug logging.");
            }
            if (!references.isEmpty()) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("For more information about the errors and possible solutions, please read the following articles:");
                for (Map.Entry entry : references.entrySet()) {
                    this.slf4jLogger.error((String)entry.getValue() + " " + (String)entry.getKey());
                }
            }
            if (project != null && !project.equals(result.getTopologicallySortedProjects().get(0))) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("After correcting the problems, you can resume the build with the command");
                this.slf4jLogger.error("  mvn <goals> -rf :" + project.getArtifactId());
            }
            if ("FAIL_NEVER".equals(cliRequest.request.getReactorFailureBehavior())) {
                this.slf4jLogger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private void logSummary(ExceptionSummary summary, Map<String, String> references, String indent, boolean showErrors) {
        String referenceKey = "";
        if (StringUtils.isNotEmpty((String)summary.getReference()) && (referenceKey = references.get(summary.getReference())) == null) {
            referenceKey = "[Help " + (references.size() + 1) + "]";
            references.put(summary.getReference(), referenceKey);
        }
        String msg = summary.getMessage();
        if (StringUtils.isNotEmpty((String)referenceKey)) {
            msg = msg.indexOf(10) < 0 ? msg + " -> " + referenceKey : msg + "\n-> " + referenceKey;
        }
        String[] lines = msg.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < lines.length; ++i) {
            String line = indent + lines[i].trim();
            if (i == lines.length - 1 && (showErrors || summary.getException() instanceof InternalErrorException)) {
                this.slf4jLogger.error(line, summary.getException());
                continue;
            }
            this.slf4jLogger.error(line);
        }
        indent = indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(child, references, indent, showErrors);
        }
    }

    private void settings(CliRequest cliRequest) throws Exception {
        File globalSettingsFile;
        File userSettingsFile;
        if (cliRequest.commandLine.hasOption('s')) {
            userSettingsFile = new File(cliRequest.commandLine.getOptionValue('s'));
            if (!(userSettingsFile = MavenCli.resolveFile(userSettingsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user settings file does not exist: " + userSettingsFile);
            }
        } else {
            userSettingsFile = DEFAULT_USER_SETTINGS_FILE;
        }
        if (cliRequest.commandLine.hasOption("gs")) {
            globalSettingsFile = new File(cliRequest.commandLine.getOptionValue("gs"));
            if (!(globalSettingsFile = MavenCli.resolveFile(globalSettingsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global settings file does not exist: " + globalSettingsFile);
            }
        } else {
            globalSettingsFile = DEFAULT_GLOBAL_SETTINGS_FILE;
        }
        cliRequest.request.setGlobalSettingsFile(globalSettingsFile);
        cliRequest.request.setUserSettingsFile(userSettingsFile);
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(globalSettingsFile);
        settingsRequest.setUserSettingsFile(userSettingsFile);
        settingsRequest.setSystemProperties(cliRequest.systemProperties);
        settingsRequest.setUserProperties(cliRequest.userProperties);
        this.eventSpyDispatcher.onEvent((Object)settingsRequest);
        this.slf4jLogger.debug("Reading global settings from " + this.getSettingsLocation(settingsRequest.getGlobalSettingsSource(), settingsRequest.getGlobalSettingsFile()));
        this.slf4jLogger.debug("Reading user settings from " + this.getSettingsLocation(settingsRequest.getUserSettingsSource(), settingsRequest.getUserSettingsFile()));
        SettingsBuildingResult settingsResult = this.settingsBuilder.build((SettingsBuildingRequest)settingsRequest);
        this.eventSpyDispatcher.onEvent((Object)settingsResult);
        this.executionRequestPopulator.populateFromSettings(cliRequest.request, settingsResult.getEffectiveSettings());
        if (!settingsResult.getProblems().isEmpty() && this.slf4jLogger.isWarnEnabled()) {
            this.slf4jLogger.warn("");
            this.slf4jLogger.warn("Some problems were encountered while building the effective settings");
            for (SettingsProblem problem : settingsResult.getProblems()) {
                this.slf4jLogger.warn(problem.getMessage() + " @ " + problem.getLocation());
            }
            this.slf4jLogger.warn("");
        }
    }

    private Object getSettingsLocation(SettingsSource source, File file) {
        if (source != null) {
            return source.getLocation();
        }
        return file;
    }

    private MavenExecutionRequest populateRequest(CliRequest cliRequest) {
        String threadConfiguration;
        File pom;
        File userToolchainsFile;
        String[] profileOptionValues;
        String[] deprecatedOptions;
        MavenExecutionRequest request = cliRequest.request;
        CommandLine commandLine = cliRequest.commandLine;
        String workingDirectory = cliRequest.workingDirectory;
        boolean quiet = cliRequest.quiet;
        boolean showErrors = cliRequest.showErrors;
        for (String deprecatedOption : deprecatedOptions = new String[]{"up", "npu", "cpu", "npr"}) {
            if (!commandLine.hasOption(deprecatedOption)) continue;
            this.slf4jLogger.warn("Command line option -" + deprecatedOption + " is deprecated and will be removed in future Maven versions.");
        }
        if (commandLine.hasOption('B')) {
            request.setInteractiveMode(false);
        }
        boolean noSnapshotUpdates = false;
        if (commandLine.hasOption("nsu")) {
            noSnapshotUpdates = true;
        }
        List goals = commandLine.getArgList();
        boolean recursive = true;
        String reactorFailureBehaviour = "FAIL_FAST";
        if (commandLine.hasOption('N')) {
            recursive = false;
        }
        if (commandLine.hasOption("ff")) {
            reactorFailureBehaviour = "FAIL_FAST";
        } else if (commandLine.hasOption("fae")) {
            reactorFailureBehaviour = "FAIL_AT_END";
        } else if (commandLine.hasOption("fn")) {
            reactorFailureBehaviour = "FAIL_NEVER";
        }
        if (commandLine.hasOption('o')) {
            request.setOffline(true);
        }
        boolean updateSnapshots = false;
        if (commandLine.hasOption('U')) {
            updateSnapshots = true;
        }
        String globalChecksumPolicy = null;
        if (commandLine.hasOption('C')) {
            globalChecksumPolicy = "fail";
        } else if (commandLine.hasOption('c')) {
            globalChecksumPolicy = "warn";
        }
        File baseDirectory = new File(workingDirectory, "").getAbsoluteFile();
        ArrayList<String> activeProfiles = new ArrayList<String>();
        ArrayList<String> inactiveProfiles = new ArrayList<String>();
        if (commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
            for (String profileOptionValue : profileOptionValues) {
                StringTokenizer profileTokens = new StringTokenizer(profileOptionValue, ",");
                while (profileTokens.hasMoreTokens()) {
                    String profileAction = profileTokens.nextToken().trim();
                    if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                        inactiveProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    if (profileAction.startsWith("+")) {
                        activeProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    activeProfiles.add(profileAction);
                }
            }
        }
        QuietMavenTransferListener transferListener = quiet ? new QuietMavenTransferListener() : (request.isInteractiveMode() && !cliRequest.commandLine.hasOption("l") ? this.getConsoleTransferListener() : this.getBatchTransferListener());
        ExecutionEventLogger executionListener = new ExecutionEventLogger();
        executionListener = this.eventSpyDispatcher.chainListener((ExecutionListener)executionListener);
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        if (commandLine.hasOption('t')) {
            userToolchainsFile = new File(commandLine.getOptionValue('t'));
            userToolchainsFile = MavenCli.resolveFile(userToolchainsFile, workingDirectory);
        } else {
            userToolchainsFile = DEFAULT_USER_TOOLCHAINS_FILE;
        }
        request.setBaseDirectory(baseDirectory).setGoals(goals).setSystemProperties(cliRequest.systemProperties).setUserProperties(cliRequest.userProperties).setReactorFailureBehavior(reactorFailureBehaviour).setRecursive(recursive).setShowErrors(showErrors).addActiveProfiles(activeProfiles).addInactiveProfiles(inactiveProfiles).setExecutionListener((ExecutionListener)executionListener).setTransferListener((TransferListener)transferListener).setUpdateSnapshots(updateSnapshots).setNoSnapshotUpdates(noSnapshotUpdates).setGlobalChecksumPolicy(globalChecksumPolicy).setUserToolchainsFile(userToolchainsFile);
        if (alternatePomFile != null) {
            pom = MavenCli.resolveFile(new File(alternatePomFile), workingDirectory);
            if (pom.isDirectory()) {
                pom = new File(pom, "pom.xml");
            }
            request.setPom(pom);
        } else {
            pom = this.modelProcessor.locatePom(baseDirectory);
            if (pom.isFile()) {
                request.setPom(pom);
            }
        }
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        }
        if (commandLine.hasOption("rf")) {
            request.setResumeFrom(commandLine.getOptionValue("rf"));
        }
        if (commandLine.hasOption("pl")) {
            String[] projectOptionValues = commandLine.getOptionValues("pl");
            ArrayList<String> inclProjects = new ArrayList<String>();
            ArrayList<String> exclProjects = new ArrayList<String>();
            if (projectOptionValues != null) {
                for (String projectOptionValue : projectOptionValues) {
                    StringTokenizer projectTokens = new StringTokenizer(projectOptionValue, ",");
                    while (projectTokens.hasMoreTokens()) {
                        String projectAction = projectTokens.nextToken().trim();
                        if (projectAction.startsWith("-") || projectAction.startsWith("!")) {
                            exclProjects.add(projectAction.substring(1));
                            continue;
                        }
                        if (projectAction.startsWith("+")) {
                            inclProjects.add(projectAction.substring(1));
                            continue;
                        }
                        inclProjects.add(projectAction);
                    }
                }
            }
            request.setSelectedProjects(inclProjects);
            request.setExcludedProjects(exclProjects);
        }
        if (commandLine.hasOption("am") && !commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-upstream");
        } else if (!commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-downstream");
        } else if (commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-both");
        }
        String localRepoProperty = request.getUserProperties().getProperty(LOCAL_REPO_PROPERTY);
        if (localRepoProperty == null) {
            localRepoProperty = request.getSystemProperties().getProperty(LOCAL_REPO_PROPERTY);
        }
        if (localRepoProperty != null) {
            request.setLocalRepositoryPath(localRepoProperty);
        }
        request.setCacheNotFound(true);
        request.setCacheTransferError(false);
        String string = threadConfiguration = commandLine.hasOption("T") ? commandLine.getOptionValue("T") : request.getSystemProperties().getProperty(THREADS_DEPRECATED);
        if (threadConfiguration != null) {
            request.setBuilderId("multithreaded");
            if (threadConfiguration.contains("C")) {
                request.setDegreeOfConcurrency(this.calculateDegreeOfConcurrencyWithCoreMultiplier(threadConfiguration));
            } else {
                request.setDegreeOfConcurrency(Integer.valueOf(threadConfiguration).intValue());
            }
        }
        if (commandLine.hasOption("b")) {
            request.setBuilderId(commandLine.getOptionValue("b"));
        }
        return request;
    }

    int calculateDegreeOfConcurrencyWithCoreMultiplier(String threadConfiguration) {
        int procs = Runtime.getRuntime().availableProcessors();
        return (int)(Float.valueOf(threadConfiguration.replace("C", "")).floatValue() * (float)procs);
    }

    static File resolveFile(File file, String workingDirectory) {
        if (file == null) {
            return null;
        }
        if (file.isAbsolute()) {
            return file;
        }
        if (file.getPath().startsWith(File.separator)) {
            return file.getAbsoluteFile();
        }
        return new File(workingDirectory, file.getPath()).getAbsoluteFile();
    }

    static void populateProperties(CommandLine commandLine, Properties systemProperties, Properties userProperties) {
        String[] defStrs;
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        if (commandLine.hasOption('D') && (defStrs = commandLine.getOptionValues('D')) != null) {
            for (String defStr : defStrs) {
                MavenCli.setCliProperty(defStr, userProperties);
            }
        }
        SystemProperties.addSystemProperties((Properties)systemProperties);
        Properties buildProperties = CLIReportingUtils.getBuildProperties();
        String mavenVersion = buildProperties.getProperty("version");
        systemProperties.setProperty("maven.version", mavenVersion);
        String mavenBuildVersion = CLIReportingUtils.createMavenVersionString(buildProperties);
        systemProperties.setProperty("maven.build.version", mavenBuildVersion);
    }

    private static void setCliProperty(String property, Properties properties) {
        String value;
        String name;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1);
        }
        properties.setProperty(name, value);
        System.setProperty(name, value);
    }

    protected TransferListener getConsoleTransferListener() {
        return new ConsoleMavenTransferListener(System.out);
    }

    protected TransferListener getBatchTransferListener() {
        return new Slf4jMavenTransferListener();
    }

    protected void customizeContainer(PlexusContainer container) {
    }

    protected ModelProcessor createModelProcessor(PlexusContainer container) throws ComponentLookupException {
        return (ModelProcessor)container.lookup(ModelProcessor.class);
    }

    static class ExitException
    extends Exception {
        public int exitCode;

        public ExitException(int exitCode) {
            this.exitCode = exitCode;
        }
    }

    static class CliRequest {
        String[] args;
        CommandLine commandLine;
        ClassWorld classWorld;
        String workingDirectory;
        boolean debug;
        boolean quiet;
        boolean showErrors = true;
        Properties userProperties = new Properties();
        Properties systemProperties = new Properties();
        MavenExecutionRequest request;

        CliRequest(String[] args, ClassWorld classWorld) {
            this.args = args;
            this.classWorld = classWorld;
            this.request = new DefaultMavenExecutionRequest();
        }
    }
}

