/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.resource.adapter.jms.JmsManagedConnection;

public class JmsXAResource
implements XAResource {
    private JmsManagedConnection managedConnection;
    private XAResource xaResource;

    public JmsXAResource(JmsManagedConnection managedConnection, XAResource xaResource) {
        this.managedConnection = managedConnection;
        this.xaResource = xaResource;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.managedConnection.lock();
        try {
            this.xaResource.start(xid, flags);
        }
        finally {
            this.managedConnection.unlock();
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.managedConnection.lock();
        try {
            this.xaResource.end(xid, flags);
        }
        finally {
            this.managedConnection.unlock();
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.managedConnection.lock();
        try {
            int n = this.xaResource.prepare(xid);
            return n;
        }
        finally {
            this.managedConnection.unlock();
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.managedConnection.lock();
        try {
            this.xaResource.commit(xid, onePhase);
        }
        finally {
            this.managedConnection.unlock();
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.managedConnection.lock();
        try {
            this.xaResource.rollback(xid);
        }
        finally {
            this.managedConnection.unlock();
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.managedConnection.lock();
        try {
            this.xaResource.forget(xid);
        }
        finally {
            this.managedConnection.unlock();
        }
    }

    public XAResource getUnderlyingXAResource() {
        return this.xaResource;
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (xaRes instanceof JmsXAResource) {
            xaRes = ((JmsXAResource)xaRes).getUnderlyingXAResource();
        }
        return this.xaResource.isSameRM(xaRes);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaResource.setTransactionTimeout(seconds);
    }
}

