/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.asn;

import java.io.IOException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.cryptacular.asn.ASN1Decoder;
import org.cryptacular.util.PemUtil;

public class PublicKeyDecoder
implements ASN1Decoder<AsymmetricKeyParameter> {
    @Override
    public AsymmetricKeyParameter decode(byte[] encoded, Object ... args) {
        try {
            if (PemUtil.isPem(encoded)) {
                return PublicKeyFactory.createKey((byte[])PemUtil.decode(encoded));
            }
            return PublicKeyFactory.createKey((byte[])encoded);
        }
        catch (IOException e) {
            throw new RuntimeException("ASN.1 decoding error", e);
        }
    }
}

