/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.HashUtil;
import org.jboss.as.repository.logging.DeploymentRepositoryLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public interface ContentRepository {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"content-repository"});
    public static final long OBSOLETE_CONTENT_TIMEOUT = System.getSecurityManager() == null ? Long.getLong("org.wildfly.unsupported.content.repository.obsolescence", 300000L).longValue() : AccessController.doPrivileged(() -> Long.getLong("org.wildfly.unsupported.content.repository.obsolescence", 300000L)).longValue();
    public static final String DELETED_CONTENT = "deleted-contents";
    public static final String MARKED_CONTENT = "marked-contents";

    public byte[] addContent(InputStream var1) throws IOException;

    public void addContentReference(ContentReference var1);

    public VirtualFile getContent(byte[] var1);

    public boolean hasContent(byte[] var1);

    public boolean syncContent(ContentReference var1);

    public void removeContent(ContentReference var1);

    public Map<String, Set<String>> cleanObsoleteContent();

    public static class Factory {
        @Deprecated
        private static final String UNSUPPORTED_PROPERTY = "org.wildfly.unsupported.content.repository.obsolescence";

        public static void addService(ServiceTarget serviceTarget, File repoRoot) {
            ContentRepositoryImpl contentRepository = new ContentRepositoryImpl(repoRoot, OBSOLETE_CONTENT_TIMEOUT);
            serviceTarget.addService(SERVICE_NAME, (Service)contentRepository).install();
        }

        public static ContentRepository create(File repoRoot) {
            return Factory.create(repoRoot, OBSOLETE_CONTENT_TIMEOUT);
        }

        static ContentRepository create(File repoRoot, long timeout) {
            return new ContentRepositoryImpl(repoRoot, timeout);
        }

        private static class ContentRepositoryImpl
        implements ContentRepository,
        Service<ContentRepository> {
            protected static final String CONTENT = "content";
            private final File repoRoot;
            protected final MessageDigest messageDigest;
            private final Map<String, Set<ContentReference>> contentHashReferences = new HashMap<String, Set<ContentReference>>();
            private final Map<String, Long> obsoleteContents = new HashMap<String, Long>();
            private final long obsolescenceTimeout;

            protected ContentRepositoryImpl(File repoRoot, long obsolescenceTimeout) {
                if (repoRoot == null) {
                    throw DeploymentRepositoryLogger.ROOT_LOGGER.nullVar("repoRoot");
                }
                if (repoRoot.exists()) {
                    if (!repoRoot.isDirectory()) {
                        throw DeploymentRepositoryLogger.ROOT_LOGGER.notADirectory(repoRoot.getAbsolutePath());
                    }
                    if (!repoRoot.canWrite()) {
                        throw DeploymentRepositoryLogger.ROOT_LOGGER.directoryNotWritable(repoRoot.getAbsolutePath());
                    }
                } else if (!repoRoot.mkdirs()) {
                    throw DeploymentRepositoryLogger.ROOT_LOGGER.cannotCreateDirectory(null, repoRoot.getAbsolutePath());
                }
                this.repoRoot = repoRoot;
                this.obsolescenceTimeout = obsolescenceTimeout;
                try {
                    this.messageDigest = MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException e) {
                    throw DeploymentRepositoryLogger.ROOT_LOGGER.cannotObtainSha1(e, MessageDigest.class.getSimpleName());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] addContent(InputStream stream) throws IOException {
                byte[] sha1Bytes;
                Path tmp = Files.createTempFile(this.repoRoot.toPath(), CONTENT, ".tmp", new FileAttribute[0]);
                OutputStream fos = Files.newOutputStream(tmp, new OpenOption[0]);
                MessageDigest messageDigest = this.messageDigest;
                synchronized (messageDigest) {
                    this.messageDigest.reset();
                    try {
                        int read;
                        DigestOutputStream dos = new DigestOutputStream(fos, this.messageDigest);
                        BufferedInputStream bis = new BufferedInputStream(stream);
                        byte[] bytes = new byte[8192];
                        while ((read = bis.read(bytes)) > -1) {
                            dos.write(bytes, 0, read);
                        }
                        fos.flush();
                        fos.close();
                        fos = null;
                    }
                    finally {
                        ContentRepositoryImpl.safeClose(fos);
                    }
                    sha1Bytes = this.messageDigest.digest();
                }
                Path realFile = this.getDeploymentContentFile(sha1Bytes, true);
                if (this.hasContent(sha1Bytes)) {
                    try {
                        Files.deleteIfExists(tmp);
                    }
                    catch (IOException ioex) {
                        DeploymentRepositoryLogger.ROOT_LOGGER.cannotDeleteTempFile(ioex, tmp.toAbsolutePath().toString());
                        tmp.toFile().deleteOnExit();
                    }
                    DeploymentRepositoryLogger.ROOT_LOGGER.debugf("Content was already present in repository at location %s", realFile.toAbsolutePath().toString());
                } else {
                    this.moveTempToPermanent(tmp, realFile);
                    DeploymentRepositoryLogger.ROOT_LOGGER.contentAdded(realFile.toAbsolutePath().toString());
                }
                return sha1Bytes;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addContentReference(ContentReference reference) {
                Map<String, Set<ContentReference>> map = this.contentHashReferences;
                synchronized (map) {
                    Set<ContentReference> references = this.contentHashReferences.get(reference.getHexHash());
                    if (references == null) {
                        references = new HashSet<ContentReference>();
                        this.contentHashReferences.put(reference.getHexHash(), references);
                    }
                    references.add(reference);
                }
            }

            @Override
            public VirtualFile getContent(byte[] hash) {
                if (hash == null) {
                    throw DeploymentRepositoryLogger.ROOT_LOGGER.nullVar("hash");
                }
                return VFS.getChild((URI)this.getDeploymentContentFile(hash, true).toUri());
            }

            @Override
            public boolean syncContent(ContentReference reference) {
                return this.hasContent(reference.getHash());
            }

            @Override
            public boolean hasContent(byte[] hash) {
                return Files.exists(this.getDeploymentContentFile(hash), new LinkOption[0]);
            }

            protected Path getRepoRoot() {
                return this.repoRoot.toPath();
            }

            protected Path getDeploymentContentFile(byte[] deploymentHash) {
                return this.getDeploymentContentFile(deploymentHash, false);
            }

            private Path getDeploymentContentFile(byte[] deploymentHash, boolean validate) {
                return this.getDeploymentHashDir(deploymentHash, validate).resolve(CONTENT);
            }

            protected Path getDeploymentHashDir(byte[] deploymentHash, boolean validate) {
                String sha1 = HashUtil.bytesToHexString(deploymentHash);
                String partA = sha1.substring(0, 2);
                String partB = sha1.substring(2);
                Path base = this.getRepoRoot().resolve(partA);
                if (validate) {
                    this.validateDir(base);
                }
                Path hashDir = base.resolve(partB);
                if (validate && !Files.exists(hashDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(hashDir, new FileAttribute[0]);
                    }
                    catch (IOException ioex) {
                        throw DeploymentRepositoryLogger.ROOT_LOGGER.cannotCreateDirectory(ioex, hashDir.toAbsolutePath().toString());
                    }
                }
                return hashDir;
            }

            protected void validateDir(Path dir) {
                if (!Files.exists(dir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(dir, new FileAttribute[0]);
                    }
                    catch (IOException ioex) {
                        throw DeploymentRepositoryLogger.ROOT_LOGGER.cannotCreateDirectory(ioex, dir.toAbsolutePath().toString());
                    }
                } else {
                    if (!Files.isDirectory(dir, new LinkOption[0])) {
                        throw DeploymentRepositoryLogger.ROOT_LOGGER.notADirectory(dir.toAbsolutePath().toString());
                    }
                    if (!dir.toFile().canWrite()) {
                        throw DeploymentRepositoryLogger.ROOT_LOGGER.directoryNotWritable(dir.toAbsolutePath().toString());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void moveTempToPermanent(Path tmpFile, Path permanentFile) throws IOException {
                Path localTmp = permanentFile.resolveSibling("tmp");
                try {
                    Files.move(tmpFile, permanentFile, new CopyOption[0]);
                }
                catch (IOException ioex) {
                    Files.copy(tmpFile, localTmp, new CopyOption[0]);
                    try {
                        Files.move(localTmp, permanentFile, new CopyOption[0]);
                    }
                    catch (IOException ex) {
                        try {
                            Files.copy(localTmp, permanentFile, new CopyOption[0]);
                        }
                        catch (IOException e) {
                            Files.deleteIfExists(permanentFile);
                            throw e;
                        }
                    }
                }
                finally {
                    try {
                        Files.deleteIfExists(tmpFile);
                    }
                    catch (IOException ioex) {
                        DeploymentRepositoryLogger.ROOT_LOGGER.cannotDeleteTempFile(ioex, tmpFile.toString());
                        tmpFile.toFile().deleteOnExit();
                    }
                    try {
                        Files.deleteIfExists(localTmp);
                    }
                    catch (IOException ioex) {
                        DeploymentRepositoryLogger.ROOT_LOGGER.cannotDeleteTempFile(ioex, localTmp.toString());
                        localTmp.toFile().deleteOnExit();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeContent(ContentReference reference) {
                Path file;
                Map<String, Set<ContentReference>> map = this.contentHashReferences;
                synchronized (map) {
                    Set<ContentReference> references = this.contentHashReferences.get(reference.getHexHash());
                    if (references != null) {
                        references.remove(reference);
                        if (!references.isEmpty()) {
                            return;
                        }
                        this.contentHashReferences.remove(reference.getHexHash());
                    }
                }
                if (!HashUtil.isEachHexHashInTable(reference.getHexHash())) {
                    String identifier = reference.getContentIdentifier();
                    file = Paths.get(identifier, new String[0]);
                } else {
                    file = this.getDeploymentContentFile(reference.getHash(), true);
                }
                try {
                    Files.deleteIfExists(file);
                }
                catch (IOException ex) {
                    DeploymentRepositoryLogger.ROOT_LOGGER.contentDeletionError(ex, file.toString());
                }
                Path parent = file.getParent();
                try {
                    Files.deleteIfExists(parent);
                }
                catch (IOException ex) {
                    DeploymentRepositoryLogger.ROOT_LOGGER.contentDeletionError(ex, parent.toString());
                }
                Path grandParent = parent.getParent();
                try (Stream<Path> files = Files.list(grandParent);){
                    if (!files.findAny().isPresent()) {
                        Files.deleteIfExists(grandParent);
                    }
                }
                catch (IOException ex) {
                    DeploymentRepositoryLogger.ROOT_LOGGER.contentDeletionError(ex, grandParent.toString());
                }
                DeploymentRepositoryLogger.ROOT_LOGGER.contentRemoved(file.toAbsolutePath().toString());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, Set<String>> cleanObsoleteContent() {
                HashMap<String, Set<String>> cleanedContents = new HashMap<String, Set<String>>(2);
                cleanedContents.put(ContentRepository.MARKED_CONTENT, new HashSet());
                cleanedContents.put(ContentRepository.DELETED_CONTENT, new HashSet());
                Map<String, Set<ContentReference>> map = this.contentHashReferences;
                synchronized (map) {
                    for (ContentReference fsContent : this.listLocalContents()) {
                        if (!this.contentHashReferences.containsKey(fsContent.getHexHash())) {
                            if (this.markAsObsolete(fsContent)) {
                                ((Set)cleanedContents.get(ContentRepository.DELETED_CONTENT)).add(fsContent.getContentIdentifier());
                                continue;
                            }
                            ((Set)cleanedContents.get(ContentRepository.MARKED_CONTENT)).add(fsContent.getContentIdentifier());
                            continue;
                        }
                        this.obsoleteContents.remove(fsContent.getHexHash());
                    }
                }
                return cleanedContents;
            }

            private boolean markAsObsolete(ContentReference ref) {
                if (this.obsoleteContents.containsKey(ref.getHexHash())) {
                    if (this.obsoleteContents.get(ref.getHexHash()) + this.obsolescenceTimeout < System.currentTimeMillis()) {
                        DeploymentRepositoryLogger.ROOT_LOGGER.obsoleteContentCleaned(ref.getContentIdentifier());
                        this.removeContent(ref);
                        return true;
                    }
                } else {
                    this.obsoleteContents.put(ref.getHexHash(), System.currentTimeMillis());
                }
                return false;
            }

            private Set<ContentReference> listLocalContents() {
                HashSet<ContentReference> localReferences = new HashSet<ContentReference>();
                File[] rootHashes = this.repoRoot.listFiles();
                if (rootHashes != null) {
                    for (File rootHash : rootHashes) {
                        if (!rootHash.isDirectory()) continue;
                        File[] complementaryHashes = rootHash.listFiles();
                        if (complementaryHashes == null || complementaryHashes.length == 0) {
                            ContentReference reference = new ContentReference(rootHash.getAbsolutePath(), rootHash.getName());
                            localReferences.add(reference);
                            continue;
                        }
                        for (File complementaryHash : complementaryHashes) {
                            String hash = rootHash.getName() + complementaryHash.getName();
                            ContentReference reference = new ContentReference(complementaryHash.getAbsolutePath(), hash);
                            localReferences.add(reference);
                        }
                    }
                } else {
                    DeploymentRepositoryLogger.ROOT_LOGGER.localContentListError(this.repoRoot.getAbsolutePath());
                }
                return localReferences;
            }

            protected static void safeClose(Closeable closeable) {
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            public void start(StartContext context) throws StartException {
                DeploymentRepositoryLogger.ROOT_LOGGER.debugf("%s started", ContentRepository.class.getSimpleName());
            }

            public void stop(StopContext context) {
                DeploymentRepositoryLogger.ROOT_LOGGER.debugf("%s stopped", ContentRepository.class.getSimpleName());
            }

            public ContentRepository getValue() throws IllegalStateException, IllegalArgumentException {
                return this;
            }
        }
    }
}

