/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.metacommand;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.component.CLIOutput;
import org.jboss.as.cli.gui.component.ScriptMenu;
import org.jboss.as.protocol.StreamUtils;

public abstract class ScriptAction
extends AbstractAction {
    protected CliGuiContext cliGuiCtx;
    private CLIOutput output;
    private ScriptMenu menu;

    public ScriptAction(ScriptMenu menu, String name, CliGuiContext cliGuiCtx) {
        super(name);
        this.cliGuiCtx = cliGuiCtx;
        this.menu = menu;
        this.output = cliGuiCtx.getOutput();
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    protected void runScript(File script) {
        if (!script.exists()) {
            JOptionPane.showMessageDialog(this.cliGuiCtx.getMainPanel(), script.getAbsolutePath() + " does not exist.", "Unable to run script.", 0);
            return;
        }
        int choice = JOptionPane.showConfirmDialog(this.cliGuiCtx.getMainPanel(), "Run CLI script " + script.getName() + "?", "Confirm run script", 0);
        if (choice != 0) {
            return;
        }
        this.menu.addScript(script);
        this.cliGuiCtx.getTabs().setSelectedIndex(1);
        this.output.post("\n");
        ScriptRunner scriptRunner = new ScriptRunner(script);
        scriptRunner.execute();
    }

    private List<String> getCommandLines(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        catch (Throwable e) {
            try {
                throw new IllegalStateException("Failed to process file " + file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(reader);
                throw throwable;
            }
        }
        StreamUtils.safeClose((Closeable)reader);
        return lines;
    }

    protected class ScriptRunner
    extends SwingWorker<Object, OutMessage> {
        private File file;
        private int caretPosition = 0;

        private ScriptRunner(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object doInBackground() throws Exception {
            ByteArrayOutputStream scriptOut = new ByteArrayOutputStream();
            PrintStream printOut = new PrintStream(scriptOut);
            try {
                ScriptAction.this.cliGuiCtx.getCommmandContext().captureOutput(printOut);
                ScriptAction.this.cliGuiCtx.getCommandLine().setEnabled(false);
                this.publish(new OutMessage(">>> Execute CLI script " + this.file, true));
                boolean failure = false;
                for (String command : ScriptAction.this.getCommandLines(this.file)) {
                    this.publish(new OutMessage(command, true));
                    try {
                        ScriptAction.this.cliGuiCtx.getCommmandContext().handle(command.trim());
                    }
                    catch (Throwable t) {
                        t.printStackTrace(printOut);
                        failure = true;
                    }
                    if (scriptOut.size() > 0) {
                        this.publish(new OutMessage(scriptOut.toString(), false));
                        scriptOut.reset();
                    }
                    if (!failure) continue;
                    this.publish(new OutMessage(">> Command Failed:  " + command, true));
                    break;
                }
                this.publish(new OutMessage(">>> Script complete.", true));
            }
            finally {
                ScriptAction.this.cliGuiCtx.getCommmandContext().releaseOutput();
                ScriptAction.this.cliGuiCtx.getCommandLine().setEnabled(true);
                ScriptAction.this.cliGuiCtx.getCommmandContext().handle("cd /");
            }
            return null;
        }

        @Override
        protected void process(List<OutMessage> messages) {
            for (OutMessage msg : messages) {
                if (msg.isBold) {
                    this.caretPosition = ScriptAction.this.output.postBoldAt(msg.message + "\n", this.caretPosition);
                    continue;
                }
                this.caretPosition = ScriptAction.this.output.postAt(msg.message + "\n", this.caretPosition);
            }
        }
    }

    private class OutMessage {
        private boolean isBold;
        private String message;

        OutMessage(String message, boolean isBold) {
            this.message = message;
            this.isBold = isBold;
        }
    }
}

