/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery.impl;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.common.Assert;
import org.wildfly.discovery.AggregateServiceRegistration;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceRegistration;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;
import org.wildfly.discovery.spi.RegistryProvider;

public final class LocalRegistryAndDiscoveryProvider
implements RegistryProvider,
DiscoveryProvider {
    private final CopyOnWriteArrayList<Handle> handles = new CopyOnWriteArrayList();
    private static final long stamp = System.nanoTime();

    @Override
    public ServiceRegistration registerService(ServiceURL serviceURL) {
        Assert.checkNotNullParam((String)"serviceURL", (Object)serviceURL);
        Handle handle = new Handle(serviceURL, true);
        this.handles.add(handle);
        return handle;
    }

    @Override
    public ServiceRegistration registerServices(ServiceURL ... serviceURLs) {
        Assert.checkNotNullParam((String)"serviceURLs", (Object)serviceURLs);
        Handle[] array = new Handle[serviceURLs.length];
        for (int i = 0; i < serviceURLs.length; ++i) {
            ServiceURL serviceURL = serviceURLs[i];
            array[i] = new Handle(serviceURL, false);
        }
        List<Handle> list = Arrays.asList(array);
        this.handles.addAll(list);
        return new AggregateHandle(list, array);
    }

    @Override
    public DiscoveryRequest discover(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult result) {
        for (Handle handle : this.handles) {
            ServiceURL serviceURL;
            if (!handle.isOpenAndActive() || !serviceType.implies(serviceURL = handle.getServiceURL()) || !serviceURL.satisfies(filterSpec)) continue;
            result.addMatch(serviceURL);
        }
        result.complete();
        return DiscoveryRequest.NULL;
    }

    static long nowMicros() {
        return Math.max(0L, (System.nanoTime() - stamp >>> 1) / 500L);
    }

    final class Handle
    implements ServiceRegistration {
        private static final int FLAG_CLOSED = 1;
        private static final int FLAG_DEACTIVATED = 2;
        private final AtomicInteger state = new AtomicInteger(0);
        private final ServiceURL serviceURL;
        private final boolean remove;

        Handle(ServiceURL serviceURL, boolean remove) {
            this.serviceURL = serviceURL;
            this.remove = remove;
        }

        @Override
        public void close() {
            if (this.remove) {
                LocalRegistryAndDiscoveryProvider.this.handles.remove(this);
            }
            this.state.set(1);
        }

        @Override
        public void deactivate() {
            int oldVal;
            AtomicInteger state = this.state;
            do {
                if ((long)((oldVal = state.get()) & 3) == 0L) continue;
                return;
            } while (!state.compareAndSet(oldVal, 2));
        }

        @Override
        public void activate() {
            int oldVal;
            AtomicInteger state = this.state;
            do {
                if (((oldVal = state.get()) & 1) != 0) {
                    return;
                }
                if (oldVal != 0) continue;
                return;
            } while (!state.compareAndSet(oldVal, 0));
        }

        ServiceURL getServiceURL() {
            return this.serviceURL;
        }

        boolean isOpenAndActive() {
            long val = this.state.get();
            return (val & 3L) == 0L;
        }
    }

    final class AggregateHandle
    extends AggregateServiceRegistration {
        private final List<Handle> registrations;

        AggregateHandle(List<Handle> asList, Handle ... registrations) {
            super(registrations);
            this.registrations = asList;
        }

        @Override
        public void close() {
            LocalRegistryAndDiscoveryProvider.this.handles.removeAll(this.registrations);
            super.close();
        }
    }
}

