/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.modcluster.config.ModClusterConfiguration;
import org.jboss.modcluster.config.ProxyConfiguration;
import org.jboss.modcluster.config.SSLConfiguration;
import org.jboss.modcluster.config.SessionDrainingStrategy;
import org.jboss.modcluster.config.builder.ModClusterConfigurationBuilder;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.config.impl.SessionDrainingStrategyEnum;
import org.jboss.modcluster.mcmp.impl.JSSESocketFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerService;
import org.wildfly.extension.mod_cluster.ModClusterConfigResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterSSLResourceDefinition;

public class ModClusterConfigurationServiceBuilder
implements ResourceServiceBuilder<ModClusterConfiguration>,
Value<ModClusterConfiguration> {
    private final ModClusterConfigurationBuilder builder = new ModClusterConfigurationBuilder();
    private ValueDependency<SocketBinding> advertiseSocketDependency = null;
    private final List<ValueDependency<OutboundSocketBinding>> outboundSocketBindings = new LinkedList<ValueDependency<OutboundSocketBinding>>();
    private ValueDependency<SSLContext> sslContextDependency = null;

    public ServiceName getServiceName() {
        return ContainerEventHandlerService.CONFIG_SERVICE_NAME;
    }

    public Builder<ModClusterConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNodes.optionalString((ModelNode)ModClusterConfigResourceDefinition.ADVERTISE_SOCKET.resolveModelAttribute(context, model)).ifPresent(advertiseSocketRef -> {
            this.advertiseSocketDependency = new InjectedValueDependency(context.getCapabilityServiceName(CommonUnaryRequirement.SOCKET_BINDING.getName(), advertiseSocketRef, SocketBinding.class), SocketBinding.class);
        });
        ModelNodes.optionalString((ModelNode)ModClusterConfigResourceDefinition.ADVERTISE_SECURITY_KEY.resolveModelAttribute(context, model)).ifPresent(securityKey -> this.builder.advertise().setAdvertiseSecurityKey(securityKey));
        this.builder.mcmp().setAdvertise(Boolean.valueOf(ModClusterConfigResourceDefinition.ADVERTISE.resolveModelAttribute(context, model).asBoolean())).setProxyURL(ModClusterConfigResourceDefinition.PROXY_URL.resolveModelAttribute(context, model).asString()).setAutoEnableContexts(ModClusterConfigResourceDefinition.AUTO_ENABLE_CONTEXTS.resolveModelAttribute(context, model).asBoolean()).setStopContextTimeout((long)ModClusterConfigResourceDefinition.STOP_CONTEXT_TIMEOUT.resolveModelAttribute(context, model).asInt()).setStopContextTimeoutUnit(TimeUnit.valueOf(ModClusterConfigResourceDefinition.STOP_CONTEXT_TIMEOUT.getMeasurementUnit().getName())).setSocketTimeout(ModClusterConfigResourceDefinition.SOCKET_TIMEOUT.resolveModelAttribute(context, model).asInt() * 1000).setSessionDrainingStrategy((SessionDrainingStrategy)Enum.valueOf(SessionDrainingStrategyEnum.class, ModClusterConfigResourceDefinition.SESSION_DRAINING_STRATEGY.resolveModelAttribute(context, model).asString()));
        if (model.hasDefined("excluded-contexts")) {
            Map<String, Set> excludedContextsPerHost;
            String contexts = ModClusterConfigResourceDefinition.EXCLUDED_CONTEXTS.resolveModelAttribute(context, model).asString();
            if (contexts == null) {
                excludedContextsPerHost = Collections.emptyMap();
            } else {
                String trimmedContexts = contexts.trim();
                if (trimmedContexts.isEmpty()) {
                    excludedContextsPerHost = Collections.emptyMap();
                } else {
                    excludedContextsPerHost = new HashMap();
                    for (String c : trimmedContexts.split(",")) {
                        String path;
                        String[] parts = c.trim().split(":");
                        if (parts.length > 2) {
                            throw ModClusterLogger.ROOT_LOGGER.excludedContextsWrongFormat(trimmedContexts);
                        }
                        String host = null;
                        String trimmedContext = parts[0].trim();
                        if (parts.length == 2) {
                            host = trimmedContext;
                            trimmedContext = parts[1].trim();
                        }
                        switch (trimmedContext) {
                            case "ROOT": {
                                ModClusterLogger.ROOT_LOGGER.excludedContextsUseSlashInsteadROOT();
                            }
                            case "/": {
                                path = "";
                                break;
                            }
                            default: {
                                trimmedContext = trimmedContext.startsWith("/") ? trimmedContext : "/" + trimmedContext;
                                path = trimmedContext.endsWith("/") ? trimmedContext.substring(0, trimmedContext.length() - 1) : trimmedContext;
                            }
                        }
                        Set paths = excludedContextsPerHost.computeIfAbsent(host, k -> new HashSet());
                        paths.add(path);
                    }
                }
            }
            this.builder.mcmp().setExcludedContextsPerHost(excludedContextsPerHost);
        }
        this.builder.balancer().setStickySession(ModClusterConfigResourceDefinition.STICKY_SESSION.resolveModelAttribute(context, model).asBoolean()).setStickySessionRemove(ModClusterConfigResourceDefinition.STICKY_SESSION_REMOVE.resolveModelAttribute(context, model).asBoolean()).setStickySessionForce(ModClusterConfigResourceDefinition.STICKY_SESSION_FORCE.resolveModelAttribute(context, model).asBoolean()).setWorkerTimeout(ModClusterConfigResourceDefinition.WORKER_TIMEOUT.resolveModelAttribute(context, model).asInt()).setMaxAttempts(ModClusterConfigResourceDefinition.MAX_ATTEMPTS.resolveModelAttribute(context, model).asInt());
        this.builder.node().setFlushPackets(ModClusterConfigResourceDefinition.FLUSH_PACKETS.resolveModelAttribute(context, model).asBoolean()).setFlushWait(ModClusterConfigResourceDefinition.FLUSH_WAIT.resolveModelAttribute(context, model).asInt()).setPing(ModClusterConfigResourceDefinition.PING.resolveModelAttribute(context, model).asInt()).setSmax(ModClusterConfigResourceDefinition.SMAX.resolveModelAttribute(context, model).asInt()).setTtl(ModClusterConfigResourceDefinition.TTL.resolveModelAttribute(context, model).asInt()).setNodeTimeout(ModClusterConfigResourceDefinition.NODE_TIMEOUT.resolveModelAttribute(context, model).asInt());
        ModelNodes.optionalString((ModelNode)ModClusterConfigResourceDefinition.BALANCER.resolveModelAttribute(context, model)).ifPresent(balancer -> this.builder.node().setBalancer(balancer));
        ModelNodes.optionalString((ModelNode)ModClusterConfigResourceDefinition.LOAD_BALANCING_GROUP.resolveModelAttribute(context, model)).ifPresent(group -> this.builder.node().setLoadBalancingGroup(group));
        ModelNodes.optionalList((ModelNode)ModClusterConfigResourceDefinition.PROXIES.resolveModelAttribute(context, model)).ifPresent(refs -> refs.stream().map(ModelNode::asString).forEach(ref -> this.outboundSocketBindings.add((ValueDependency<OutboundSocketBinding>)new InjectedValueDependency(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getServiceName(context, ref), OutboundSocketBinding.class))));
        if (model.hasDefined("proxy-list")) {
            throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.proxyListNotAllowedInCurrentModel());
        }
        Optional sslContextRef = ModelNodes.optionalString((ModelNode)ModClusterConfigResourceDefinition.SSL_CONTEXT.resolveModelAttribute(context, model));
        sslContextRef.ifPresent(ref -> {
            this.sslContextDependency = new InjectedValueDependency(CommonUnaryRequirement.SSL_CONTEXT.getServiceName(context, ref), SSLContext.class);
        });
        if (model.get(ModClusterSSLResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            if (sslContextRef.isPresent()) {
                throw ModClusterLogger.ROOT_LOGGER.bothElytronAndLegacySslContextDefined();
            }
            ModelNode sslModel = model.get(ModClusterSSLResourceDefinition.PATH.getKeyValuePair());
            ModClusterConfig sslConfiguration = new ModClusterConfig();
            ModelNodes.optionalString((ModelNode)ModClusterSSLResourceDefinition.KEY_ALIAS.resolveModelAttribute(context, sslModel)).ifPresent(arg_0 -> ((ModClusterConfig)sslConfiguration).setSslKeyAlias(arg_0));
            ModelNodes.optionalString((ModelNode)ModClusterSSLResourceDefinition.PASSWORD.resolveModelAttribute(context, sslModel)).ifPresent(arg_0 -> ((ModClusterConfig)sslConfiguration).setSslTrustStorePassword(arg_0));
            ModelNodes.optionalString((ModelNode)ModClusterSSLResourceDefinition.PASSWORD.resolveModelAttribute(context, sslModel)).ifPresent(arg_0 -> ((ModClusterConfig)sslConfiguration).setSslKeyStorePassword(arg_0));
            ModelNodes.optionalString((ModelNode)ModClusterSSLResourceDefinition.CERTIFICATE_KEY_FILE.resolveModelAttribute(context, sslModel)).ifPresent(arg_0 -> ((ModClusterConfig)sslConfiguration).setSslKeyStore(arg_0));
            ModelNodes.optionalString((ModelNode)ModClusterSSLResourceDefinition.CIPHER_SUITE.resolveModelAttribute(context, sslModel)).ifPresent(arg_0 -> ((ModClusterConfig)sslConfiguration).setSslCiphers(arg_0));
            ModelNodes.optionalString((ModelNode)ModClusterSSLResourceDefinition.PROTOCOL.resolveModelAttribute(context, sslModel)).ifPresent(arg_0 -> ((ModClusterConfig)sslConfiguration).setSslProtocol(arg_0));
            ModelNodes.optionalString((ModelNode)ModClusterSSLResourceDefinition.CA_CERTIFICATE_FILE.resolveModelAttribute(context, sslModel)).ifPresent(arg_0 -> ((ModClusterConfig)sslConfiguration).setSslTrustStore(arg_0));
            ModelNodes.optionalString((ModelNode)ModClusterSSLResourceDefinition.CA_REVOCATION_URL.resolveModelAttribute(context, sslModel)).ifPresent(arg_0 -> ((ModClusterConfig)sslConfiguration).setSslCrlFile(arg_0));
            this.builder.mcmp().setSocketFactory((SocketFactory)new JSSESocketFactory((SSLConfiguration)sslConfiguration));
        }
        return this;
    }

    public ServiceBuilder<ModClusterConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this));
        Stream.concat(Stream.of(this.advertiseSocketDependency, this.sslContextDependency), this.outboundSocketBindings.stream()).filter(Objects::nonNull).forEach(dependency -> dependency.register(builder));
        builder.setInitialMode(ServiceController.Mode.PASSIVE);
        return builder;
    }

    public ModClusterConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        if (this.advertiseSocketDependency != null) {
            SocketBinding binding = (SocketBinding)this.advertiseSocketDependency.getValue();
            this.builder.advertise().setAdvertiseSocketAddress(binding.getMulticastSocketAddress()).setAdvertiseInterface(binding.getSocketAddress().getAddress());
            if (!ModClusterConfigurationServiceBuilder.isMulticastEnabled(binding.getSocketBindings().getDefaultInterfaceBinding().getNetworkInterfaces())) {
                ModClusterLogger.ROOT_LOGGER.multicastInterfaceNotAvailable();
            }
        }
        LinkedList<1> proxies = new LinkedList<1>();
        for (ValueDependency<OutboundSocketBinding> outboundSocketBindingValueDependency : this.outboundSocketBindings) {
            final OutboundSocketBinding binding = (OutboundSocketBinding)outboundSocketBindingValueDependency.getValue();
            proxies.add(new ProxyConfiguration(){

                public InetSocketAddress getRemoteAddress() {
                    return new InetSocketAddress(binding.getUnresolvedDestinationAddress(), binding.getDestinationPort());
                }

                public InetSocketAddress getLocalAddress() {
                    if (binding.getOptionalSourceAddress() != null) {
                        return new InetSocketAddress(binding.getOptionalSourceAddress(), binding.getAbsoluteSourcePort() == null ? 0 : binding.getAbsoluteSourcePort());
                    }
                    if (binding.getAbsoluteSourcePort() != null) {
                        return new InetSocketAddress(binding.getAbsoluteSourcePort());
                    }
                    return null;
                }
            });
        }
        this.builder.mcmp().setProxyConfigurations(proxies);
        if (this.sslContextDependency != null) {
            this.builder.mcmp().setSocketFactory((SocketFactory)((SSLContext)this.sslContextDependency.getValue()).getSocketFactory());
        }
        return this.builder.build();
    }

    private static boolean isMulticastEnabled(Collection<NetworkInterface> interfaces) {
        for (NetworkInterface iface : interfaces) {
            try {
                if (!iface.isUp() || !iface.supportsMulticast() && !iface.isLoopback()) continue;
                return true;
            }
            catch (SocketException socketException) {
            }
        }
        return false;
    }
}

