/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.cluster.Transformer;
import org.jboss.logging.Logger;

public class DivertImpl
implements Divert {
    private static final Logger logger = Logger.getLogger(DivertImpl.class);
    private final PostOffice postOffice;
    private final SimpleString forwardAddress;
    private final SimpleString uniqueName;
    private final SimpleString routingName;
    private final boolean exclusive;
    private final Filter filter;
    private final Transformer transformer;
    private final StorageManager storageManager;

    public DivertImpl(SimpleString forwardAddress, SimpleString uniqueName, SimpleString routingName, boolean exclusive, Filter filter, Transformer transformer, PostOffice postOffice, StorageManager storageManager) {
        this.forwardAddress = forwardAddress;
        this.uniqueName = uniqueName;
        this.routingName = routingName;
        this.exclusive = exclusive;
        this.filter = filter;
        this.transformer = transformer;
        this.postOffice = postOffice;
        this.storageManager = storageManager;
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Diverting message " + message + " into " + this));
        }
        ServerMessage copy = null;
        if (!this.forwardAddress.equals((Object)message.getAddress())) {
            long id = this.storageManager.generateID();
            copy = message.copy(id);
            copy.setOriginalHeaders(message, null, false);
            copy.setAddress(this.forwardAddress);
            copy.setExpiration(message.getExpiration());
            if (this.transformer != null) {
                copy = this.transformer.transform(copy);
            }
        } else {
            copy = message;
        }
        this.postOffice.route(copy, null, context.getTransaction(), false);
    }

    @Override
    public void routeWithAck(ServerMessage message, RoutingContext context) throws Exception {
        this.route(message, context);
    }

    @Override
    public SimpleString getRoutingName() {
        return this.routingName;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    public String toString() {
        return "DivertImpl [routingName=" + this.routingName + ", uniqueName=" + this.uniqueName + ", forwardAddress=" + this.forwardAddress + ", exclusive=" + this.exclusive + ", filter=" + this.filter + ", transformer=" + this.transformer + "]";
    }
}

