/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.marshalling.reflect.JDKSpecific;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;

public final class SerializableClass {
    private static final SerializableClassRegistry REGISTRY = SerializableClassRegistry.getInstanceUnchecked();
    private final IdentityHashMap<Class<?>, Constructor<?>> nonInitConstructors;
    private final Class<?> subject;
    private final Method writeObject;
    private final Method writeReplace;
    private final Method readObject;
    private final Method readObjectNoData;
    private final Method readResolve;
    private final Constructor<?> noArgConstructor;
    private final Constructor<?> objectInputConstructor;
    private final SerializableField[] fields;
    private final Map<String, SerializableField> fieldsByName;
    private final long effectiveSerialVersionUID;
    private static final Comparator<? super SerializableField> NAME_COMPARATOR = new Comparator<SerializableField>(){

        @Override
        public int compare(SerializableField o1, SerializableField o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final SerializableField[] NOFIELDS = new SerializableField[0];

    SerializableClass(Class<?> subject) {
        Class<?> superclass;
        this.subject = subject;
        IdentityHashMap constructorMap = new IdentityHashMap();
        for (Class<?> t = subject.getSuperclass(); t != null; t = t.getSuperclass()) {
            SerializableClass lookedUp = REGISTRY.lookup(t);
            Constructor<?> constructor = lookedUp.noArgConstructor;
            if (constructor == null) continue;
            Constructor<?> newConstructor = JDKSpecific.newConstructorForSerialization(subject, constructor);
            newConstructor.setAccessible(true);
            constructorMap.put(t, newConstructor);
        }
        this.nonInitConstructors = constructorMap;
        Method writeObject = null;
        Method readObject = null;
        Method readObjectNoData = null;
        Method writeReplace = null;
        Method readResolve = null;
        for (Method method : subject.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            int modifiers = method.getModifiers();
            String methodName = method.getName();
            Class<?> methodReturnType = method.getReturnType();
            if (Modifier.isStatic(modifiers)) continue;
            if (Modifier.isPrivate(modifiers) && methodReturnType == Void.TYPE) {
                if (methodName.equals("writeObject")) {
                    parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1 || parameterTypes[0] != ObjectOutputStream.class) continue;
                    writeObject = method;
                    writeObject.setAccessible(true);
                    continue;
                }
                if (methodName.equals("readObject")) {
                    parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1 || parameterTypes[0] != ObjectInputStream.class) continue;
                    readObject = method;
                    readObject.setAccessible(true);
                    continue;
                }
                if (!methodName.equals("readObjectNoData") || (parameterTypes = method.getParameterTypes()).length != 0) continue;
                readObjectNoData = method;
                readObjectNoData.setAccessible(true);
                continue;
            }
            if (methodReturnType != Object.class) continue;
            if (methodName.equals("writeReplace")) {
                parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 0) continue;
                writeReplace = method;
                writeReplace.setAccessible(true);
                continue;
            }
            if (!methodName.equals("readResolve") || (parameterTypes = method.getParameterTypes()).length != 0) continue;
            readResolve = method;
            readResolve.setAccessible(true);
        }
        if ((readResolve == null || writeReplace == null) && (superclass = subject.getSuperclass()) != null) {
            SerializableClass superInfo = REGISTRY.lookup(superclass);
            Method otherReadResolve = superInfo.readResolve;
            if (readResolve == null && otherReadResolve != null && !Modifier.isPrivate(otherReadResolve.getModifiers())) {
                readResolve = otherReadResolve;
            }
            Method otherWriteReplace = superInfo.writeReplace;
            if (writeReplace == null && otherWriteReplace != null && !Modifier.isPrivate(otherWriteReplace.getModifiers())) {
                writeReplace = otherWriteReplace;
            }
        }
        Constructor<?> noArgConstructor = null;
        Constructor<?> objectInputConstructor = null;
        for (Constructor<?> constructor : subject.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length == 0) {
                noArgConstructor = constructor;
                noArgConstructor.setAccessible(true);
                continue;
            }
            if (parameterTypes.length != 1 || parameterTypes[0] != ObjectInput.class) continue;
            objectInputConstructor = constructor;
            objectInputConstructor.setAccessible(true);
        }
        this.writeObject = writeObject;
        this.readObject = readObject;
        this.readObjectNoData = readObjectNoData;
        this.noArgConstructor = noArgConstructor;
        this.objectInputConstructor = objectInputConstructor;
        this.readResolve = readResolve;
        this.writeReplace = writeReplace;
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(subject);
        this.effectiveSerialVersionUID = objectStreamClass == null ? 0L : objectStreamClass.getSerialVersionUID();
        HashMap<String, SerializableField> fieldsByName = new HashMap<String, SerializableField>();
        this.fields = SerializableClass.getSerializableFields(subject);
        for (SerializableField serializableField : this.fields) {
            fieldsByName.put(serializableField.getName(), serializableField);
        }
        this.fieldsByName = fieldsByName;
    }

    private static SerializableField[] getSerializableFields(Class<?> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        ObjectStreamField[] objectStreamFields = SerializableClass.getDeclaredSerialPersistentFields(clazz);
        if (objectStreamFields != null) {
            HashMap<String, Field> map = new HashMap<String, Field>();
            for (Field field : declaredFields) {
                field.setAccessible(true);
                map.put(field.getName(), field);
            }
            SerializableField[] fields = new SerializableField[objectStreamFields.length];
            for (int i = 0; i < objectStreamFields.length; ++i) {
                ObjectStreamField field = objectStreamFields[i];
                String name = field.getName();
                Field realField = (Field)map.get(name);
                fields[i] = realField != null && realField.getType() == field.getType() ? new SerializableField(field.getType(), name, field.isUnshared(), realField) : new SerializableField(field.getType(), name, field.isUnshared(), null);
            }
            Arrays.sort(fields, NAME_COMPARATOR);
            return fields;
        }
        ArrayList<SerializableField> fields = new ArrayList<SerializableField>(declaredFields.length);
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            field.setAccessible(true);
            fields.add(new SerializableField(field.getType(), field.getName(), false, field));
        }
        Collections.sort(fields, NAME_COMPARATOR);
        return fields.toArray(new SerializableField[fields.size()]);
    }

    private static ObjectStreamField[] getDeclaredSerialPersistentFields(Class<?> clazz) {
        Field field;
        try {
            field = clazz.getDeclaredField("serialPersistentFields");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        if (field == null) {
            return null;
        }
        int requiredModifiers = 26;
        if ((field.getModifiers() & 0x1A) != 26) {
            return null;
        }
        field.setAccessible(true);
        try {
            return (ObjectStreamField[])field.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public SerializableField[] getFields() {
        return this.fields;
    }

    public SerializableField getSerializableField(String name, Class<?> fieldType, boolean unshared) throws ClassNotFoundException {
        SerializableField serializableField = this.fieldsByName.get(name);
        if (serializableField != null) {
            return serializableField;
        }
        return new SerializableField(fieldType, name, unshared, null);
    }

    public boolean hasWriteObject() {
        return this.writeObject != null;
    }

    public void callWriteObject(Object object, ObjectOutputStream outputStream) throws IOException {
        try {
            this.writeObject.invoke(object, outputStream);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadObject() {
        return this.readObject != null;
    }

    public void callReadObject(Object object, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        try {
            this.readObject.invoke(object, inputStream);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadObjectNoData() {
        return this.readObjectNoData != null;
    }

    public void callReadObjectNoData(Object object) throws ObjectStreamException {
        try {
            this.readObjectNoData.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasWriteReplace() {
        return this.writeReplace != null;
    }

    public Object callWriteReplace(Object object) throws ObjectStreamException {
        try {
            return this.writeReplace.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadResolve() {
        return this.readResolve != null;
    }

    public Object callReadResolve(Object object) throws ObjectStreamException {
        try {
            return this.readResolve.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasPublicNoArgConstructor() {
        return this.noArgConstructor != null && Modifier.isPublic(this.noArgConstructor.getModifiers());
    }

    public Object callNoArgConstructor() throws IOException {
        return SerializableClass.invokeConstructor(this.noArgConstructor, new Object[0]);
    }

    public boolean hasObjectInputConstructor() {
        return this.objectInputConstructor != null && Modifier.isPublic(this.objectInputConstructor.getModifiers());
    }

    public Object callObjectInputConstructor(ObjectInput objectInput) throws IOException {
        return SerializableClass.invokeConstructor(this.objectInputConstructor, objectInput);
    }

    public boolean hasNoInitConstructor(Class<?> target) {
        return this.nonInitConstructors.containsKey(target);
    }

    public Object callNonInitConstructor(Class<?> target) {
        return SerializableClass.invokeConstructorNoException(this.nonInitConstructors.get(target), new Object[0]);
    }

    private static <T> T invokeConstructor(Constructor<T> constructor, Object ... args) throws IOException {
        if (constructor == null) {
            throw new IllegalArgumentException("No matching constructor");
        }
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Instantiation failed unexpectedly");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Constructor is unexpectedly inaccessible");
        }
    }

    private static <T> T invokeConstructorNoException(Constructor<T> constructor, Object ... args) {
        if (constructor == null) {
            throw new IllegalArgumentException("No matching constructor");
        }
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Instantiation failed unexpectedly");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Constructor is unexpectedly inaccessible");
        }
    }

    public long getEffectiveSerialVersionUID() {
        return this.effectiveSerialVersionUID;
    }

    public Class<?> getSubjectClass() {
        return this.subject;
    }

    <T> Constructor<T> getNoArgConstructor() {
        return this.noArgConstructor;
    }

    public String toString() {
        return String.format("Serializable %s", this.getSubjectClass());
    }

    <T> Constructor<T> getNoInitConstructor() {
        Class<?> clazz = this.getClass();
        while (Serializable.class.isAssignableFrom(clazz)) {
            clazz = clazz.getSuperclass();
        }
        return this.nonInitConstructors.get(clazz);
    }
}

