/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.security;

import java.security.Principal;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.util.SubjectUtil;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class ElytronSecurityDomainContextImpl
implements SecurityDomainContext {
    private final SecurityDomain securityDomain;
    private final ThreadLocal<SecurityIdentity> currentIdentity = new ThreadLocal();

    public ElytronSecurityDomainContextImpl(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public boolean doesUserHaveRole(Principal principal, Set<Principal> principals) {
        return true;
    }

    public String getSecurityDomain() {
        return this.securityDomain.toString();
    }

    public Set<Principal> getUserRoles(Principal principal) {
        return null;
    }

    public boolean isValid(Principal principal, Object password, Subject subject) {
        if (subject == null) {
            subject = new Subject();
        }
        String username = principal.getName();
        if (!(password instanceof String)) {
            throw new IllegalArgumentException("only string password accepted");
        }
        SecurityIdentity identity = this.authenticate(username, (String)password);
        if (identity == null) {
            return false;
        }
        SubjectUtil.fromSecurityIdentity(identity, subject);
        this.currentIdentity.set(identity);
        return true;
    }

    public void runAs(Callable<Void> action) throws Exception {
        SecurityIdentity ci = this.currentIdentity.get();
        if (ci != null) {
            ci.runAs(action);
            this.currentIdentity.set(null);
        } else {
            action.call();
        }
    }

    public void pushSubjectContext(Subject arg0, Principal arg1, Object arg2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityIdentity authenticate(String username, String password) {
        ServerAuthenticationContext context = this.securityDomain.createNewAuthenticationContext();
        PasswordGuessEvidence evidence = new PasswordGuessEvidence(password != null ? password.toCharArray() : null);
        try {
            context.setAuthenticationName(username);
            if (context.verifyEvidence((Evidence)evidence)) {
                if (context.authorize()) {
                    context.succeed();
                    SecurityIdentity securityIdentity = context.getAuthorizedIdentity();
                    return securityIdentity;
                }
                context.fail();
                WSLogger.ROOT_LOGGER.failedAuthorization(username);
            } else {
                context.fail();
                WSLogger.ROOT_LOGGER.failedAuthentication(username);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | RealmUnavailableException e) {
            context.fail();
            WSLogger.ROOT_LOGGER.failedAuthenticationWithException(e, username, e.getMessage());
        }
        finally {
            if (!context.isDone()) {
                context.fail();
            }
            evidence.destroy();
        }
        return null;
    }
}

