/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EJBSecurityDomainService;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.ApplicationSecurityDomainConfig;
import org.jboss.as.ejb3.subsystem.ApplicationSecurityDomainService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class EJBDefaultSecurityDomainProcessor
implements DeploymentUnitProcessor {
    private volatile String defaultSecurityDomainName;
    private volatile Function<String, ApplicationSecurityDomainConfig> knownSecurityDomain;
    private volatile BooleanSupplier outflowSecurityDomainsConfigured;

    public EJBDefaultSecurityDomainProcessor(String defaultSecurityDomainName, Function<String, ApplicationSecurityDomainConfig> knownSecurityDomain, BooleanSupplier outflowSecurityDomainsConfigured) {
        this.defaultSecurityDomainName = defaultSecurityDomainName;
        this.knownSecurityDomain = knownSecurityDomain;
        this.outflowSecurityDomainsConfigured = outflowSecurityDomainsConfigured;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (eeModuleDescription == null) {
            return;
        }
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        if (componentDescriptions == null || componentDescriptions.isEmpty()) {
            return;
        }
        String defaultSecurityDomain = eeModuleDescription.getDefaultSecurityDomain() == null ? this.defaultSecurityDomainName : eeModuleDescription.getDefaultSecurityDomain();
        String knownSecurityDomainName = null;
        boolean gotKnownSecurityDomain = false;
        for (ComponentDescription componentDescription : componentDescriptions) {
            if (!(componentDescription instanceof EJBComponentDescription)) continue;
            EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentDescription;
            ejbComponentDescription.setDefaultSecurityDomain(defaultSecurityDomain);
            ejbComponentDescription.setKnownSecurityDomainFunction(this.knownSecurityDomain);
            ejbComponentDescription.setOutflowSecurityDomainsConfigured(this.outflowSecurityDomainsConfigured);
            if (!ejbComponentDescription.isSecurityDomainKnown()) continue;
            if (!gotKnownSecurityDomain) {
                knownSecurityDomainName = ejbComponentDescription.getSecurityDomain();
                gotKnownSecurityDomain = true;
                continue;
            }
            if (knownSecurityDomainName.equals(ejbComponentDescription.getSecurityDomain())) continue;
            throw EjbLogger.ROOT_LOGGER.multipleSecurityDomainsDetected();
        }
        if (knownSecurityDomainName != null && !knownSecurityDomainName.isEmpty()) {
            EJBSecurityDomainService ejbSecurityDomainService = new EJBSecurityDomainService(deploymentUnit);
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
            ServiceName serviceName = deploymentUnit.getServiceName().append(EJBSecurityDomainService.SERVICE_NAME);
            ServiceBuilder builder = phaseContext.getServiceTarget().addService(serviceName, (Service)ejbSecurityDomainService).addDependency(support.getCapabilityServiceName("org.wildfly.ejb3.application-security-domain", new String[]{knownSecurityDomainName}), ApplicationSecurityDomainService.ApplicationSecurityDomain.class, ejbSecurityDomainService.getApplicationSecurityDomainInjector());
            builder.install();
            for (ComponentDescription componentDescription : componentDescriptions) {
                if (!(componentDescription instanceof EJBComponentDescription)) continue;
                componentDescription.getConfigurators().add((context, description, configuration) -> configuration.getCreateDependencies().add((serviceBuilder, service) -> serviceBuilder.addDependency(serviceName)));
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    public void setDefaultSecurityDomainName(String securityDomainName) {
        this.defaultSecurityDomainName = securityDomainName;
    }
}

