/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.msc.service.ServiceController;

public class EnlistmentTraceAttributeWriteHandler
extends AbstractWriteAttributeHandler<List<DataSource>> {
    protected EnlistmentTraceAttributeWriteHandler() {
        super(new AttributeDefinition[]{Constants.ENLISTMENT_TRACE});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String parameterName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<List<DataSource>> handbackHolder) throws OperationFailedException {
        String jndiName = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().get(Constants.JNDI_NAME.getName()).asString();
        ServiceController managementRepoService = context.getServiceRegistry(false).getService(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE);
        Boolean boolValue = Constants.ENLISTMENT_TRACE.resolveValue(context, newValue).asBoolean();
        try {
            ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
            if (repository.getDataSources() != null) {
                repository.getDataSources().stream().filter(ds -> jndiName.equalsIgnoreCase(ds.getJndiName())).forEach(ds -> ds.setEnlistmentTrace(boolValue));
                handbackHolder.setHandback(repository.getDataSources().stream().filter(ds -> jndiName.equalsIgnoreCase(ds.getJndiName())).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToSetAttribute(e.getLocalizedMessage()));
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String parameterName, ModelNode valueToRestore, ModelNode valueToRevert, List<DataSource> handback) throws OperationFailedException {
        Boolean value = Constants.ENLISTMENT_TRACE.resolveValue(context, valueToRestore).asBoolean();
        if (handback != null) {
            handback.stream().forEach(ds -> ds.setEnlistmentTrace(value));
        }
    }
}

