/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal.deployment;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.NarayanaTransactionIntegration;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ImmediateManagedReference;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.datasources.agroal.logging.AgroalLogger;
import org.wildfly.extension.datasources.agroal.logging.LoggingDataSourceListener;
import org.wildfly.transaction.client.ContextTransactionManager;

public class DataSourceDefinitionService
implements Service<ManagedReferenceFactory>,
ContextListAndJndiViewManagedReferenceFactory {
    private final String dataSourceName;
    private final String jndiBinding;
    private final boolean transactional;
    private final AgroalDataSourceConfigurationSupplier dataSourceConfiguration;
    private final Supplier<TransactionSynchronizationRegistry> tsrSupplier;
    private AgroalDataSource agroalDataSource;

    public DataSourceDefinitionService(ContextNames.BindInfo bindInfo, boolean transactional, AgroalDataSourceConfigurationSupplier dataSourceConfiguration, Supplier<TransactionSynchronizationRegistry> tsrSupplier) {
        this.dataSourceName = bindInfo.getParentContextServiceName().getSimpleName() + "." + bindInfo.getBindName().replace('/', '.');
        this.jndiBinding = bindInfo.getBindName();
        this.transactional = transactional;
        this.tsrSupplier = tsrSupplier;
        this.dataSourceConfiguration = dataSourceConfiguration;
    }

    public String getInstanceClassName() {
        return this.agroalDataSource == null ? DEFAULT_INSTANCE_CLASS_NAME : this.agroalDataSource.getClass().getName();
    }

    public String getJndiViewInstanceValue() {
        return this.agroalDataSource == null ? "?" : this.agroalDataSource.toString();
    }

    public void start(StartContext context) throws StartException {
        if (this.transactional) {
            TransactionSynchronizationRegistry transactionSynchronizationRegistry;
            ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();
            TransactionSynchronizationRegistry transactionSynchronizationRegistry2 = transactionSynchronizationRegistry = this.tsrSupplier != null ? this.tsrSupplier.get() : null;
            if (transactionManager == null || transactionSynchronizationRegistry == null) {
                throw AgroalLogger.SERVICE_LOGGER.missingTransactionManager();
            }
            NarayanaTransactionIntegration txIntegration = new NarayanaTransactionIntegration((TransactionManager)transactionManager, transactionSynchronizationRegistry, this.jndiBinding, false);
            this.dataSourceConfiguration.connectionPoolConfiguration().transactionIntegration((TransactionIntegration)txIntegration);
        }
        try {
            this.agroalDataSource = AgroalDataSource.from((Supplier)this.dataSourceConfiguration, (AgroalDataSourceListener[])new AgroalDataSourceListener[]{new LoggingDataSourceListener(this.dataSourceName)});
            AgroalLogger.SERVICE_LOGGER.startedDataSource(this.dataSourceName, this.jndiBinding);
        }
        catch (SQLException e) {
            this.agroalDataSource = null;
            throw AgroalLogger.SERVICE_LOGGER.datasourceStartException(e, this.dataSourceName);
        }
    }

    public void stop(StopContext context) {
        this.agroalDataSource.close();
        AgroalLogger.SERVICE_LOGGER.stoppedDataSource(this.dataSourceName);
    }

    public ManagedReferenceFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ManagedReference getReference() {
        return new ImmediateManagedReference((Object)this.agroalDataSource);
    }
}

