/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl;

import javax.inject.Inject;
import org.jboss.forge.addon.manager.AddonManager;
import org.jboss.forge.addon.manager.InstallRequest;
import org.jboss.forge.addon.manager.impl.InstallRequestImpl;
import org.jboss.forge.container.Forge;
import org.jboss.forge.container.addons.AddonId;
import org.jboss.forge.container.repositories.AddonRepository;
import org.jboss.forge.container.repositories.MutableAddonRepository;
import org.jboss.forge.dependencies.AddonDependencyResolver;
import org.jboss.forge.dependencies.DependencyNode;
import org.jboss.forge.dependencies.DependencyQuery;
import org.jboss.forge.dependencies.builder.DependencyQueryBuilder;

public class AddonManagerImpl
implements AddonManager {
    private AddonDependencyResolver resolver;
    private Forge forge;

    @Inject
    public AddonManagerImpl(Forge forge, AddonDependencyResolver resolver) {
        this.forge = forge;
        this.resolver = resolver;
    }

    public InstallRequest install(AddonId id) {
        String coordinates = id.getName() + ":jar:forge-addon:" + id.getVersion();
        DependencyNode requestedAddonNode = this.resolver.resolveAddonDependencyHierarchy((DependencyQuery)DependencyQueryBuilder.create((String)coordinates));
        return new InstallRequestImpl(this, this.forge, requestedAddonNode);
    }

    public boolean remove(AddonId id) {
        for (AddonRepository repository : this.forge.getRepositories()) {
            if (!(repository instanceof MutableAddonRepository) || !repository.isEnabled(id)) continue;
            return ((MutableAddonRepository)repository).undeploy(id);
        }
        return false;
    }

    public boolean disable(AddonId id) {
        for (AddonRepository repository : this.forge.getRepositories()) {
            if (!(repository instanceof MutableAddonRepository) || !repository.isEnabled(id)) continue;
            return ((MutableAddonRepository)repository).disable(id);
        }
        return false;
    }
}

